/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.pfd.AddItemActionListener;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.pfd.Job;
import com.sas.scheduler.pfd.Subflow;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionAddItemByFolder
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;
    private AddItemActionListener m_addItemListener;
    private ActionListener m_jobPropertiesListener;

    public ActionAddItemByFolder(Frame frame, FlowPFDView panel, FlowInfo flow, AddItemActionListener addItemActionListener, ActionListener jobPropertiesListener) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        this.m_addItemListener = addItemActionListener;
        this.m_addItemListener.setPropertiesListener(jobPropertiesListener);
        this.m_jobPropertiesListener = jobPropertiesListener;
        String nameString = m_bundle.getString("ActionAddItemByFolder.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.NODE_Job));
        this.putValue("ShortDescription", m_bundle.getString("ActionAddItemByFolder.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_addItemListener != null) {
            this.m_addItemListener.actionPerformed(new ActionEvent(this.m_flow, 1001, null));
            List<JobInfo> addedJobs = this.m_addItemListener.getReturnValue();
            if (addedJobs != null && addedJobs.size() > 0) {
                for (int i = 0; i < addedJobs.size(); ++i) {
                    JobInfo job = addedJobs.get(i);
                    if (job.isSubflow()) {
                        this.m_panel.addNode((PFDAbstractNode)new Subflow(job, this.m_frame));
                        continue;
                    }
                    Job jnode = new Job(job, this.m_frame);
                    if (this.m_jobPropertiesListener != null) {
                        jnode.setPropertiesListener(this.m_jobPropertiesListener);
                    }
                    this.m_panel.addNode((PFDAbstractNode)jnode);
                }
            }
        }
    }

    static {
        String strClassName = ActionAddItemByFolder.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

