/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.svcs.content.search.retrieval.dao.CommentCache;
import com.sas.svcs.content.search.retrieval.dao.util.AbstractIndexDataCommentsUtil;
import java.rmi.RemoteException;
import java.util.List;

public class OMRIndexDataCommentsUtil
extends AbstractIndexDataCommentsUtil {
    ServerInterface server = null;

    public void setServerInterface(ServerInterface server) {
        this.server = server;
    }

    protected void mapGuidsToCache(CommentCache commentCache, List<String> updatedGuids) {
        if (updatedGuids.size() > 0) {
            String template = "<Templates><ExternalIdentity><OwningObject/></ExternalIdentity></Templates>";
            StringBuilder sb = new StringBuilder();
            sb.append("<XMLSelect search=\"ExternalIdentity[");
            boolean isFirst = true;
            for (String guid : updatedGuids) {
                if (!isFirst) {
                    sb.append(" or ");
                }
                isFirst = false;
                sb.append("@Identifier='" + guid + "'");
            }
            sb.append("]\"/>");
            Filter filter = new Filter();
            filter.setType("ExternalIdentity");
            filter.setOMRTemplate(template);
            filter.setExplicitSearchString("omi", sb.toString());
            try {
                List guidsList = this.server.browseSearch((FilterInterface)filter);
                for (BrowseMetadata nextBmi : guidsList) {
                    String guid = (String)nextBmi.get("Identifier");
                    String objectId = null;
                    String publicType = null;
                    List ownerList = (List)nextBmi.get("OwningObject");
                    if (ownerList != null) {
                        BrowseMetadata owner = (BrowseMetadata)ownerList.get(0);
                        objectId = owner.getReposId();
                        publicType = (String)owner.get("PublicType");
                    }
                    if (guid == null || objectId == null || publicType == null) continue;
                    commentCache.addComment(publicType, objectId);
                }
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }
}

