/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.retrieval.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.comments.client.CommentServiceInterface;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.lookup.client.LookupService;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import com.sas.svcs.content.relationship.client.RelationshipService;
import com.sas.svcs.content.search.client.ContentSearchObject;
import com.sas.svcs.content.search.client.IndexDataAttribute;
import com.sas.svcs.content.search.retrieval.dao.CommentCache;
import com.sas.svcs.content.search.retrieval.dao.omr.OMRIndexDataCommentsUtil;
import com.sas.svcs.content.search.retrieval.dao.omr.OMRIndexDataSupportTemplate;
import com.sas.svcs.content.search.retrieval.dao.util.IndexDataRelationshipUtil;
import com.sas.svcs.content.search.spi.IndexDataSchemaDAO;
import com.sas.svcs.notifications.client.AlertNotificationRetrievalServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BaseOMRIndexDataDAO
implements IndexDataSchemaDAO {
    protected CommentCache commentCache = new CommentCache();
    protected OMRIndexDataSupportTemplate supportTemplate = new OMRIndexDataSupportTemplate();
    protected OMRIndexDataCommentsUtil commentsUtil = new OMRIndexDataCommentsUtil();
    protected IndexDataRelationshipUtil relationshipUtil = new IndexDataRelationshipUtil();
    protected ObjectTypeService typeService;
    protected MetadataTemplate metadataTemplate;
    private static final Logger logger = LogManager.getLogger(BaseOMRIndexDataDAO.class);
    private AlertNotificationRetrievalServiceInterface notificationRetrievalService;

    @Autowired
    public void setRelationshipService(RelationshipService relationshipService) {
        this.relationshipUtil.setRelationshipService(relationshipService);
    }

    @Autowired
    void setLookupService(LookupService lookupService) {
        this.relationshipUtil.setLookupService(lookupService);
    }

    @Autowired
    public void setNotificationRetrievalService(AlertNotificationRetrievalServiceInterface notificationRetrievalService) {
        this.notificationRetrievalService = notificationRetrievalService;
        this.commentsUtil.setAlertNotificationRetrievalService(notificationRetrievalService);
    }

    @Autowired
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.typeService = objectTypeService;
    }

    @Autowired
    public void setMetadataTemplate(MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    @Autowired
    public void setCommentService(CommentServiceInterface commentService) {
        this.commentsUtil.setCommentService(commentService);
    }

    protected TypeDescriptorInterface getTypeDescriptor(String name) {
        UserContextInterface user = this.metadataTemplate.getUserContext();
        TypeDescriptorInterface result = null;
        try {
            ServerInterface server = user.getAuthServer();
            result = server.getTypeDescriptor(name);
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected Set<ContentSearchObject> getAllObjects(long objectType, boolean doBrowse) {
        ObjectType theType = this.typeService.getTypeById(objectType);
        if (theType == null) {
            logger.warn("There was no valid object type found for type " + objectType);
            return null;
        }
        UserContextInterface user = this.metadataTemplate.getUserContext();
        List commentList = new ArrayList();
        ArrayList<String> guidList = new ArrayList<String>();
        ArrayList<ObjectIdentity> identityList = new ArrayList<ObjectIdentity>();
        HashSet<ContentSearchObject> result = new HashSet<ContentSearchObject>();
        try {
            Object identity;
            String guid;
            ServerInterface server = user.getAuthServer();
            TypeDescriptorInterface tdi = this.getTypeDescriptor(theType.getName());
            String metadataType = tdi != null ? tdi.getMetadataType() : "Root";
            Filter filter = this.supportTemplate.makeFilter(theType.getName(), metadataType, null, null);
            if (!doBrowse) {
                List metadataList = server.search((FilterInterface)filter);
                for (MetadataInterface nextMi : metadataList) {
                    String guid2 = nextMi.getGUID();
                    if (guid2 != null) {
                        guidList.add(guid2);
                    }
                    ObjectIdentity identity2 = new ObjectIdentity(objectType, nextMi.getReposKey());
                    identityList.add(identity2);
                    ContentSearchObject nextObject = this.supportTemplate.makeSearchObjectFromMetadata(nextMi, objectType);
                    try {
                        this.addAdditionalMetaAttributes(nextObject.getAttributes(), nextMi);
                    }
                    catch (Throwable t) {
                        logger.warn("An exception occurred that may result in missing index data.", t);
                    }
                    result.add(nextObject);
                }
            } else {
                ArrayList<String> processedIdList = new ArrayList<String>();
                List browseList = server.browseSearch((FilterInterface)filter);
                for (BrowseMetadata nextBmi : browseList) {
                    guid = this.supportTemplate.getGUID(nextBmi);
                    if (guid != null) {
                        guidList.add(guid);
                    }
                    identity = new ObjectIdentity(objectType, nextBmi.getReposId() + "/" + nextBmi.getNativeType());
                    identityList.add((ObjectIdentity)identity);
                    ContentSearchObject nextObject = this.supportTemplate.makeSearchObjectFromBrowse(nextBmi, objectType);
                    processedIdList.add(nextBmi.getReposId());
                    try {
                        this.addAdditionalAttributes(nextObject.getAttributes(), nextBmi);
                    }
                    catch (Throwable t) {
                        logger.warn("An exception occurred which might result in missing index data.", t);
                    }
                    result.add(nextObject);
                }
            }
            Map relationshipMap = this.relationshipUtil.getRelationshipData(identityList);
            if (guidList.size() > 0) {
                commentList = this.commentsUtil.getAllComments(guidList);
            }
            for (ContentSearchObject nextObject : result) {
                Map relationships;
                Map attributes = nextObject.getAttributes();
                guid = (String)attributes.get("guid");
                if (guid != null) {
                    this.commentsUtil.addComments(commentList, attributes);
                }
                if ((relationships = (Map)relationshipMap.get(identity = (String)attributes.get("sasid"))) == null) continue;
                attributes.putAll(relationships);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    public Set<ContentSearchObject> getObjects(long objectType, Date modifiedSince, boolean doBrowse) {
        ObjectType theType = this.typeService.getTypeById(objectType);
        if (theType == null) {
            logger.warn("There was no valid object type found for type " + objectType);
            return null;
        }
        if (modifiedSince == null) {
            return this.getAllObjects(objectType, doBrowse);
        }
        UserContextInterface user = this.metadataTemplate.getUserContext();
        List commentList = new ArrayList();
        ArrayList<String> guidList = new ArrayList<String>();
        HashSet<ContentSearchObject> result = new HashSet<ContentSearchObject>();
        try {
            String guid;
            ServerInterface server = user.getAuthServer();
            ArrayList<String> commentIds = null;
            commentIds = new ArrayList<String>();
            ArrayList<ObjectIdentity> identityList = new ArrayList<ObjectIdentity>();
            this.commentsUtil.setServerInterface(server);
            this.commentCache = this.commentsUtil.getCommentCache(this.commentCache, modifiedSince);
            List entries = this.commentCache.getCommentsOfType(theType.getName());
            for (Object entry : entries) {
                commentIds.add(entry.getIdentity());
            }
            Map relationshipMap = this.relationshipUtil.getRelationshipUpdates(modifiedSince, theType.getName());
            for (String identity : relationshipMap.keySet()) {
                String fqid = identity;
                int index = fqid.indexOf(47);
                if (index > -1) {
                    fqid = fqid.substring(0, index);
                }
                commentIds.add(fqid);
            }
            TypeDescriptorInterface tdi = this.getTypeDescriptor(theType.getName());
            String metadataType = tdi != null ? tdi.getMetadataType() : "Root";
            Filter filter = this.supportTemplate.makeFilter(theType.getName(), metadataType, modifiedSince, commentIds);
            if (!doBrowse) {
                List metadataList = server.search((FilterInterface)filter);
                for (MetadataInterface nextMi : metadataList) {
                    identityList.add(new ObjectIdentity(objectType, nextMi.getReposKey()));
                    guid = nextMi.getGUID();
                    if (guid != null) {
                        guidList.add(guid);
                    }
                    ContentSearchObject nextObject = this.supportTemplate.makeSearchObjectFromMetadata(nextMi, objectType);
                    try {
                        this.addAdditionalMetaAttributes(nextObject.getAttributes(), nextMi);
                    }
                    catch (Throwable t) {
                        logger.warn("An exception occurred that may result in missing index data.", t);
                    }
                    result.add(nextObject);
                }
            } else {
                ArrayList<String> processedIdList = new ArrayList<String>();
                List browseList = server.browseSearch((FilterInterface)filter);
                for (BrowseMetadata nextBmi : browseList) {
                    identityList.add(new ObjectIdentity(objectType, nextBmi.getReposId() + "/" + nextBmi.getNativeType()));
                    String guid2 = this.supportTemplate.getGUID(nextBmi);
                    if (guid2 != null) {
                        guidList.add(guid2);
                    }
                    ContentSearchObject nextObject = this.supportTemplate.makeSearchObjectFromBrowse(nextBmi, objectType);
                    processedIdList.add(nextBmi.getReposId());
                    try {
                        this.addAdditionalAttributes(nextObject.getAttributes(), nextBmi);
                    }
                    catch (Throwable t) {
                        logger.warn("An exception occurred which might result in missing index data.", t);
                    }
                    result.add(nextObject);
                }
            }
            if (guidList.size() > 0) {
                commentList = this.commentsUtil.getAllComments(guidList);
            }
            relationshipMap = this.relationshipUtil.getRelationshipData(identityList);
            for (ContentSearchObject nextObject : result) {
                String ident;
                Map relationship;
                Map attributes = nextObject.getAttributes();
                guid = (String)attributes.get("guid");
                if (guid != null) {
                    this.commentsUtil.addComments(commentList, attributes);
                }
                if ((relationship = (Map)relationshipMap.get(ident = (String)attributes.get("sasid"))) == null) continue;
                attributes.putAll(relationship);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
        return result;
    }

    protected void addAdditionalAttributes(Map<String, Object> attributeMap, BrowseMetadata bmi) {
    }

    protected void addAdditionalMetaAttributes(Map<String, Object> attributeMap, MetadataInterface mi) {
    }

    public List<IndexDataAttribute> getFieldMetadataForType(long typeId) {
        return this.supportTemplate.getDefaultFieldMetadata();
    }
}

