/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lookup.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.dao.omr.AbstractOmrDAO;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObjectDescriptor;
import com.sas.svcs.content.framework.client.ContentRuntimeException;
import com.sas.svcs.content.framework.client.ExtendedContentNode;
import com.sas.svcs.content.framework.client.ExtendedContentObject;
import com.sas.svcs.content.lookup.dao.BulkLookupDAO;
import com.sas.svcs.content.objecttype.client.ObjectType;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Repository;

@Repository(value="DefaultOMRLookupDAO")
public class DefaultOMRLookupDAO
extends AbstractOmrDAO
implements BulkLookupDAO {
    private static final Logger logger = LogManager.getLogger(DefaultOMRLookupDAO.class);

    public ContentObjectDescriptor findObject(ObjectIdentity objectIdentity) {
        ContentObjectDescriptor descriptor = null;
        String template = this.constructTemplate(objectIdentity);
        BrowseMetadata browse = null;
        try {
            browse = this.getBrowseMetadataById(objectIdentity.getId(), template);
        }
        catch (Exception e) {
            logger.error("Error fetching metadata object " + objectIdentity.getId() + ": " + e.getLocalizedMessage());
        }
        if (browse != null) {
            descriptor = this.populateDescriptor(browse);
        }
        return descriptor;
    }

    protected ContentObjectDescriptor populateDescriptor(BrowseMetadata browse) {
        String typeString;
        String path = this.getMetadataUtils().getPathFromBrowseMetadata((BrowseMetadataInterface)browse);
        Object contentObject = null;
        Class<? extends ContentComponent> cls = this.getContentObjectType();
        if (cls != null) {
            try {
                contentObject = cls.newInstance();
            }
            catch (Exception e) {
                logger.error("Error instantiating class: " + cls.getName(), (Throwable)e);
                throw new RuntimeException("Error instantiating class: " + cls.getName() + " - " + e.getMessage());
            }
        } else {
            contentObject = path == null || path.isEmpty() ? new ExtendedContentObject() : new ExtendedContentNode();
        }
        this.populateContentComponentFromBrowseData((ContentComponent)contentObject, browse);
        if (contentObject instanceof ContentNode && path != null && !path.isEmpty()) {
            ((ContentNode)contentObject).setPath(path);
        }
        if ((typeString = (String)browse.get("PublicType")) == null || typeString.isEmpty()) {
            typeString = browse.getSmartType();
        } else if (typeString.startsWith("Embedded:")) {
            typeString = typeString.substring("Embedded:".length());
        }
        ObjectType objectType = this.getObjectTypeService().getTypeByName(typeString);
        if (objectType == null) {
            contentObject.setObjectType(-1L);
            contentObject.setObjectTypeName("Unknown");
        } else {
            contentObject.setObjectTypeName(objectType.getName());
            contentObject.setObjectType(objectType.getId());
        }
        ContentObjectDescriptor descriptor = new ContentObjectDescriptor();
        descriptor.setContentObject(contentObject);
        return descriptor;
    }

    protected Class<? extends ContentComponent> getContentObjectType() {
        return null;
    }

    protected String constructTemplate(ObjectIdentity objectIdentity) {
        OMRRepositoryKey key = new OMRRepositoryKey(objectIdentity.getId());
        String metadataType = key.getType();
        String template = "<Templates><" + metadataType + "><Keywords/><ResponsibleParties/><Trees/></" + metadataType + "><ResponsibleParty><Persons /></ResponsibleParty><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
        return template;
    }

    private Map<ObjectIdentity, ContentObjectDescriptor> findHomogeneousObjects(List<ObjectIdentity> objectIdentities) {
        HashMap<ObjectIdentity, ContentObjectDescriptor> result = new HashMap<ObjectIdentity, ContentObjectDescriptor>();
        if (objectIdentities.size() == 0) {
            return result;
        }
        String template = this.constructTemplate(objectIdentities.get(0));
        StringBuilder sb = new StringBuilder();
        sb.append("<XMLSelect search=\"*[");
        boolean isFirst = true;
        for (ObjectIdentity identity : objectIdentities) {
            if (!isFirst) {
                sb.append(" or ");
            }
            isFirst = false;
            OMRRepositoryKey key = new OMRRepositoryKey(identity.getId());
            sb.append(" @Id='" + key.getId() + "'");
        }
        sb.append("]\"/>");
        OMRRepositoryKey key = new OMRRepositoryKey(objectIdentities.get(0).getId());
        Filter filter = new Filter();
        filter.setExplicitSearchString("omi", sb.toString());
        filter.setType(key.getType());
        filter.setOMRTemplate(template);
        UserContextInterface user = this.getUserContext();
        try {
            ServerInterface server = user.getAuthServer();
            List browseData = server.browseSearch((FilterInterface)filter);
            for (BrowseMetadata browseObject : browseData) {
                ContentObjectDescriptor descriptor = this.populateDescriptor(browseObject);
                ObjectIdentity identity = new ObjectIdentity(descriptor.getContentObject().getObjectType(), descriptor.getContentObject().getId());
                result.put(identity, descriptor);
            }
        }
        catch (ServiceException ex) {
            throw new ContentRuntimeException((Throwable)ex);
        }
        catch (RemoteException ex) {
            throw new ContentRuntimeException((Throwable)ex);
        }
        return result;
    }

    public Map<ObjectIdentity, ContentObjectDescriptor> findObjects(List<ObjectIdentity> objectIdentities) {
        HashMap<ObjectIdentity, ContentObjectDescriptor> result = new HashMap<ObjectIdentity, ContentObjectDescriptor>();
        HashMap<Long, ArrayList<ObjectIdentity>> identitiesTypeMap = new HashMap<Long, ArrayList<ObjectIdentity>>();
        for (ObjectIdentity identity : objectIdentities) {
            Long type = identity.getObjectType();
            ArrayList<ObjectIdentity> identityList = (ArrayList<ObjectIdentity>)identitiesTypeMap.get(type);
            if (identityList == null) {
                identityList = new ArrayList<ObjectIdentity>();
                identitiesTypeMap.put(type, identityList);
            }
            identityList.add(identity);
        }
        for (Long type : identitiesTypeMap.keySet()) {
            List identityList = (List)identitiesTypeMap.get(type);
            Map<ObjectIdentity, ContentObjectDescriptor> typeResult = this.findHomogeneousObjects(identityList);
            result.putAll(typeResult);
        }
        return result;
    }
}

