/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.content.lifecycle.client.ConnectionNotMappedException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.dao.mapping.ConnectionType;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRConnectionMapping;
import java.util.ArrayList;
import java.util.List;

@ConnectionType(typeNames={"Permission"})
public class PermissionMapping
extends AbstractOMRConnectionMapping {
    private static final String FETCH_PERMISSION_TEMPLATE = "<Templates><Permission Name=\"\" Type=\"\"/></Templates>";
    protected static final String PROPERTY_TYPE = "Type";
    private static final List<AttributeMapping> mappingList = new ArrayList<AttributeMapping>(1);

    @Override
    protected String getOMRTemplate() {
        return FETCH_PERMISSION_TEMPLATE;
    }

    public String getMappingName() {
        return "Permission";
    }

    @Override
    public List<AttributeMapping> getAttributeMapping(ConnectionPoint cp) {
        return mappingList;
    }

    public <T extends TransportNode> String findDefaultMapping(ConnectionPoint cp, ContentOperation<T> operation) throws ConnectionNotMappedException {
        String permissionName = cp.getName();
        String permissionType = cp.getProperty(PROPERTY_TYPE);
        Filter filter = new Filter();
        filter.setType("Permission");
        String search = "<XMLSelect search=\"*[@Name='" + permissionName + "' and @Type='" + permissionType + "']\"/>";
        filter.setExplicitSearchString("omi", search);
        return this.searchForConnectionPointId((FilterInterface)filter);
    }

    static {
        mappingList.add(new AttributeMapping(PROPERTY_TYPE, "String", "@Type"));
    }
}

