/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.svcs.content.lifecycle.dao.omr.FinishedParsingException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ImportOutputParser
extends DefaultHandler {
    private Map<String, String> _deployedObjectsMap = new HashMap<String, String>();
    private boolean _processingMetadata = false;
    private boolean _processingObjects = false;

    public Map<String, String> getDeployedObjectsMap() {
        return this._deployedObjectsMap;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._processingObjects) {
            if (attributes != null) {
                String sourceID = attributes.getValue("Source_Id");
                String targetID = attributes.getValue("Id");
                this._deployedObjectsMap.put(this.getObjectKey(sourceID, qName), this.getObjectKey(targetID, qName));
            }
        } else if (qName.equalsIgnoreCase("Metadata")) {
            this._processingMetadata = true;
        } else if (this._processingMetadata && qName.equalsIgnoreCase("Objects")) {
            this._processingObjects = true;
        }
    }

    private String getObjectKey(String id, String type) {
        return id + "/" + type;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._processingObjects && qName.equalsIgnoreCase("Objects")) {
            throw new FinishedParsingException();
        }
    }
}

