/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.lifecycle.client.ImportNode;
import com.sas.svcs.content.lifecycle.client.ImportOperation;
import com.sas.svcs.content.lifecycle.client.NodeProcessingState;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TargetTransportOperation;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.ImportDAO;
import com.sas.svcs.content.lifecycle.dao.NameValidator;
import com.sas.svcs.content.lifecycle.dao.NestedNodeMerger;
import com.sas.svcs.content.lifecycle.dao.TransportNodeRenameUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRPromotionDAO;
import com.sas.svcs.content.lifecycle.dao.omr.ImportMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.lifecycle.spi.ImportResult;
import com.sas.svcs.content.logging.client.LogItem;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportTypeSubpackage;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;

public class BaseOMRImportDAO
extends AbstractOMRPromotionDAO
implements ImportDAO {
    protected TransportNodeRenameUtil nodeRenameUtil;

    public BaseOMRImportDAO(String objectTypeName) {
        super(objectTypeName);
    }

    @Autowired
    public void setTransportNodeRenameUtil(TransportNodeRenameUtil nodeRenameUtil) {
        this.nodeRenameUtil = nodeRenameUtil;
    }

    public void validateContents(List<ImportNode> nodes, ImportOperation operation) throws ContentException {
    }

    public final ImportResult importObjects(List<ImportNode> nodes, ImportOperation operation) throws ContentException {
        ImportResult result = new ImportResult();
        if (this.objectTypeName != null) {
            this.runImportProcess(this.objectTypeName, nodes, operation, result);
        } else {
            Map nodesByType = this.splitNodesByType(nodes);
            for (String typeName : nodesByType.keySet()) {
                List list = (List)nodesByType.get(typeName);
                this.runImportProcess(typeName, list, operation, result);
            }
        }
        return result;
    }

    private void runImportProcess(String typeName, List<ImportNode> nodes, ImportOperation operation, ImportResult result) throws ContentException {
        String displayType = this.getDisplayType(typeName);
        this.logImportNodes(typeName, displayType, nodes, operation);
        boolean merge = false;
        try {
            this.preImportProcess(nodes, operation);
            NestedNodeMerger merger = this.getNodeMerger(operation);
            if (merger != null) {
                merge = true;
                merger.mergeNestedNodes(nodes);
            }
            this.importMetadata(typeName, nodes, operation, merge);
            for (ImportNode node : nodes) {
                node.setProcessingState(NodeProcessingState.SUCCESS);
            }
            this.postImportProcess(nodes, operation);
            this.importContent(nodes, operation);
            this.logMessage(operation, 400, RB.getStringResource("BaseOMRImportDAO.ImportComplete.txt", operation.getLocale()), typeName);
        }
        catch (Exception e) {
            this.logMessage((TransportOperation<?>)operation, 100, e.getLocalizedMessage());
            this.logMessage((TransportOperation<?>)operation, 500, "Cause", e);
        }
    }

    private void logImportNodes(String typeName, String displayType, List<ImportNode> nodes, ImportOperation operation) {
        this.logMessage(operation, 400, Message.format((String)RB.getStringResource("BaseOMRImportDAO.importCount.fmt.txt", operation.getLocale()), (Object)new Integer(nodes.size()), (Object)displayType), typeName);
        ArrayList<String> messages = new ArrayList<String>(nodes.size());
        for (ImportNode nextNode : nodes) {
            String msg = null;
            msg = TransportUtil.isOverwriting((TargetTransportNode)nextNode) ? Message.format((String)RB.getStringResource("BaseOMRImportDAO.OverwritingItem.fmt.txt", operation.getLocale()), (Object)nextNode.toString()) : Message.format((String)RB.getStringResource("BaseOMRImportDAO.CreatingItem.fmt.txt", operation.getLocale()), (Object)nextNode.toString());
            messages.add(msg);
        }
        this.logEnumerationMessages((TransportOperation)operation, 400, messages, typeName);
    }

    protected NameValidator getNameValidator() {
        return null;
    }

    protected NestedNodeMerger getNodeMerger(ImportOperation operation) {
        return null;
    }

    protected void preImportProcess(List<ImportNode> nodes, ImportOperation operation) throws ContentException {
    }

    protected void postImportProcess(List<ImportNode> nodes, ImportOperation operation) throws ContentException {
    }

    protected void importContent(List<ImportNode> importNodes, ImportOperation operation) throws ContentException {
    }

    private void importMetadata(String typeName, List<ImportNode> nodes, ImportOperation operation, boolean merge) throws ContentException {
        ExportTypeSubpackage typePackage = this.getTypeSubpackage(typeName, nodes, operation);
        List contentItems = typePackage.getContentItems();
        ContentItem transportContent = this.getContentItemFromPackage(contentItems, "TransportMetadata");
        ContentItem deployMapContent = this.getContentItemFromPackage(contentItems, "DeployMap");
        try {
            ImportMetadataUtil metadataUtil = new ImportMetadataUtil(operation);
            metadataUtil.setMetadataTemplate(this.getMetadataTemplate());
            metadataUtil.setStreamService(this.getStreamService());
            metadataUtil.setObjectTypeService(this.objectTypeService);
            metadataUtil.setMergeSupported(merge);
            this.validateNames(nodes, operation, metadataUtil);
            metadataUtil.importMetadata(nodes, transportContent, deployMapContent, operation.isIncludeAcls());
            this.logMessage(operation, 400, RB.getStringResource("BaseOMRImportDAO.MetadataComplete.txt", operation.getLocale()), typeName);
            try {
                metadataUtil.setCreatedModifiedBy(nodes);
            }
            catch (ContentException e) {
                this.logMessage((TransportOperation<?>)operation, 500, RB.getStringResource("BaseOMRImportDAO.CreatedModifiedByError.fmt.txt", operation.getLocale()), e);
            }
        }
        catch (Exception e) {
            String msg = Message.format((String)RB.getStringResource("BaseOMRImportDAO.MetadataError.fmt.txt", operation.getLocale()), (Object)e.getLocalizedMessage());
            throw new ContentException(msg, (Throwable)e);
        }
        finally {
            transportContent.setContent(null);
            deployMapContent.setContent(null);
        }
    }

    private void validateNames(List<ImportNode> nodes, ImportOperation operation, ImportMetadataUtil metadataUtil) throws ValidationException {
        ArrayList logItems = new ArrayList();
        List renamedNodes = this.nodeRenameUtil.getRenamedNodes(nodes, this.getNameValidator(), (TargetTransportOperation)operation, logItems);
        if (renamedNodes != null && !renamedNodes.isEmpty()) {
            for (ImportNode cn : renamedNodes) {
                metadataUtil.renameItem((TargetTransportNode)cn);
            }
        }
        for (LogItem logItem : logItems) {
            logItem.setId(operation.getContentLog().getId());
            this.contentLoggingService.addLogItem(logItem);
        }
    }

    private ExportTypeSubpackage getTypeSubpackage(String typeName, List<ImportNode> nodes, ImportOperation operation) throws ContentException {
        ObjectIdentity identity = new ObjectIdentity(159L, operation.getPackageId());
        ExportPackage exportPackage = this.getExportPackageService().getPackageById(identity);
        ExportTypeSubpackage typePackage = this.getSubpackage(exportPackage, typeName);
        if (typePackage == null) {
            throw new ContentException(Message.format((String)RB.getStringResource("BaseOMRImportDAO.nosubpackage.fmt.txt", operation.getLocale()), (Object)typeName));
        }
        return typePackage;
    }

    public Document getObjectDocument(ImportNode node, ImportOperation operation) throws ContentException {
        Map<String, Document> map = this.getObjectDocuments(Arrays.asList(node), operation);
        return map.get(node.getId());
    }

    public Map<String, Document> getObjectDocuments(List<ImportNode> nodes, ImportOperation operation) throws ContentException {
        String typeName = null;
        if (this.objectTypeName != null) {
            typeName = this.objectTypeName;
        } else if (!nodes.isEmpty()) {
            typeName = nodes.get(0).getContentObject().getObjectTypeName();
        }
        if (typeName == null) {
            throw new ContentException("Invalid object type name.  Cannot load type subpackage.");
        }
        ExportTypeSubpackage typePackage = this.getTypeSubpackage(typeName, nodes, operation);
        ContentItem transportContent = this.getContentItemFromPackage(typePackage, "TransportMetadata");
        ImportMetadataUtil metadataUtil = new ImportMetadataUtil(operation);
        metadataUtil.setStreamService(this.getStreamService());
        return metadataUtil.getObjectDocuments(nodes, transportContent, this.objectTypeService);
    }

    private void logMessage(ImportOperation operation, int priority, String text, String typeName) {
        this.logMessage((TransportOperation)operation, text, priority, null, typeName);
    }
}

