/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.svcs.commons.Identifiable;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.lifecycle.client.ExportNode;
import com.sas.svcs.content.lifecycle.client.ExportOperation;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.dao.ExportDAO;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRPromotionDAO;
import com.sas.svcs.content.lifecycle.dao.omr.ExportMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.lifecycle.spi.ExportResult;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportTypeSubpackage;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BaseOMRExportDAO
extends AbstractOMRPromotionDAO
implements ExportDAO {
    private static final long EXPORT_VERSION = 1L;
    private static final String EXPORT_VERSION_KEY = "exportversion";

    public BaseOMRExportDAO(String objectTypeName) {
        super(objectTypeName);
    }

    public void validateContents(List<ExportNode> nodes, ExportOperation operation) throws ContentException {
    }

    public final ExportResult exportObjects(List<ExportNode> exportNodes, ExportOperation operation) throws ContentException {
        ExportResult result = new ExportResult();
        if (this.objectTypeName != null) {
            this.runExportProcess(this.objectTypeName, exportNodes, operation, result);
        } else {
            Map nodesByType = this.splitNodesByType(exportNodes);
            for (String typeName : nodesByType.keySet()) {
                List nodes = (List)nodesByType.get(typeName);
                this.runExportProcess(typeName, nodes, operation, result);
            }
        }
        return result;
    }

    private ExportResult runExportProcess(String typeName, List<ExportNode> exportNodes, ExportOperation operation, ExportResult result) throws ContentException {
        String displayType = this.getDisplayType(typeName, operation.getLocale());
        this.logExportNodes(typeName, displayType, exportNodes, operation);
        String packageid = operation.getPackageId();
        ExportPackage exportPackage = this.exportPackageService.getPackageById(new ObjectIdentity(159L, packageid));
        ExportTypeSubpackage typeSubpackage = new ExportTypeSubpackage();
        typeSubpackage.setTypeName(typeName);
        this.addSubpackage(exportPackage, typeSubpackage);
        try {
            exportPackage = this.exportPackageService.update(exportPackage);
            this.preExportProcess(exportNodes, operation);
            this.exportMetadata(typeName, exportNodes, operation);
            for (ExportNode exportedNode : exportNodes) {
                result.addExportNode(exportedNode);
            }
            this.exportContent(exportNodes, operation);
            this.postExportProcess(exportNodes, operation);
            this.logMessage(operation, 400, RB.getStringResource("BaseOMRExportDAO.exportcomplete.txt", operation.getLocale()), typeName);
            return result;
        }
        catch (Exception e) {
            this.logMessage((TransportOperation<?>)operation, 100, e.getLocalizedMessage());
            this.logMessage((TransportOperation<?>)operation, 500, "Cause", e);
            return result;
        }
    }

    private void logExportNodes(String typeName, String displayType, List<ExportNode> exportNodes, ExportOperation operation) {
        String format = RB.getStringResource("BaseOMRExportDAO.exportCount.fmt.txt", operation.getLocale());
        this.logMessage(operation, 400, Message.format((String)format, (Object)new Integer(exportNodes.size()), (Object)displayType), typeName);
        try {
            Thread.sleep(10L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList<String> messages = new ArrayList<String>(exportNodes.size());
        for (ExportNode nextNode : exportNodes) {
            String msg = Message.format((String)RB.getStringResource("BaseOMRExportDAO.ExportingItem.fmt.txt", operation.getLocale()), (Object)nextNode.toString());
            messages.add(msg);
        }
        this.logEnumerationMessages((TransportOperation)operation, 400, messages, displayType);
    }

    protected void preExportProcess(List<ExportNode> nodes, ExportOperation operation) throws ContentException {
    }

    protected void postExportProcess(List<ExportNode> nodes, ExportOperation operation) throws ContentException {
    }

    protected List<ContentItem> exportContent(List<ExportNode> exportNodes, ExportOperation operation) throws ContentException {
        return null;
    }

    private void exportMetadata(String typeName, List<ExportNode> exportNodes, ExportOperation operation) throws ContentException {
        String packageId = operation.getPackageId();
        ExportPackage exportPackage = this.exportPackageService.getPackageById(new ObjectIdentity(159L, packageId));
        ExportTypeSubpackage typePackage = this.getSubpackage(exportPackage, typeName);
        ContentItem transportContent = this.createContentItem("TransportMetadata", "TransportMetadata.xml", typePackage);
        ContentItem deployMapContent = this.createContentItem("DeployMap", "DeployMap.xml", typePackage);
        try {
            ExportMetadataUtil metadataUtil = new ExportMetadataUtil();
            metadataUtil.setMetadataTemplate(this.metadataTemplate);
            metadataUtil.setObjectTypeService(this.objectTypeService);
            metadataUtil.exportMetadata(transportContent, deployMapContent, exportNodes);
            this.logMessage(operation, 400, RB.getStringResource("BaseOMRExportDAO.MetadataComplete.txt", operation.getLocale()), typeName);
            this.exportPackageService.update(exportPackage);
        }
        catch (Exception e) {
            String msg = Message.format((String)RB.getStringResource("BaseOMRExportDAO.MetadataError.fmt.txt", operation.getLocale()), (Object)e.getLocalizedMessage());
            throw new ContentException(msg, (Throwable)e);
        }
        finally {
            transportContent.setContent(null);
            deployMapContent.setContent(null);
        }
    }

    protected final ContentItem createContentItem(Identifiable obj, String fileName, ExportTypeSubpackage typeSubpackage) {
        OMRRepositoryKey key = new OMRRepositoryKey(obj.getId());
        return this.createContentItem(key.getId(), fileName, typeSubpackage);
    }

    protected final ContentItem createContentItem(MetadataInterface mi, String fileName, ExportTypeSubpackage typeSubpackage) throws ServiceException, RemoteException {
        return this.createContentItem(mi.getIdentifier(), fileName, typeSubpackage);
    }

    protected final ContentItem createContentItem(String itemName, String fileName, ExportTypeSubpackage typeSubpackage) {
        ContentItem content = new ContentItem();
        content.setObjectType(160L);
        content.setName(itemName);
        content.setContentName(fileName);
        typeSubpackage.addContentItem(content);
        return content;
    }

    protected long getExportVersion() {
        return 1L;
    }

    private void logMessage(ExportOperation operation, int priority, String text, String typeName) {
        this.logMessage((TransportOperation)operation, text, priority, null, typeName);
    }

    private void logMessage(ExportOperation operation, int priority, String text, Throwable t, String typeName) {
        this.logMessage((TransportOperation)operation, text, priority, t, typeName);
    }
}

