/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.framework.client.FatalContentException;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.CopyNode;
import com.sas.svcs.content.lifecycle.client.CopyOperation;
import com.sas.svcs.content.lifecycle.client.NodeProcessingState;
import com.sas.svcs.content.lifecycle.dao.AbstractOperationDAO;
import com.sas.svcs.content.lifecycle.dao.CopyDAO;
import com.sas.svcs.content.lifecycle.dao.NameValidator;
import com.sas.svcs.content.lifecycle.dao.TransportNodeRenameUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractExportMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractTypeTransportManager;
import com.sas.svcs.content.lifecycle.dao.omr.CopyMetadataUtil;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.lifecycle.spi.CopyResult;
import com.sas.svcs.content.logging.client.LogItem;
import com.sas.text.Message;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BaseOMRCopyDAO
extends AbstractOperationDAO
implements CopyDAO {
    protected TransportNodeRenameUtil nodeRenameUtil;
    protected MetadataTemplate metadataTemplate;

    @Autowired
    public void setTransportNodeRenameUtil(TransportNodeRenameUtil nodeRenameUtil) {
        this.nodeRenameUtil = nodeRenameUtil;
    }

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    protected final MetadataTemplate getMetadataTemplate() {
        return this.metadataTemplate;
    }

    public boolean isCopyAllowed(CopyNode node, CopyOperation operation) throws ContentException {
        return true;
    }

    public CopyResult copyObject(CopyNode node, CopyOperation operation) throws ContentException {
        CopyResult result = new CopyResult();
        result.setCopyNode(node);
        this.executeCopy(node, operation, result);
        return result;
    }

    private void executeCopy(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
        try {
            this.preCopyProcess(node, operation, result);
            this.copyMetadata(node, operation, result);
            if (node.getProcessingState() == NodeProcessingState.DEFERRED) {
                return;
            }
            this.postCopyProcess(node, operation, result);
            this.copyContent(node, operation, result);
            node.setProcessingState(NodeProcessingState.SUCCESS);
        }
        catch (FatalContentException e) {
            node.setProcessingState(NodeProcessingState.FAILED);
            throw e;
        }
        catch (Exception e) {
            node.setProcessingState(NodeProcessingState.FAILED);
            if (this.abortOnFailure()) {
                throw new ContentException(e.getLocalizedMessage(), (Throwable)e);
            }
            String objectType = this.getObjectTypeName(node.getObjectType());
            String displayTypeName = this.getDisplayType(objectType, operation.getLocale());
            String msg = Message.format((String)RB.getStringResource("BaseOMRCopyDAO.CopyError.fmt.txt", operation.getLocale()), (Object)displayTypeName, (Object)node.toString(), (Object)e.getLocalizedMessage());
            this.logMessage((ContentOperation<?>)operation, result, 100, msg, this.getObjectTypeName(node.getObjectType()));
        }
    }

    protected void preCopyProcess(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
    }

    protected void postCopyProcess(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
    }

    protected void copyContent(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
    }

    protected boolean mapConnections(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
        return true;
    }

    protected final void copyMetadata(CopyNode node, CopyOperation operation, CopyResult result) throws ContentException {
        CopyMetadataUtil metadataUtil = new CopyMetadataUtil();
        metadataUtil.setMetadataTemplate(this.metadataTemplate);
        metadataUtil.setObjectTypeService(this.objectTypeService);
        metadataUtil.setTransportNodeRenameUtil(this.nodeRenameUtil);
        metadataUtil.setNameValidator(this.getNameValidator());
        AbstractExportMetadataUtil.RequestData data = metadataUtil.copyMetadata(node, operation, result);
        boolean mapped = this.mapConnections(node, operation, result);
        if (!mapped) {
            this.deferNode(node);
            return;
        }
        metadataUtil.pasteMetadata(node, operation, result, data);
        try {
            metadataUtil.setCreatedModifiedBy(node);
        }
        catch (ContentException e) {
            String objectType = this.getObjectTypeName(node.getObjectType());
            String displayTypeName = this.getDisplayType(objectType, operation.getLocale());
            String msg = Message.format((String)RB.getStringResource("BaseOMRCopyDAO.CreatedModifiedByError.fmt.txt", operation.getLocale()), (Object)displayTypeName, (Object)node.toString());
            this.logMessage((ContentOperation<?>)operation, result, 200, msg, this.getObjectTypeName(node.getObjectType()));
        }
    }

    protected final void logMessage(ContentOperation<?> operation, CopyResult result, int priority, String text, String objectTypeName) {
        String displayType = this.getDisplayType(objectTypeName, operation.getLocale());
        LogItem logItem = this.createLogItem(priority, text, displayType);
        result.addLogItem(logItem);
    }

    protected final void logMessages(ContentOperation<?> operation, CopyResult result, AbstractTypeTransportManager transportManager) {
        String displayType = this.getDisplayType(transportManager.getObjectTypeName(), operation.getLocale());
        List<AbstractTypeTransportManager.LogMessage> messages = transportManager.getLogMessages();
        if (messages != null) {
            for (AbstractTypeTransportManager.LogMessage msg : messages) {
                LogItem logItem = msg instanceof AbstractTypeTransportManager.EnumerationLogMessage ? this.createEnumerationLogItem(msg.getPriority(), msg.getMessage(), displayType) : this.createLogItem(msg.getPriority(), msg.getMessage(), displayType);
                result.addLogItem(logItem);
            }
        }
    }

    private LogItem createLogItem(int priority, String msg, String displayType) {
        LogItem logItem = new LogItem(null);
        logItem.setDate(new Date());
        logItem.setClassifier(displayType);
        logItem.setPriority(priority);
        logItem.setText(msg);
        return logItem;
    }

    private LogItem createEnumerationLogItem(int priority, String msg, String displayType) {
        LogItem logItem = this.createLogItem(priority, msg, displayType);
        HashMap<String, String> propMap = new HashMap<String, String>(1);
        propMap.put("mode", "enumeration");
        logItem.setProperties(propMap);
        return logItem;
    }

    private void deferNode(CopyNode node) {
        node.setProcessingState(NodeProcessingState.DEFERRED);
    }

    protected boolean abortOnFailure() {
        return false;
    }

    protected NameValidator getNameValidator() {
        return null;
    }
}

