/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.lifecycle.client.ConnectionNotMappedException;
import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.ValidationResponse;
import com.sas.svcs.content.lifecycle.client.ValidationState;
import com.sas.svcs.content.lifecycle.dao.mapping.MappingValueProvider;
import com.sas.svcs.content.lifecycle.dao.mapping.PromptedConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRConnectionMapping;
import com.sas.svcs.content.lifecycle.dao.omr.RB;
import com.sas.svcs.content.transport.client.mapping.PromptProperties;
import com.sas.svcs.content.transport.client.mapping.TransportPrompt;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractOMRPromptedConnectionMapping
extends AbstractOMRConnectionMapping
implements PromptedConnectionMapping {
    public <T extends TransportNode> TransportPrompt initializePrompt(TransportPrompt prompt, ConnectionPoint cp, ContentOperation<T> operation) throws ContentException {
        List<PromptProperties> properties = prompt.getProperties();
        if (properties == null) {
            properties = this.getConnectionProperties(cp, operation.getLocale());
            prompt.setProperties(properties);
        }
        return prompt;
    }

    public List<PromptProperties> getConnectionProperties(ConnectionPoint cp, Locale locale) throws ContentException {
        ArrayList<PromptProperties> props = new ArrayList<PromptProperties>(5);
        PromptProperties nameProp = new PromptProperties();
        nameProp.setLabel("Name");
        nameProp.setSourceValue(cp.getName());
        props.add(nameProp);
        PromptProperties descProp = new PromptProperties();
        descProp.setLabel("Description");
        descProp.setSourceValue(cp.getDescription());
        props.add(descProp);
        PromptProperties pathProp = null;
        if (cp instanceof ContentConnectionPoint) {
            pathProp = new PromptProperties();
            pathProp.setLabel("Path");
            pathProp.setSourceValue(((ContentConnectionPoint)cp).getSourcePath());
            props.add(pathProp);
        }
        if (cp.getTargetId() != null) {
            try {
                ServerInterface server = this.getMetadataTemplate().getServer();
                Filter filter = new Filter();
                String template = "<Templates><Root Name=\"\" Desc=\"\"/></Templates>";
                filter.setOMRTemplate(template);
                filter.setOMRFlags(16);
                BrowseMetadataInterface browse = server.browseFetch(cp.getTargetId(), (FilterInterface)filter);
                if (browse != null) {
                    nameProp.setTargetValue(browse.getName());
                    descProp.setTargetValue(browse.getDescription());
                    if (pathProp != null && cp instanceof ContentConnectionPoint) {
                        pathProp.setTargetValue(((ContentConnectionPoint)cp).getTargetPath());
                    }
                }
            }
            catch (Exception e) {
                throw new ContentException(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return props;
    }

    protected final ConnectionPoint mapConnection(ConnectionPoint cp, String targetValue, FilterInterface filter, ContentOperation<?> operation) throws ConnectionNotMappedException {
        return this.mapConnection(cp, targetValue, filter, false, operation);
    }

    protected final ConnectionPoint mapConnection(ConnectionPoint cp, String targetValue, FilterInterface filter, boolean required, ContentOperation<?> operation) throws ConnectionNotMappedException {
        String targetId;
        if (required) {
            this.assertTargetMappingRequired(targetValue, cp, operation);
        }
        if ((targetId = this.searchForConnectionPointId(filter)) == null) {
            Locale locale = operation.getLocale();
            String msg = Message.format((String)RB.getStringResource("AbstractOMRPromptedConnectionMapping.MappingNotFound.fmt.txt", locale), (Object)this.getTypeLabel(locale), (Object)targetValue);
            ValidationResponse validation = new ValidationResponse();
            validation.setState(required ? ValidationState.ERROR : ValidationState.WARNING);
            validation.setMessage(msg);
            throw new ConnectionNotMappedException();
        }
        cp.setTargetId(targetId);
        return cp;
    }

    protected final ConnectionPoint mapConnectionById(ConnectionPoint cp, String targetValue, String targetId, boolean required, ContentOperation<?> operation) throws ConnectionNotMappedException {
        if (required) {
            this.assertTargetMappingRequired(targetValue, cp, operation);
        }
        if (targetId == null) {
            Locale locale = operation.getLocale();
            String msg = Message.format((String)RB.getStringResource("AbstractOMRPromptedConnectionMapping.MappingNotFound.fmt.txt", locale), (Object)this.getTypeLabel(locale), (Object)targetValue);
            ValidationResponse validation = new ValidationResponse();
            validation.setState(required ? ValidationState.ERROR : ValidationState.WARNING);
            validation.setMessage(msg);
            throw new ConnectionNotMappedException();
        }
        cp.setTargetId(targetId);
        return cp;
    }

    protected final void assertTargetMappingRequired(String targetValue, ConnectionPoint cp, ContentOperation<?> operation) throws ConnectionNotMappedException {
        if (targetValue == null || targetValue.isEmpty()) {
            String displayName = null;
            if (this instanceof MappingValueProvider) {
                displayName = ((MappingValueProvider)cp).getMappingValue(cp);
            }
            if (displayName == null) {
                displayName = cp.getName();
            }
            Locale locale = operation.getLocale();
            String msg = Message.format((String)RB.getStringResource("AbstractOMRPromptedConnectionMapping.MappingRequired.fmt.txt", locale), (Object)this.getTypeLabel(locale), (Object)displayName);
            ValidationResponse validation = new ValidationResponse();
            validation.setState(ValidationState.ERROR);
            validation.setMessage(msg);
            throw new ConnectionNotMappedException(validation);
        }
    }
}

