/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.content.framework.client.ContentRuntimeException;
import com.sas.svcs.content.lifecycle.client.TransportOperation;
import com.sas.svcs.content.lifecycle.dao.AbstractPromotionDAO;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractTypeTransportManager;
import com.sas.svcs.content.transport.client.ExportPackage;
import com.sas.svcs.content.transport.client.ExportTypeSubpackage;
import java.rmi.RemoteException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractOMRPromotionDAO
extends AbstractPromotionDAO {
    protected static final String TRANSPORT_FILE_NAME = "TransportMetadata.xml";
    protected static final String TRANSPORT_ITEM_NAME = "TransportMetadata";
    protected static final String DEPLOY_MAP_FILE_NAME = "DeployMap.xml";
    protected static final String DEPLOY_MAP_ITEM_NAME = "DeployMap";
    protected String objectTypeName;
    protected MetadataTemplate metadataTemplate;

    public AbstractOMRPromotionDAO(String objectTypeName) {
        this.objectTypeName = objectTypeName;
    }

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    protected final MetadataTemplate getMetadataTemplate() {
        return this.metadataTemplate;
    }

    protected final ExportTypeSubpackage getSubpackage(ExportPackage exportPackage) {
        return this.getSubpackage(exportPackage, this.objectTypeName);
    }

    protected final ChildServerInterface createNewTransaction() {
        try {
            ChildServerInterface childServer = this.metadataTemplate.getServer().newChild(true);
            return childServer;
        }
        catch (ServiceException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected final void closeTransaction(ChildServerInterface server) {
        try {
            if (server != null) {
                server.rollback();
            }
        }
        catch (ServiceException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected final void logMessage(TransportOperation<?> operation, int priority, String text) {
        this.logMessage(operation, text, priority, null);
    }

    protected final void logMessage(TransportOperation<?> operation, int priority, String text, Throwable t) {
        this.logMessage(operation, text, priority, t);
    }

    protected final void logMessages(TransportOperation<?> operation, AbstractTypeTransportManager transportManager) {
        String displayType = this.getDisplayType(transportManager.getObjectTypeName(), operation.getLocale());
        List<AbstractTypeTransportManager.LogMessage> messages = transportManager.getLogMessages();
        if (messages != null) {
            for (AbstractTypeTransportManager.LogMessage msg : messages) {
                if (msg instanceof AbstractTypeTransportManager.EnumerationLogMessage) {
                    this.logEnumerationMessages(operation, msg.getPriority(), ((AbstractTypeTransportManager.EnumerationLogMessage)msg).getMessages(), displayType);
                    continue;
                }
                this.logMessage(operation, msg.getPriority(), msg.getMessage());
            }
        }
    }

    private void logMessage(TransportOperation<?> operation, String text, int priority, Throwable t) {
        String displayType = this.getDisplayType(this.objectTypeName, operation.getLocale());
        super.logMessage(operation, text, priority, t, displayType);
    }
}

