/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.lifecycle.dao.omr;

import com.sas.svcs.content.lifecycle.client.ConnectionPoint;
import com.sas.svcs.content.lifecycle.client.ContentOperation;
import com.sas.svcs.content.lifecycle.client.Nested;
import com.sas.svcs.content.lifecycle.client.TargetTransportNode;
import com.sas.svcs.content.lifecycle.client.TransportNode;
import com.sas.svcs.content.lifecycle.client.TransportUtil;
import com.sas.svcs.content.lifecycle.dao.omr.AbstractOMRConnectionMapping;
import java.util.List;

public abstract class AbstractOMRNestedNodeConnectionMapping
extends AbstractOMRConnectionMapping {
    @Override
    public <T extends TransportNode> boolean isConnectionActive(ConnectionPoint cp, ContentOperation<T> operation) {
        if (cp.isActive()) {
            List nodes = operation.getOperationNodes();
            if (nodes != null) {
                String cpId = cp.getSourceId();
                for (TransportNode node : nodes) {
                    if (cpId.equalsIgnoreCase(node.getId())) {
                        return this.isNodeDisabled(node);
                    }
                    TransportNode nestedNode = this.findMatchingNestedNode(node, cpId);
                    if (nestedNode == null) continue;
                    return this.isNodeDisabled(nestedNode);
                }
            }
            return true;
        }
        return false;
    }

    private <T extends TransportNode> TransportNode findMatchingNestedNode(T parentNode, String id) {
        List nestedNodes = parentNode.getNestedNodes();
        if (nestedNodes != null) {
            for (Nested nestedNode : nestedNodes) {
                if (!(nestedNode instanceof TransportNode)) continue;
                if (id.equalsIgnoreCase(nestedNode.getId())) {
                    return (TransportNode)nestedNode;
                }
                TransportNode childNode = this.findMatchingNestedNode((TransportNode)nestedNode, id);
                if (childNode == null) continue;
                return childNode;
            }
        }
        return null;
    }

    private <T extends TransportNode> boolean isNodeDisabled(T node) {
        if (node instanceof TargetTransportNode) {
            return TransportUtil.isDisabled((TargetTransportNode)((TargetTransportNode)node));
        }
        return false;
    }
}

