/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.util;

import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Timestamp
extends com.sas.commons.expr.util.Timestamp {
    private static final String HTTP_TIMESTAMP_PARSER_PATTERN = "EEE, dd MMM yyyy HH:mm:ss ZZZ";
    private static final String HTTP_TIMESTAMP_FORMATTER_PATTERN = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final DateTimeFormatter HTTP_TIMESTAMP_PARSER = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss ZZZ").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter HTTP_TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(DateTimeZone.UTC);

    public static Date parseHeaderAsDate(String timestamp) throws IllegalArgumentException {
        DateTime dateTime = HTTP_TIMESTAMP_PARSER.parseDateTime(timestamp);
        return dateTime.toDate();
    }

    public static DateTime parseHeaderAsDateTime(String timestamp) throws IllegalArgumentException {
        DateTime dateTime = HTTP_TIMESTAMP_PARSER.parseDateTime(timestamp);
        return dateTime;
    }

    public static String headerTimestamp(DateTime timestamp) {
        return timestamp.toString(HTTP_TIMESTAMP_FORMATTER);
    }

    public static String headerTimestamp(Date timestamp) {
        return Timestamp.headerTimestamp(timestamp.getTime());
    }

    public static String headerTimestamp(long millisSinceJavaEpoch) {
        DateTime timestamp = new DateTime(millisSinceJavaEpoch);
        return Timestamp.headerTimestamp(timestamp);
    }
}

