/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.spring;

import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.Error;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.NotThreadSafe;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

@NotThreadSafe
public class ErrorResponseFactory {
    private ErrorResponseFactory() {
    }

    @NonNull
    public static ResponseEntity<Error> newResponseEntity(@NonNull HttpStatus httpStatus, @NonNull String message, String remediation) {
        return ErrorResponseFactory.newResponseEntity(httpStatus, 0, message, null, remediation, null, null);
    }

    @NonNull
    public static ResponseEntity<Error> newResponseEntity(@NonNull HttpStatus httpStatus, @NonNull String message, String remediation, HttpServletRequest request) {
        return ErrorResponseFactory.newResponseEntity(httpStatus, 0, message, null, remediation, null, null, request);
    }

    @NonNull
    public static ResponseEntity<Error> newResponseEntity(@NonNull HttpStatus httpStatus, int errorCode, @NonNull String message) {
        return ErrorResponseFactory.newResponseEntity(httpStatus, errorCode, message, null, null, null, null);
    }

    @NonNull
    public static ResponseEntity<Error> newResponseEntity(@NonNull HttpStatus httpStatus, int errorCode, @NonNull String message, HttpServletRequest request) {
        return ErrorResponseFactory.newResponseEntity(httpStatus, errorCode, message, null, null, null, null, request);
    }

    @NonNull
    public static ResponseEntity<Error> newResponseEntity(@NonNull HttpStatus httpStatus, int errorCode, @NonNull String message, @Nullable List<String> details, @Nullable String remediation, @Nullable Links links, @Nullable MultiValueMap<String, String> headers) {
        return ErrorResponseFactory.newResponseEntity(httpStatus, errorCode, message, details, remediation, links, headers, null);
    }

    @NonNull
    public static ResponseEntity<Error> newResponseEntity(@NonNull HttpStatus httpStatus, int errorCode, @NonNull String message, List<String> details, @Nullable String remediation, @Nullable Links links, @Nullable MultiValueMap<String, String> headers, @Nullable HttpServletRequest request) {
        headers = ErrorResponseFactory.errorContentTypeHeader(request, headers);
        Error err = new Error(httpStatus.value(), errorCode, message, details, remediation, links);
        return new ResponseEntity((Object)err, headers, httpStatus);
    }

    @NonNull
    public static MultiValueMap<String, String> errorContentTypeHeader(@Nullable HttpServletRequest request, @Nullable MultiValueMap<String, String> headers) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        String accept = request == null ? null : request.getHeader("Accept");
        boolean isXml = false;
        if (accept != null) {
            try {
                MediaType m = MediaType.parseMediaType((String)accept);
                String sub = m.getSubtype();
                if (sub != null && sub.endsWith("xml")) {
                    isXml = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        headers.set((Object)"Content-Type", (Object)(isXml ? "application/vnd.sas.error+xml" : "application/vnd.sas.error+json"));
        return headers;
    }
}

