/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.representations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sas.commons.rest.links.Link;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="selection")
public class ResourceSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int RESOURCESELECTION_VERSION = 1;
    private static final int RESOURCESELECTION_VERSION_1 = 1;
    public static final String MEDIA_TYPE_BASE_VALUE = "application/vnd.sas.selection";
    public static final String MEDIA_TYPE_JSON_VALUE = "application/vnd.sas.selection+json";
    public static final String MEDIA_TYPE_XML_VALUE = "application/vnd.sas.selection+xml";
    public static final String MIXED = "mixed";
    public static final String ID = "id";
    public static final String URI = "uri";
    public static final String RESOURCE_ID_TEMPLATE = "{id}";
    private static final String NO_TEMPLATE = "{{{id}}}";
    public static final String REL_DELETE_RESOURCES = "deleteResources";
    private String id;
    private String type;
    private String template = "{{{id}}}";
    private final List<String> resources = new ArrayList<String>();
    private List<Link> links;
    private int version = 1;

    public ResourceSelection() {
    }

    public ResourceSelection(String type, String template) {
        this.setTemplate(template);
        if (type != null) {
            this.setType(type);
        }
    }

    @XmlAttribute
    @JsonProperty
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type == null || type.length() == 0) {
            throw new IllegalArgumentException("type must be id, mixed, or uri");
        }
        if (MIXED.equals(type)) {
            type = MIXED;
        } else if (ID.equals(type)) {
            type = ID;
        } else if (URI.equals(type)) {
            type = URI;
        }
        this.validateTemplate(this.template, type);
        this.validateResources(type);
        this.type = type;
    }

    private void validateTemplate(String template, String type) {
        if (!(ID.equals(this.effectiveType(type)) || template != null && template.length() != 0)) {
            throw new IllegalArgumentException("template may not be null if type is not 'id'");
        }
        if (template != null && template.indexOf(RESOURCE_ID_TEMPLATE) < 0) {
            throw new IllegalArgumentException("template must include the substring '{id}'");
        }
    }

    private Object effectiveType(String type) {
        return type == null ? MIXED : type;
    }

    @XmlAttribute
    @JsonProperty
    public String getTemplate() {
        return this.template == NO_TEMPLATE ? null : this.template;
    }

    public void setTemplate(String template) {
        this.validateTemplate(template, this.type);
        this.template = template;
    }

    public List<String> uris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (String resource : this.resources) {
            uris.add(this.toUri(resource));
        }
        return uris;
    }

    private String toUri(String value) {
        if (this.type.equals(ID)) {
            return this.template.replace(RESOURCE_ID_TEMPLATE, value);
        }
        if (this.type.equals(URI)) {
            return value;
        }
        if (this.type.equals(MIXED)) {
            if (value == null || value.indexOf(47) >= 0) {
                return value;
            }
            return this.template.replace(RESOURCE_ID_TEMPLATE, value);
        }
        if (this.version == 1) {
            this.throwTypeStateException();
        }
        if (value == null || value.indexOf(47) >= 0) {
            return value;
        }
        return this.template.replace(RESOURCE_ID_TEMPLATE, value);
    }

    @XmlElementWrapper(name="resources")
    @XmlElement(name="id")
    @JsonProperty
    public List<String> getResources() {
        return this.resources;
    }

    public ResourceSelection addResources(String ... resources) {
        for (String res : resources) {
            this.validateResource(res, this.type);
        }
        for (String res : resources) {
            this.resources.add(res);
        }
        return this;
    }

    public void clear() {
        this.resources.clear();
    }

    public int size() {
        return this.resources.size();
    }

    private void validateResources(String forType) {
        for (String resource : this.resources) {
            this.validateResource(resource, forType);
        }
    }

    private void validateResource(String resource, String forType) {
        if (resource == null || resource.length() == 0) {
            throw new IllegalArgumentException("resource may not be null or empty");
        }
        if (URI.equals(this.effectiveType(forType)) && resource.indexOf(47) < 0) {
            throw new IllegalArgumentException("resource must contain '/' when type is uri.");
        }
        if (ID.equals(this.effectiveType(forType)) && resource.indexOf(47) >= 0) {
            throw new IllegalArgumentException("resource may not contain '/' when type is id.");
        }
    }

    public void setResources(List<String> resources) {
        this.resources.clear();
        if (resources != null) {
            this.resources.addAll(resources);
        }
    }

    @XmlAttribute
    @JsonProperty
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    @XmlAttribute
    @JsonProperty
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (version <= 0) {
            throw new IllegalArgumentException("version must be > 0");
        }
        this.version = version;
        if (this.type != null) {
            if (this.type.equals(MIXED) || this.type.equals(ID) || this.type.equals(URI)) {
                return;
            }
            if (version == 1) {
                this.throwTypeStateException();
            }
        }
    }

    private void throwTypeStateException() {
        throw new IllegalStateException("type value '" + this.type + "' is not one of 'mixed', 'uri', or 'id'");
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    @JsonProperty
    public List<Link> getLinks() {
        return this.links;
    }

    public void addLink(Link link) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(link);
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public int hashCode() {
        int prime = 73;
        int result = 5;
        result = 73 * result + ResourceSelection.hashCode(this.id);
        result = 73 * result + ResourceSelection.hashCode(this.type);
        result = 73 * result + ResourceSelection.hashCode(this.template);
        result = 73 * result + ResourceSelection.hashCode(this.resources);
        result = 73 * result + ResourceSelection.hashCode(this.links);
        result = 73 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceSelection rhs = (ResourceSelection)obj;
        return ResourceSelection.equals(this.id, rhs.id) && ResourceSelection.equals(this.type, rhs.type) && ResourceSelection.equals(this.template, rhs.template) && ResourceSelection.equals(this.resources, rhs.resources) && ResourceSelection.equals(this.links, rhs.links) && this.version == rhs.version;
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private static int hashCode(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public String toString() {
        return "ResourceSelection(V" + this.version + "): " + this.id + " type:" + this.effectiveType(this.type) + " template: " + this.template + " resources: " + this.resources + " links: " + this.links;
    }
}

