/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.links;

import com.sas.commons.rest.links.Link;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement(name="resources")
public class Links {
    private static final Links EMPTY = new Links(Collections.unmodifiableList(new ArrayList()));
    private static final int SCHEMA_VERSION = 1;
    private int version = 1;
    @NonNull
    private List<Link> links;

    public Links() {
        this(new ArrayList<Link>(4));
    }

    public Links(@NonNull List<Link> links) {
        this.setLinks(links);
    }

    public Links(@NonNull Link[] links) {
        this.setLinks(Arrays.asList(links));
    }

    @XmlAttribute
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        if (version != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " version != " + 1);
        }
        this.version = version;
    }

    @XmlElementWrapper(name="links")
    @XmlElement(name="link")
    @NonNull
    public List<Link> getLinks() {
        return this.links;
    }

    public Links add(@NonNull Link link) {
        this.links.add(link);
        return this;
    }

    public void clear() {
        this.links.clear();
    }

    public int size() {
        return this.links.size();
    }

    public Link get(int i) {
        return this.links.get(i);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != Links.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Links rhs = (Links)obj;
        return new EqualsBuilder().append(this.links, rhs.links).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("elements", this.links).toString();
    }

    public int hashCode() {
        return this.links.hashCode();
    }

    public void setLinks(List<Link> links) {
        this.links = links == null ? new ArrayList<Link>(4) : links;
    }

    @NonNull
    public static Links emptyList() {
        return EMPTY;
    }
}

