/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.links;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.MalformedURLException;
import java.net.URL;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ApplicationBaseUrl {
    private static final String UNCONFIGURED_MSG = "Application has not configured the base URL.";
    static ThreadLocal<String> tl = new ThreadLocal();

    private ApplicationBaseUrl() {
    }

    public static void setUrl(@NonNull String url) throws MalformedURLException {
        assert (url != null) : "Application has not configured the base URL.";
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        new URL(url);
        tl.set(url);
    }

    public static String getUrl() {
        String url = tl.get();
        return url;
    }

    public static void clear() {
        tl.remove();
    }
}

