/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.jaxb;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class PrefixMapper
extends NamespacePrefixMapper {
    private final Map<String, String> uriToPrefixMapping = new HashMap<String, String>();

    public void setMappings(String[] mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException("mappings may not be null");
        }
        for (String mapping : mappings) {
            String[] parts = mapping.split("\\|");
            if (parts.length != 2) {
                throw new IllegalArgumentException(String.format("mapping %s is not in 'prefix|URI' format", mapping));
            }
            String prefix = parts[0];
            String uri = parts[1];
            this.uriToPrefixMapping.put(uri, prefix);
        }
    }

    public String[] getPreDeclaredNamespaceUris() {
        String[] supers = super.getPreDeclaredNamespaceUris();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(supers));
        result.addAll(this.uriToPrefixMapping.keySet());
        return result.toArray(new String[result.size()]);
    }

    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        String prefix = this.uriToPrefixMapping.get(namespaceUri);
        if (prefix != null) {
            return prefix;
        }
        return "";
    }
}

