/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.expr;

import com.sas.commons.antlr.ErrorHandler;
import com.sas.commons.antlr.ParseError;
import com.sas.commons.antlr.ParseException;
import com.sas.commons.expr.SortKey;
import com.sas.commons.expr.parser.ExprParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SortBy {
    public static List<SortKey> parseSortKeys(@NonNull HttpServletRequest request, @Nullable String parameterName) throws IllegalArgumentException {
        if (parameterName == null) {
            parameterName = "sortBy";
        }
        String sortBy = request.getParameter(parameterName);
        return SortBy.parseSortKeys(sortBy);
    }

    public static List<SortKey> parseSortKeys(String sortBy) throws IllegalArgumentException {
        if (sortBy == null || sortBy.trim().length() == 0) {
            return Collections.emptyList();
        }
        try {
            ExprParser parser = ExprParser.from((String)sortBy);
            ErrorHandler errorHandler = parser.getErrorHandler();
            List sortKeys = parser.parseSortKeys();
            if (errorHandler.hasErrors()) {
                StringBuilder msg = new StringBuilder();
                String delim = "";
                for (ParseError e : errorHandler.errors()) {
                    msg.append(delim).append(e.toString());
                    delim = "\n";
                }
                throw new IllegalArgumentException(msg.toString());
            }
            return sortKeys;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

