/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.rest.cas;

import com.sas.commons.rest.cas.CasServiceTicketProvider;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityContextHolderCasTicketProvider
implements CasServiceTicketProvider {
    @Override
    @Nullable
    public String getServiceTicketFor(@NonNull String restServiceURI) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        CasAuthenticationToken casAuth = null;
        try {
            casAuth = (CasAuthenticationToken)auth;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ERROR: Authentication token is of wrong type: " + auth.getClass());
        }
        Assertion assertion = casAuth.getAssertion();
        if (null == assertion) {
            return null;
        }
        AttributePrincipal principal = assertion.getPrincipal();
        if (null == principal) {
            return null;
        }
        return principal.getProxyTicketFor(restServiceURI);
    }
}

