/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Primitive;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.TransInfo;

class Transformation
extends Primitive {
    double[] darray;
    int id;
    static final int LoadIdentity = 1;
    static final int Scale = 2;
    static final int Rotate = 3;
    static final int CenterRotate = 4;
    static final int Translate = 5;
    static final int PushMatrix = 6;
    static final int PopMatrix = 7;
    static final int LoadMatrix = 8;

    Transformation(int id, double[] darr) {
        this.id = id;
        this.darray = darr;
    }

    @Override
    public void computeScreen(Channel ch) {
        TransInfo tr = ch.trans;
        State state = ch.getState();
        int render_mode = state.render_mode;
        switch (this.id) {
            case 1: {
                tr.LoadIdentity(render_mode, ch.state);
                break;
            }
            case 2: {
                tr.Scale(this.darray[0], this.darray[1], this.darray[2], render_mode, ch.state);
                break;
            }
            case 3: {
                tr.Rotate(this.darray[0], this.darray[1], this.darray[2], this.darray[3], ch.state);
                break;
            }
            case 4: {
                tr.Rotate(this.darray[0], this.darray[1], this.darray[2], this.darray[3], this.darray[4], this.darray[5], this.darray[6], ch.state);
                break;
            }
            case 5: {
                tr.Translate(this.darray[0], this.darray[1], this.darray[2], ch.state);
                break;
            }
            case 6: {
                tr.PushMatrix(render_mode, ch.state);
                break;
            }
            case 7: {
                tr.PopMatrix(render_mode, ch.state);
                break;
            }
            case 8: {
                tr.LoadMatrix(this.darray, render_mode, ch.state);
                break;
            }
            default: {
                Debug.println((String)"Error: Unknown transformation found on displaylist");
            }
        }
    }
}

