/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import java.awt.BasicStroke;
import java.util.LinkedList;
import java.util.List;

class StrokeCache {
    private List strokeCache = new LinkedList();
    private int maxStrokeCacheSize = 5;

    StrokeCache() {
    }

    public BasicStroke getStroke(float lineWidth, int capStyle, int joinStyle, int[] stipplePattern) {
        BasicStroke result = this.findStroke(lineWidth, capStyle, joinStyle, stipplePattern);
        if (result == null) {
            result = this.addStroke(lineWidth, capStyle, joinStyle, stipplePattern);
        }
        return result;
    }

    private BasicStroke addStroke(float lineWidth, int capStyle, int joinStyle, int[] stipplePattern) {
        StrokeCacheEntry sce = new StrokeCacheEntry(lineWidth, capStyle, joinStyle, stipplePattern);
        this.strokeCache.add(0, sce);
        if (this.strokeCache.size() > this.maxStrokeCacheSize) {
            this.strokeCache.remove(this.strokeCache.size() - 1);
        }
        return sce.getBasicStroke();
    }

    private BasicStroke findStroke(float lineWidth, int capStyle, int joinStyle, int[] stipplePattern) {
        BasicStroke result = null;
        int n = this.strokeCache.size();
        for (int i = 0; i < n; ++i) {
            StrokeCacheEntry sce = (StrokeCacheEntry)this.strokeCache.get(i);
            if (!sce.equals(lineWidth, capStyle, joinStyle, stipplePattern)) continue;
            result = sce.getBasicStroke();
            break;
        }
        return result;
    }

    private class StrokeCacheEntry {
        private final float lineWidth;
        private final int capStyle;
        private final int joinStyle;
        private final int[] stipplePattern;
        private final BasicStroke bs;

        public StrokeCacheEntry(float lineWidth, int capStyle, int joinStyle, int[] stipplePattern) {
            this.lineWidth = lineWidth;
            this.capStyle = capStyle;
            this.joinStyle = joinStyle;
            if (stipplePattern == null) {
                this.stipplePattern = null;
            } else {
                this.stipplePattern = new int[stipplePattern.length];
                System.arraycopy(stipplePattern, 0, this.stipplePattern, 0, stipplePattern.length);
            }
            this.bs = this.computeStroke();
        }

        private boolean isPatterned() {
            return this.stipplePattern != null && this.stipplePattern.length >= 1;
        }

        private BasicStroke computeStroke() {
            BasicStroke result;
            if (this.isPatterned()) {
                float dashPhase = 0.0f;
                float lw = this.lineWidth;
                int stippleIndex = 0;
                if (this.lineWidth < 1.0f) {
                    lw = 0.5f;
                }
                if (this.stipplePattern.length == 1) {
                    result = this.stipplePattern[0] < 0 ? null : new BasicStroke(lw, this.gl2bsEndCap(this.capStyle), this.gl2bsJoin(this.joinStyle));
                } else {
                    float[] dashArray;
                    int[] workingPattern = new int[this.stipplePattern.length];
                    System.arraycopy(this.stipplePattern, 0, workingPattern, 0, this.stipplePattern.length);
                    if (workingPattern[0] < 0 && workingPattern[workingPattern.length - 1] > 0) {
                        ++stippleIndex;
                        dashPhase = workingPattern[1];
                        dashArray = new float[workingPattern.length];
                        dashArray[workingPattern.length - 1] = Math.abs(workingPattern[0]);
                    } else if (workingPattern[0] < 0 && workingPattern[workingPattern.length - 1] < 0) {
                        int n = workingPattern.length - 1;
                        workingPattern[n] = workingPattern[n] + workingPattern[0];
                        int[] newStipplePattern = new int[workingPattern.length - 1];
                        System.arraycopy(workingPattern, 1, newStipplePattern, 0, workingPattern.length - 1);
                        workingPattern = newStipplePattern;
                        dashArray = new float[workingPattern.length];
                    } else {
                        dashArray = new float[workingPattern.length];
                    }
                    int dashIndex = 0;
                    while (stippleIndex < workingPattern.length) {
                        dashArray[dashIndex] = Math.abs(workingPattern[stippleIndex]);
                        ++stippleIndex;
                        ++dashIndex;
                    }
                    result = new BasicStroke(lw, this.gl2bsEndCap(this.capStyle), this.gl2bsJoin(this.joinStyle), Math.max(this.lineWidth, 1.0f), dashArray, dashPhase);
                }
            } else {
                result = new BasicStroke(this.lineWidth, this.gl2bsEndCap(this.capStyle), this.gl2bsJoin(this.joinStyle));
            }
            return result;
        }

        public BasicStroke getBasicStroke() {
            return this.bs;
        }

        public boolean equals(float lw, int cs, int js, int[] sp) {
            boolean result = false;
            if (this.lineWidth == lw && this.capStyle == cs && this.joinStyle == js) {
                if (sp == null && this.stipplePattern == null) {
                    result = true;
                } else if (this.stipplePattern != null && sp != null && this.stipplePattern.length == sp.length) {
                    result = true;
                    for (int i = 0; i < sp.length; ++i) {
                        if (sp[i] == this.stipplePattern[i]) continue;
                        result = false;
                        break;
                    }
                }
            }
            return result;
        }

        private int gl2bsEndCap(int glCapStyle) {
            switch (glCapStyle) {
                default: {
                    return 0;
                }
                case 1: 
            }
            return 1;
        }

        private int gl2bsJoin(int glJoin) {
            switch (glJoin) {
                default: {
                    return 2;
                }
                case 1: {
                    return 0;
                }
                case 2: 
            }
            return 1;
        }
    }
}

