/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.BlendFilter;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.J3Polygon;
import com.sas.graphics.util.gl.NameTree;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Primitive;
import com.sas.graphics.util.gl.Ray;
import com.sas.graphics.util.gl.Solid;
import com.sas.graphics.util.gl.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Stack;

abstract class Shape
extends Primitive
implements Cloneable {
    public static final int SORT_FRONT = 0;
    public static final int SORT_BEHIND = 1;
    public static final int SORT_DONT_CARE = 2;
    protected static final double FZERO = 1.0E-10;
    protected Object[] nameStack;
    protected NameTree name;
    protected Color color;
    protected float alpha;
    protected boolean clip;
    protected Rectangle clipRect = null;
    protected double zmin;
    protected double zmax;
    protected Point4[] dscr;
    protected Rectangle bbox = new Rectangle();
    protected Point4 normal;
    protected boolean shadowEnabled;
    protected int shadowOffsetX;
    protected int shadowOffsetY;
    protected float shadowTransparency;
    protected float shadowSoftness;
    protected Color shadowColor;

    Shape() {
    }

    public double getZmin() {
        return this.zmin;
    }

    public double getZmax() {
        return this.zmax;
    }

    @Override
    public boolean isClipped() {
        return this.clip;
    }

    public List getPolygonList() {
        return null;
    }

    @Override
    public void insertToSortlist(State state) {
        if (!this.clip) {
            state.sortList.addElement(this);
        }
    }

    void copyInit(Shape s) {
        s.bbox = new Rectangle(this.bbox);
    }

    Shape copy() {
        Shape p = null;
        try {
            p = (Shape)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.copyInit(p);
        return p;
    }

    void copyInNameStack(State state) {
        int size = state.getNameStackTop();
        this.nameStack = new Object[size];
        System.arraycopy(state.getNameStack(), 1, this.nameStack, 0, size);
    }

    public abstract int getVertexCount(State var1);

    public Point4 getScreenCenter() {
        return null;
    }

    @Override
    public abstract void render(State var1, Graphics var2);

    public boolean doPick(State state, Graphics bgc) {
        if (state.render_mode != 1) {
            return false;
        }
        Rectangle a = this.intersectPickAperture(state.aperture, state);
        if (a != null && this.pick(state, bgc, a)) {
            state.selectPrimitive(this);
        }
        return true;
    }

    public boolean doFeedback(State state, Graphics bgc) {
        if (state.render_mode == 3) {
            if (state.SVGSelectionText != null) {
                this.addSVGSelectionText(state, bgc);
                this.addSVGSelectionShape(state, bgc);
                if (state.clearSVGSelectionText) {
                    state.SVGSelectionText = null;
                }
                bgc.drawString("", -2147483647, -2147483647);
            }
            return true;
        }
        if (state.render_mode != 2) {
            return false;
        }
        int feedbackType = state.feedbackType;
        if ((feedbackType & 3) != 0) {
            this.addNamestackToFeedbackBuffer(state);
        }
        if ((feedbackType & 1) != 0) {
            this.addShapeToFeedbackBuffer(state);
        }
        return true;
    }

    protected void addSVGSelectionText(State state, Graphics bgc) {
        if (state.SVGSelectionText == null) {
            return;
        }
        String href = state.SVGSelectionText[0];
        String tooltip = state.SVGSelectionText[1];
        if (href != null || tooltip != null) {
            bgc.drawString(href, -2147483647, 0);
            if (tooltip != null) {
                bgc.drawString(tooltip, 0, -2147483647);
            }
        }
    }

    protected void addSVGSelectionShape(State state, Graphics bgc) {
        Point4[] coords = this.getScreenCoords(state);
        Polygon polygon = new Polygon();
        int n = this.getVertexCount(state);
        Point first = new Point();
        Point last = new Point();
        for (int i = 0; i < n; ++i) {
            int x = (int)coords[i].x;
            int y = (int)coords[i].y;
            if (i == 0) {
                first.x = x;
                first.y = y;
            }
            if (i == n - 1) {
                last.x = x;
                last.y = y;
            }
            polygon.addPoint(x, y);
        }
        if (first.x != last.x || first.y != last.y) {
            polygon.addPoint(first.x, first.y);
        }
        bgc.fillPolygon(polygon);
    }

    protected void addNamestackToFeedbackBuffer(State state) {
        if (state.isDepthSortingOn()) {
            state.feedbackBuffer.addElement(this.nameTreeToStack(this.name));
        } else {
            state.feedbackBuffer.addElement(state.copyNameStack());
        }
    }

    protected void addShapeToFeedbackBuffer(State state) {
        Point4[] coords = this.getScreenCoords(state);
        Polygon polygon = new Polygon();
        int n = this.getVertexCount(state);
        Point first = new Point();
        Point last = new Point();
        for (int i = 0; i < n; ++i) {
            int x = (int)coords[i].x;
            int y = (int)coords[i].y;
            if (i == 0) {
                first.x = x;
                first.y = y;
            }
            if (i == n - 1) {
                last.x = x;
                last.y = y;
            }
            polygon.addPoint(x, y);
        }
        if (first.x != last.x || first.y != last.y) {
            polygon.addPoint(first.x, first.y);
        }
        state.feedbackBuffer.addElement(polygon);
    }

    private Stack nameTreeToStack(NameTree leaf) {
        Stack<Object> stack = new Stack<Object>();
        if (leaf != null) {
            stack.add(0, leaf.getName());
            for (NameTree nt = leaf.getParent(); nt != null && nt.getName() != null; nt = nt.getParent()) {
                stack.add(0, nt.getName());
            }
        }
        stack.add(0, new Integer(stack.size() + 1));
        return stack;
    }

    @Override
    public void computeScreen(Channel ch) {
        State state = ch.state;
        this.name = state.getCurrentName();
        this.clipRect = state.clipRect;
        this.color = state.color;
        this.alpha = state.alpha;
        this.shadowEnabled = state.capabilities[11];
        this.shadowOffsetX = state.shadowOffsetX;
        this.shadowOffsetY = state.shadowOffsetY;
        this.shadowTransparency = state.shadowTransparency;
        this.shadowSoftness = state.shadowSoftness;
        this.shadowColor = state.shadowColor;
    }

    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        return false;
    }

    public Object[] getNameStack() {
        return this.nameStack;
    }

    public NameTree getName() {
        return this.name;
    }

    public Rectangle intersectPickAperture(Rectangle aperture, State state) {
        Rectangle result = state.rt1;
        result = state.ApplyClip(this.clipRect, aperture);
        return result;
    }

    boolean inside(int x, int y, State state) {
        return false;
    }

    public int test(Shape q, State state) {
        if (q instanceof Solid) {
            int result = ((Solid)q).test(this, state);
            return this.invertResult(result);
        }
        if (!this.bbox.intersects(q.bbox)) {
            return 2;
        }
        if (q.getZmin() > this.getZmax()) {
            return 1;
        }
        if (q.getZmax() < this.getZmin()) {
            return 0;
        }
        int np = this.getVertexCount(state);
        int nq = q.getVertexCount(state);
        switch (np) {
            case 0: {
                return 2;
            }
            case 1: {
                switch (nq) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return q.zmin > this.zmin ? 1 : 0;
                    }
                }
                return this.testPointToPolygon(this, q, state);
            }
            case 2: {
                switch (nq) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return q.zmin > this.zmin ? 1 : 0;
                    }
                    case 2: {
                        return this.testEdges(this, q, state);
                    }
                }
                return this.testLineToPolygon(this, q, state);
            }
        }
        switch (nq) {
            case 0: {
                return 2;
            }
            case 1: {
                int result = this.testPointToPolygon(q, this, state);
                return this.invertResult(result);
            }
            case 2: {
                int result = this.testLineToPolygon(q, this, state);
                return this.invertResult(result);
            }
        }
        return this.testPolygonToPolygon(this, q, state);
    }

    private final int testEdges(Shape p, Shape q, State state) {
        double[] slope = state.scratchDouble2;
        Point4[] pscreen = p.getScreenCoords(state);
        Point4[] qscreen = q.getScreenCoords(state);
        int np = pscreen.length;
        int nq = qscreen.length;
        Point4 pi = pscreen[np - 1];
        for (int i = 0; i < np; ++i) {
            Point4 po = pi;
            pi = pscreen[i];
            Point4 qj = qscreen[nq - 1];
            for (int j = 0; j < nq; ++j) {
                double z2;
                double z1;
                double d;
                Point4 qo = qj;
                qj = qscreen[j];
                if (!Shape.edgesIntersect(po.x, po.y, pi.x, pi.y, qo.x, qo.y, qj.x, qj.y, slope) || (d = (z1 = po.z + slope[0] * (pi.z - po.z)) - (z2 = qo.z + slope[1] * (qj.z - qo.z))) < 1.0E-10 && d > -1.0E-10) continue;
                if (z1 > z2) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    protected static boolean edgesIntersect(double poX, double poY, double piX, double piY, double qoX, double qoY, double qjX, double qjY, double[] slopes) {
        double s = 0.0;
        double t = 0.0;
        double a = (qoX - qjX) * (poY - piY) - (poX - piX) * (qoY - qjY);
        if (a < 1.0E-10 && a > -1.0E-10) {
            return false;
        }
        s = ((qoX - qjX) * (poY - qoY) - (poX - qoX) * (qoY - qjY)) / a;
        if (s < 0.0 || s > 1.0) {
            return false;
        }
        t = ((poX - piX) * (poY - qoY) - (poX - qoX) * (poY - piY)) / a;
        if (t < 0.0 || t > 1.0) {
            return false;
        }
        slopes[0] = s;
        slopes[1] = t;
        return true;
    }

    private final int testPointToPolygon(Shape p, Shape q, State state) {
        int result = 2;
        Point4 pCenter = p.getScreenCenter();
        if (q.inside((int)pCenter.x, (int)pCenter.y, state)) {
            Point4 u = state.pt1;
            Ray ray = state.tempRay;
            ray.setDirection(0.0, 0.0, -1.0);
            ray.setOrigin(pCenter);
            ray.intersectPoint((J3Polygon)q, u, state.pt2);
            double distance = u.z - pCenter.z;
            if (distance > 1.0E-10 || distance < -1.0E-10) {
                result = u.z > pCenter.z ? 1 : 0;
            }
        }
        return result;
    }

    private final int testLineToPolygon(Shape p, Shape q, State state) {
        int result = this.testPointToPolygon(p, q, state);
        if (result == 2) {
            result = this.testEdges(p, q, state);
        }
        return result;
    }

    private final int testPolygonToPolygon(Shape p, Shape q, State state) {
        int result = this.testPointToPolygon(p, q, state);
        if (result == 2) {
            result = this.testPointToPolygon(q, p, state);
            if ((result = this.invertResult(result)) == 2) {
                result = this.testEdges(p, q, state);
            }
        }
        return result;
    }

    private int invertResult(int result) {
        switch (result) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid sort result");
    }

    protected Point4[] getScreenCoords(State state) {
        return this.dscr;
    }

    public static int getBlurringMargin(float dist, float blur, int quality) {
        double newBlur = 0.0;
        for (int i = 0; i < quality; ++i) {
            newBlur += (double)(blur * blur);
        }
        newBlur = Math.ceil(Math.sqrt(newBlur));
        return (int)((double)dist + newBlur);
    }

    public BufferedImage blendImages(BufferedImage src, BufferedImage[] blendingImages, int category, int type, int offsetX, int offsetY) {
        BufferedImage dst = src;
        switch (type) {
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                if (blendingImages == null || blendingImages.length < 2) break;
                BlendFilter f = new BlendFilter();
                f.setOffsets(offsetX, offsetY);
                f.setMode(BlendFilter.Mode.MULTIPLY);
                f.setImage(blendingImages[0]);
                dst = f.filter(src, null);
                f.setMode(BlendFilter.Mode.COLOR_DODGE);
                f.setImage(blendingImages[1]);
                dst = f.filter(dst, null);
                break;
            }
        }
        return dst;
    }
}

