/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.State;
import java.awt.Color;

class ScanConvert {
    private static final int ANTI_SUBYRES = 8;
    private static final int ANTI_SUBXRES = 16;
    private static final int MAX_X = Short.MAX_VALUE;
    private static SubPixel[] sp = new SubPixel[8];
    private int activeEdgeCount;
    private Edge[] activeEdge;
    private int[] vertexIndex;
    private SubPixelInfo spi = new SubPixelInfo();

    private static int MODRES(int y) {
        return 0;
    }

    public ScanConvert() {
        this.spi.subxres = 1;
        this.spi.subyres = 1;
    }

    static void drawCircle(State state, double centerX, double centerY, double centerZ, double radius, int precision, Appearance appearance) {
        int vertexPerQuadrant = 3;
        vertexPerQuadrant = 5;
        int vertexCount = 4 * vertexPerQuadrant;
        state.reallocScratchPtArray(vertexCount);
        Point4[] vertex = state.ptArray;
        double angle = 1.5707963267948966;
        vertex[0].x = (int)(Math.cos(angle) * radius + 0.5);
        vertex[0].y = (int)(Math.sin(angle) * radius + 0.5);
        angle = 1.0471975511965976;
        vertex[1].x = (int)(Math.cos(angle) * radius + 0.5);
        vertex[1].y = (int)(Math.sin(angle) * radius + 0.5);
        angle = 0.7853981633974483;
        vertex[2].x = (int)(Math.cos(angle) * radius + 0.5);
        vertex[2].y = (int)(Math.sin(angle) * radius + 0.5);
        vertex[3].x = vertex[1].y;
        vertex[3].y = vertex[1].x;
        vertex[4].x = vertex[0].y;
        vertex[4].y = vertex[0].x;
        int[] quadrantFactorX = new int[]{1, -1, 1, -1};
        int[] quadrantFactorY = new int[]{1, 1, -1, 1};
        for (int quadrant = 1; quadrant < 4; ++quadrant) {
            for (int v = 0; v < vertexPerQuadrant; ++v) {
                int from = quadrant * vertexPerQuadrant - 1 - v;
                int to = quadrant * vertexPerQuadrant + v;
                vertex[to].x = (double)quadrantFactorX[quadrant] * vertex[from].x;
                vertex[to].y = (double)quadrantFactorY[quadrant] * vertex[from].y;
            }
        }
        for (int i = 0; i < vertexCount; ++i) {
            vertex[i].x += centerX;
            vertex[i].y += centerY;
        }
        int shadeModelSave = state.shadeModel;
        state.shadeModel = 1;
        state.scanConvert.drawConcavePolygon(state, vertexCount, vertex, appearance);
        state.shadeModel = shadeModelSave;
    }

    public void drawCircle(State state, int centerX, int centerY, double centerZ, int size, Appearance appearance) {
        int x0 = centerX;
        int y0 = centerY;
        int half = size / 2;
        int left = x0 - half;
        int right = x0 + half;
        int top = y0 + half;
        int bottom = y0 - half;
        if (size <= 3) {
            state.reallocScratchPtArray(4);
            Point4[] vertex = state.ptArray;
            vertex[0].set(left, top, centerZ);
            vertex[1].set(right, top, centerZ);
            vertex[2].set(right, bottom, centerZ);
            vertex[3].set(left, bottom, centerZ);
            this.drawConcavePolygon(state, 4, vertex, appearance);
        } else if (size <= 11) {
            int d = (size + 1) / 4;
            state.reallocScratchPtArray(8);
            Point4[] vertex = state.ptArray;
            vertex[0].set(left, top - d, centerZ);
            vertex[1].set(left + d, top, centerZ);
            vertex[2].set(right - d, top, centerZ);
            vertex[3].set(right, top - d, centerZ);
            vertex[4].set(right, bottom + d, centerZ);
            vertex[5].set(right - d, bottom, centerZ);
            vertex[6].set(left + d, bottom, centerZ);
            vertex[7].set(left, bottom + d, centerZ);
            this.drawConcavePolygon(state, 8, vertex, appearance);
        } else {
            int i;
            int[] octX = new int[size * 2];
            int[] octY = new int[size * 2];
            int num = ScanConvert.getPointsInOctant(0, 0, half, octX, octY);
            int vertexCount = num * 8;
            int vi = 0;
            state.reallocScratchPtArray(vertexCount);
            Point4[] vertex = state.ptArray;
            for (i = 0; i < num - 1; ++i) {
                vertex[vi++].set(x0 + octX[i], y0 + octY[i], centerZ);
            }
            for (i = num - 1; i > 0; --i) {
                vertex[vi++].set(x0 + octY[i], y0 + octX[i], centerZ);
            }
            for (i = 0; i < num - 1; ++i) {
                vertex[vi++].set(x0 + octY[i], y0 - octX[i], centerZ);
            }
            for (i = num - 1; i > 0; --i) {
                vertex[vi++].set(x0 + octX[i], y0 - octY[i], centerZ);
            }
            for (i = 0; i < num - 1; ++i) {
                vertex[vi++].set(x0 - octX[i], y0 - octY[i], centerZ);
            }
            for (i = num - 1; i > 0; --i) {
                vertex[vi++].set(x0 - octY[i], y0 - octX[i], centerZ);
            }
            for (i = 0; i < num - 1; ++i) {
                vertex[vi++].set(x0 - octY[i], y0 + octX[i], centerZ);
            }
            for (i = num - 1; i > 0; --i) {
                vertex[vi++].set(x0 - octX[i], y0 + octY[i], centerZ);
            }
            this.drawConcavePolygon(state, vi, vertex, appearance);
        }
    }

    private static int getPointsInOctant(int x0, int y0, int r, int[] X, int[] Y) {
        int x = 0;
        int y = r;
        int d = 1 - r;
        int n = 0;
        X[n] = x0 + x;
        Y[n] = y0 + y;
        ++n;
        while (y >= x) {
            if (d <= 0) {
                d += 2 * x + 3;
                ++x;
                continue;
            }
            X[n] = x0 + x;
            Y[n] = y0 + y;
            d += 2 * (x - y) + 5;
            X[++n] = x0 + ++x;
            Y[n] = y0 + --y;
            ++n;
        }
        return n;
    }

    static void drawPolygon(State state, int vertexCount, int[] xpoints, int[] ypoints, Point4[] dscr, boolean clockwise, Appearance appearance) {
        int vNextLeft;
        int i;
        int xLeft = 0;
        int xNextLeft = 0;
        int xRight = 0;
        int xNextRight = 0;
        SubPixelInfo subPixelInfo = new SubPixelInfo();
        int vLeft = 0;
        for (i = 1; i < vertexCount; ++i) {
            if (ypoints[i] >= ypoints[vLeft]) continue;
            vLeft = i;
        }
        int vNextRight = vNextLeft = vLeft;
        int vRight = vNextLeft;
        if (state.capabilities[13]) {
            subPixelInfo.subyres = 8;
            subPixelInfo.subxres = 16;
        } else {
            subPixelInfo.subyres = 1;
            subPixelInfo.subxres = 1;
        }
        subPixelInfo.max_area = subPixelInfo.subyres * subPixelInfo.subxres;
        for (i = 0; i < subPixelInfo.subyres; ++i) {
            ScanConvert.sp[i].xRight = -1;
            ScanConvert.sp[i].xLeft = -1;
        }
        subPixelInfo.xRmin = Short.MAX_VALUE;
        subPixelInfo.xLmin = Short.MAX_VALUE;
        subPixelInfo.xRmax = -1;
        subPixelInfo.xLmax = -1;
        int y = ypoints[vLeft] * subPixelInfo.subyres;
        while (true) {
            if (y == ypoints[vNextLeft] * subPixelInfo.subyres) {
                vLeft = vNextLeft;
                if ((vNextLeft += clockwise ? 1 : -1) >= vertexCount) {
                    vNextLeft = 0;
                } else if (vNextLeft < 0) {
                    vNextLeft = vertexCount - 1;
                }
                if (vNextLeft == vRight) {
                    return;
                }
                xLeft = xpoints[vLeft] * subPixelInfo.subxres;
                xNextLeft = xpoints[vNextLeft] * subPixelInfo.subxres;
                continue;
            }
            while (y == ypoints[vNextRight] * subPixelInfo.subyres) {
                vRight = vNextRight;
                if ((vNextRight += clockwise ? -1 : 1) >= vertexCount) {
                    vNextRight = 0;
                } else if (vNextRight < 0) {
                    vNextRight = vertexCount - 1;
                }
                xRight = xpoints[vRight] * subPixelInfo.subxres;
                xNextRight = xpoints[vNextRight] * subPixelInfo.subxres;
            }
            if (y > ypoints[vNextLeft] * subPixelInfo.subyres || y > ypoints[vNextRight] * subPixelInfo.subyres) {
                while (ScanConvert.MODRES(y * subPixelInfo.subyres) != 0) {
                    ScanConvert.sp[ScanConvert.MODRES((int)(y * subPixelInfo.subyres))].xRight = -1;
                    ScanConvert.sp[ScanConvert.MODRES((int)(y * subPixelInfo.subyres))].xLeft = -1;
                    ++y;
                }
                ScanConvert.setupVertex(state, appearance, subPixelInfo, vLeft, xpoints, state.vScanLeft);
                ScanConvert.setupVertex(state, appearance, subPixelInfo, vRight, xpoints, state.vScanRight);
                ScanConvert.renderSpan(state, appearance, subPixelInfo, state.vScanLeft, state.vScanRight, y / subPixelInfo.subyres);
                return;
            }
            int spIndex = ScanConvert.MODRES(y);
            double aLeft = (double)(y - ypoints[vLeft] * subPixelInfo.subyres) / (double)(ypoints[vNextLeft] * subPixelInfo.subyres - ypoints[vLeft] * subPixelInfo.subyres);
            ScanConvert.sp[spIndex].xLeft = (int)ScanConvert.lerp(aLeft, xLeft, xNextLeft);
            if (ScanConvert.sp[spIndex].xLeft < subPixelInfo.xLmin) {
                subPixelInfo.xLmin = ScanConvert.sp[spIndex].xLeft;
            }
            if (ScanConvert.sp[spIndex].xLeft > subPixelInfo.xLmax) {
                subPixelInfo.xLmax = ScanConvert.sp[spIndex].xLeft;
            }
            double aRight = (double)(y - ypoints[vRight] * subPixelInfo.subyres) / (double)(ypoints[vNextRight] * subPixelInfo.subyres - ypoints[vRight] * subPixelInfo.subyres);
            ScanConvert.sp[spIndex].xRight = (int)ScanConvert.lerp(aRight, xRight, xNextRight);
            if (ScanConvert.sp[spIndex].xRight < subPixelInfo.xRmin) {
                subPixelInfo.xRmin = ScanConvert.sp[spIndex].xRight;
            }
            if (ScanConvert.sp[spIndex].xRight > subPixelInfo.xRmax) {
                subPixelInfo.xRmax = ScanConvert.sp[spIndex].xRight;
            }
            if (ScanConvert.MODRES(y) == subPixelInfo.subyres - 1) {
                ScanConvert.vLerp(state, appearance, subPixelInfo, xpoints, ypoints, dscr, aLeft, vLeft, vNextLeft, state.vScanLeft);
                ScanConvert.vLerp(state, appearance, subPixelInfo, xpoints, ypoints, dscr, aRight, vRight, vNextRight, state.vScanRight);
                ScanConvert.renderSpan(state, appearance, subPixelInfo, state.vScanLeft, state.vScanRight, y / subPixelInfo.subyres);
                subPixelInfo.xRmin = Short.MAX_VALUE;
                subPixelInfo.xLmin = Short.MAX_VALUE;
                subPixelInfo.xRmax = -1;
                subPixelInfo.xLmax = -1;
            }
            ++y;
        }
    }

    static void bresenhamLine(State state, int lineWidth, int x0, int y0, double z0, Color color1, float alpha1, int x1, int y1, double z1, Color color2, float alpha2) {
        double poinc = 0.0;
        double painc = 0.0;
        double pdinc = 0.0;
        double pmid = 0.0;
        double slope = 0.0;
        float a = 1.0f;
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        a = alpha1;
        r = (float)color1.getRed() / 255.0f;
        g = (float)color1.getGreen() / 255.0f;
        b = (float)color1.getBlue() / 255.0f;
        state.ch.setPixelType(1);
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int Xincr = x0 > x1 ? -1 : 1;
        int Yincr = y0 > y1 ? -1 : 1;
        if (dx > 0) {
            slope = (double)dy / (double)dx;
            poinc = Math.sqrt(1.0 / (1.0 + slope * slope));
            painc = slope * poinc;
            pdinc = painc - poinc;
            pmid = 0.0;
        }
        double z = 0.0;
        double lerpA = 0.0;
        double lerpStep = 1.0;
        boolean zbufferOn = state.isZBufferingOn();
        if (dx >= dy) {
            int dPr = dy << 1;
            int dPru = dPr - (dx << 1);
            int P = dPr - dx;
            lerpStep = Math.abs(1.0 / (double)dx);
            while (dx >= 0) {
                if (zbufferOn) {
                    z = ScanConvert.lerp(lerpA, z0, z1);
                }
                state.ch.plant(x0, y0, z, a, r, g, b);
                if (P > 0) {
                    x0 += Xincr;
                    y0 += Yincr;
                    P += dPru;
                    pmid += pdinc;
                } else {
                    x0 += Xincr;
                    P += dPr;
                    pmid += painc;
                }
                --dx;
                lerpA += lerpStep;
            }
        } else {
            int dPr = dx << 1;
            int dPru = dPr - (dy << 1);
            int P = dPr - dy;
            lerpStep = Math.abs(1.0 / (double)dy);
            while (dy >= 0) {
                if (zbufferOn) {
                    z = ScanConvert.lerp(lerpA, z0, z1);
                }
                state.ch.plant(x0, y0, z, a, r, g, b);
                if (P > 0) {
                    x0 += Xincr;
                    y0 += Yincr;
                    P += dPru;
                } else {
                    y0 += Yincr;
                    P += dPr;
                }
                --dy;
                lerpA += lerpStep;
            }
        }
    }

    static double coverage(double perpendicularDistance, double maxDistance) {
        double c = maxDistance - Math.abs(perpendicularDistance);
        return c;
    }

    private static void renderSpan(State state, Appearance appearance, SubPixelInfo subPixelInfo, InterpolatedVertex vLeft, InterpolatedVertex vRight, int y) {
        float a = 0.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float edgeR = 0.0f;
        float edgeG = 0.0f;
        float edgeB = 0.0f;
        if (appearance.edgeColor != null && state.fillmode == 6) {
            edgeR = (float)appearance.edgeColor.getRed() / 255.0f;
            edgeG = (float)appearance.edgeColor.getGreen() / 255.0f;
            edgeB = (float)appearance.edgeColor.getBlue() / 255.0f;
        }
        if (state.shadeModel == 1) {
            r = (float)appearance.litColor.getRed() / 255.0f;
            g = (float)appearance.litColor.getGreen() / 255.0f;
            b = (float)appearance.litColor.getBlue() / 255.0f;
        }
        boolean zbufferOn = state.isZBufferingOn();
        double z = 0.0;
        double lerpA = 0.0;
        double lerpStep = 1.0;
        if (subPixelInfo.xRmax != subPixelInfo.xLmin) {
            lerpStep = 1.0 / ((double)subPixelInfo.xRmax - (double)subPixelInfo.xLmin);
        }
        int x = (int)((double)subPixelInfo.subxres * Math.floor(subPixelInfo.xLmin / subPixelInfo.subxres));
        while (x <= subPixelInfo.xRmax) {
            if (state.shadeModel == 0) {
                a = (float)ScanConvert.lerp(lerpA, vLeft.a, vRight.a);
                r = (float)ScanConvert.lerp(lerpA, vLeft.r, vRight.r);
                g = (float)ScanConvert.lerp(lerpA, vLeft.g, vRight.g);
                b = (float)ScanConvert.lerp(lerpA, vLeft.b, vRight.b);
            } else {
                a = appearance.alpha;
            }
            if (state.capabilities[13]) {
                float c = ScanConvert.coverage(x, subPixelInfo);
                a = c * a;
            }
            if (zbufferOn) {
                z = ScanConvert.lerp(lerpA, vLeft.z, vRight.z);
            }
            float ta = a;
            float tr = r;
            float tg = g;
            float tb = b;
            if (state.fillmode == 6 && ((x + y) % 7 == 0 || (x + y + 1) % 7 == 0)) {
                ta = 1.0f;
                tr = edgeR;
                tg = edgeG;
                tb = edgeB;
            }
            state.ch.plant(x / subPixelInfo.subxres, y, z, ta, tr, tg, tb);
            x += subPixelInfo.subxres;
            lerpA += lerpStep;
        }
    }

    private static float coverage(int x, SubPixelInfo subPixelInfo) {
        int xr = x + subPixelInfo.subxres - 1;
        if (x > subPixelInfo.xLmax && x < subPixelInfo.xRmin) {
            return 1.0f;
        }
        int area = 0;
        for (int y = 0; y < subPixelInfo.subyres; ++y) {
            int partialArea = Math.min(ScanConvert.sp[y].xRight, xr) - Math.max(ScanConvert.sp[y].xLeft, x) + 1;
            if (partialArea <= 0) continue;
            area += partialArea;
        }
        return (float)area / (float)subPixelInfo.max_area;
    }

    private static InterpolatedVertex setupVertex(State state, Appearance appearance, SubPixelInfo subPixelInfo, int vertexIndex, int[] xpoints, InterpolatedVertex v) {
        v.x = xpoints[vertexIndex] * subPixelInfo.subxres;
        if (state.shadeModel == 0) {
            v.a = appearance.alphaPerVertex[vertexIndex];
            Color c = appearance.colorPerVertex[vertexIndex];
            v.r = (float)c.getRed() / 255.0f;
            v.g = (float)c.getGreen() / 255.0f;
            v.b = (float)c.getBlue() / 255.0f;
        } else {
            v.a = appearance.alpha;
            Color c = appearance.litColor;
            v.r = (float)c.getRed() / 255.0f;
            v.g = (float)c.getGreen() / 255.0f;
            v.b = (float)c.getBlue() / 255.0f;
        }
        return v;
    }

    static double lerp(double alpha, double d1, double d2) {
        double result = d1 + alpha * (d2 - d1);
        return result;
    }

    private static void vLerp(State state, Appearance appearance, SubPixelInfo subPixelInfo, int[] xpoints, int[] ypoints, Point4[] dscr, double alpha, int vertexA, int vertexB, InterpolatedVertex v) {
        v.x = (int)ScanConvert.lerp(alpha, xpoints[vertexA] * subPixelInfo.subxres, xpoints[vertexB] * subPixelInfo.subxres);
        v.z = ScanConvert.lerp(alpha, dscr[vertexA].z, dscr[vertexB].z);
        if (state.shadeModel == 0) {
            v.a = ScanConvert.lerp(alpha, appearance.alphaPerVertex[vertexA], appearance.alphaPerVertex[vertexB]);
            Color c = appearance.isLightOn ? appearance.litColorPerVertex[vertexA] : appearance.colorPerVertex[vertexA];
            double rA = (float)c.getRed() / 255.0f;
            double gA = (float)c.getGreen() / 255.0f;
            double bA = (float)c.getBlue() / 255.0f;
            c = appearance.isLightOn ? appearance.litColorPerVertex[vertexB] : appearance.colorPerVertex[vertexB];
            double rB = (float)c.getRed() / 255.0f;
            double gB = (float)c.getGreen() / 255.0f;
            double bB = (float)c.getBlue() / 255.0f;
            v.r = ScanConvert.lerp(alpha, rA, rB);
            v.g = ScanConvert.lerp(alpha, gA, gB);
            v.b = ScanConvert.lerp(alpha, bA, bB);
        }
    }

    public void reallocActiveEdge(int count) {
        if (this.vertexIndex == null || this.vertexIndex.length < count) {
            this.vertexIndex = new int[count];
        }
        if (this.activeEdge == null || this.activeEdge.length < count) {
            int oldCount = 0;
            if (this.activeEdge != null) {
                oldCount = this.activeEdge.length;
                Edge[] oldActiveEdge = this.activeEdge;
                this.activeEdge = new Edge[count];
                System.arraycopy(oldActiveEdge, 0, this.activeEdge, 0, oldCount);
            } else {
                this.activeEdge = new Edge[count];
            }
            for (int i = oldCount; i < count; ++i) {
                this.activeEdge[i] = new Edge();
            }
        }
    }

    public void drawConcavePolygon(State state, int vertexCount, Point4[] vertex, Appearance appearance) {
        int i;
        InterpolatedVertex vLeft = state.vScanLeft;
        InterpolatedVertex vRight = state.vScanRight;
        if (vertexCount <= 0) {
            return;
        }
        this.reallocActiveEdge(vertexCount);
        for (i = 0; i < vertexCount; ++i) {
            this.vertexIndex[i] = i;
        }
        ScanConvert.sort(vertex, this.vertexIndex, vertexCount);
        this.activeEdgeCount = 0;
        int k = 0;
        int y0 = (int)Math.floor(vertex[this.vertexIndex[0]].y + 0.5);
        int y1 = (int)Math.floor(vertex[this.vertexIndex[vertexCount - 1]].y + 0.5);
        for (int y = y0; y <= y1; ++y) {
            int j;
            while (k < vertexCount && vertex[this.vertexIndex[k]].y <= (double)y + 0.5) {
                i = this.vertexIndex[k];
                int n = j = i > 0 ? i - 1 : vertexCount - 1;
                if (vertex[j].y <= (double)y - 0.5) {
                    this.activeEdgeCount = this.deleteEdge(this.activeEdge, this.activeEdgeCount, j);
                } else if (vertex[j].y > (double)y + 0.5) {
                    this.activeEdgeCount = this.insertEdge(vertex, vertexCount, this.activeEdge, this.activeEdgeCount, j, y);
                }
                int n2 = j = i < vertexCount - 1 ? i + 1 : 0;
                if (vertex[j].y <= (double)y - 0.5) {
                    this.activeEdgeCount = this.deleteEdge(this.activeEdge, this.activeEdgeCount, i);
                } else if (vertex[j].y > (double)y + 0.5) {
                    this.activeEdgeCount = this.insertEdge(vertex, vertexCount, this.activeEdge, this.activeEdgeCount, i, y);
                }
                ++k;
            }
            ScanConvert.sort(this.activeEdge, this.activeEdgeCount);
            for (j = 0; j < this.activeEdgeCount; j += 2) {
                int xr;
                int xl = (int)Math.ceil(this.activeEdge[j].x);
                if (xl <= (xr = (int)Math.floor(this.activeEdge[j + 1].x))) {
                    this.spi.xLmin = xl;
                    this.spi.xLmax = xl;
                    this.spi.xRmin = xr;
                    this.spi.xRmax = xr;
                    vLeft = ScanConvert.setupVertex(state, appearance, this.activeEdge[j], y, vertex, vertexCount, vLeft);
                    vRight = ScanConvert.setupVertex(state, appearance, this.activeEdge[j + 1], y, vertex, vertexCount, vRight);
                    ScanConvert.renderSpan(state, appearance, this.spi, vLeft, vRight, y);
                }
                this.activeEdge[j].x += this.activeEdge[j].dx;
                this.activeEdge[j + 1].x += this.activeEdge[j + 1].dx;
            }
        }
    }

    private static InterpolatedVertex setupVertex(State state, Appearance appearance, Edge edge, double y, Point4[] vertex, int vertexCount, InterpolatedVertex v) {
        int v1 = edge.i;
        int v2 = v1 < vertexCount - 1 ? v1 + 1 : 0;
        double v2y = vertex[v2].y;
        double v1y = vertex[v1].y;
        if (v2y < v1y) {
            int save = v1;
            v1 = v2;
            v2 = save;
            v1y = vertex[v1].y;
            v2y = vertex[v2].y;
        }
        double alpha = (y - v1y) / (v2y - v1y);
        v.z = ScanConvert.lerp(alpha, vertex[v1].z, vertex[v2].z);
        if (state.shadeModel == 0) {
            v.a = ScanConvert.lerp(alpha, appearance.alphaPerVertex[v1], appearance.alphaPerVertex[v2]);
            Color c = appearance.isLightOn ? appearance.litColorPerVertex[v1] : appearance.colorPerVertex[v1];
            double rA = (float)c.getRed() / 255.0f;
            double gA = (float)c.getGreen() / 255.0f;
            double bA = (float)c.getBlue() / 255.0f;
            c = appearance.isLightOn ? appearance.litColorPerVertex[v2] : appearance.colorPerVertex[v2];
            double rB = (float)c.getRed() / 255.0f;
            double gB = (float)c.getGreen() / 255.0f;
            double bB = (float)c.getBlue() / 255.0f;
            v.r = ScanConvert.lerp(alpha, rA, rB);
            v.g = ScanConvert.lerp(alpha, gA, gB);
            v.b = ScanConvert.lerp(alpha, bA, bB);
        } else {
            v.a = appearance.alpha;
            Color c = appearance.litColor;
            v.r = (float)c.getRed() / 255.0f;
            v.g = (float)c.getGreen() / 255.0f;
            v.b = (float)c.getBlue() / 255.0f;
        }
        return v;
    }

    private int deleteEdge(Edge[] activeEdge, int activeEdgeCount, int i) {
        int j;
        for (j = 0; j < activeEdgeCount && activeEdge[j].i != i; ++j) {
        }
        if (j < activeEdgeCount) {
            Edge save = activeEdge[j];
            System.arraycopy(activeEdge, j + 1, activeEdge, j, --activeEdgeCount - j);
            activeEdge[activeEdgeCount] = save;
        }
        return activeEdgeCount;
    }

    private int insertEdge(Point4[] vertex, int vertexCount, Edge[] activeEdge, int activeEdgeCount, int i, int y) {
        double dx;
        Point4 q;
        Point4 p;
        int j;
        int n = j = i < vertexCount - 1 ? i + 1 : 0;
        if (vertex[i].y < vertex[j].y) {
            p = vertex[i];
            q = vertex[j];
        } else {
            p = vertex[j];
            q = vertex[i];
        }
        activeEdge[activeEdgeCount].dx = dx = (q.x - p.x) / (q.y - p.y);
        activeEdge[activeEdgeCount].x = dx * ((double)y + 0.5 - p.y) + p.x;
        activeEdge[activeEdgeCount].i = i;
        return ++activeEdgeCount;
    }

    public static int[] sort(Point4[] sortlist, int[] indicies_in, int n_in) {
        int n = n_in;
        int[] indicies = indicies_in;
        if (sortlist == null || sortlist.length <= 1 || n <= 1) {
            return null;
        }
        if (indicies == null) {
            indicies = new int[n];
            if (indicies == null) {
                return null;
            }
            for (int i = 0; i < indicies.length; ++i) {
                indicies[i] = i;
            }
        }
        int parent = n / 2 + 1;
        int curlen = n;
        while (true) {
            int holder;
            if (parent > 1) {
                holder = indicies[--parent - 1];
            } else {
                holder = indicies[curlen - 1];
                indicies[curlen - 1] = indicies[0];
                if (--curlen == 0) {
                    indicies[0] = holder;
                    return indicies;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && sortlist[indicies[largest_child - 1]].y < sortlist[indicies[largest_child]].y) {
                    ++largest_child;
                }
                if (sortlist[holder].y < sortlist[indicies[largest_child - 1]].y) {
                    indicies[curnode - 1] = indicies[largest_child - 1];
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            indicies[curnode - 1] = holder;
        }
    }

    public static void sort(Edge[] sortlist, int n_in) {
        int n = n_in;
        if (sortlist == null || sortlist.length <= 1 || n <= 1) {
            return;
        }
        int parent = n / 2 + 1;
        int curlen = n;
        while (true) {
            Edge holder;
            if (parent > 1) {
                holder = sortlist[--parent - 1];
            } else {
                holder = sortlist[curlen - 1];
                sortlist[curlen - 1] = sortlist[0];
                if (--curlen == 0) {
                    sortlist[0] = holder;
                    return;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && sortlist[largest_child - 1].x < sortlist[largest_child].x) {
                    ++largest_child;
                }
                if (holder.x < sortlist[largest_child - 1].x) {
                    sortlist[curnode - 1] = sortlist[largest_child - 1];
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            sortlist[curnode - 1] = holder;
        }
    }

    static {
        for (int i = 0; i < 8; ++i) {
            ScanConvert.sp[i] = new SubPixel();
        }
    }

    private static class SubPixelInfo {
        int subyres;
        int subxres;
        int xLmin;
        int xLmax;
        int xRmax;
        int xRmin;
        int max_area;

        private SubPixelInfo() {
        }
    }

    private static class SubPixel {
        int xLeft;
        int xRight;

        private SubPixel() {
        }
    }

    static class Appearance {
        Color color;
        Color edgeColor;
        Color litColor;
        Color[] colorPerVertex;
        Color[] litColorPerVertex;
        float[] alphaPerVertex;
        float alpha;
        boolean isLightOn;

        Appearance() {
        }
    }

    static class InterpolatedVertex {
        int x;
        int y;
        double z;
        double r;
        double g;
        double b;
        double a;

        InterpolatedVertex() {
        }
    }

    static class Edge {
        double x;
        double dx;
        int i;

        Edge() {
        }
    }
}

