/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.DilationFilter;
import com.sas.graphics.image.GaussianFilter;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.RasterShape;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.TransInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class RasterText
extends RasterShape {
    private static final int X = 0;
    private static final int Y = 1;
    private static final int multiLineOffsetIndex = 32;
    private static final char newline = '\n';
    private Font font;
    private List multiLineString = null;
    private String singleLineString = null;
    private double[] textWidth;
    private double maxTextWidth;
    private int lineCount;
    private int[] shadowJitterX = new int[]{1, -1, 3, 1, 0, 2, 0, 2, 1};
    private int[] shadowJitterY = new int[]{1, -1, -1, -3, 0, 0, -2, -2, -1};
    private double[] shadowShade = new double[]{1.2, 1.2, 1.2, 1.2f, 1.15, 1.15, 1.15, 1.15, 1.1};
    private double angle;
    private boolean fontNeedsTextLayout = false;
    private static final AffineTransform identity = new AffineTransform();
    private Map fontAttributes = null;
    private Point4[] textProjection = null;
    static final int[] vToH90 = new int[]{2, 1, 0, 0};
    static final int[] hToV90 = new int[]{0, 1, 3};
    static final int[] vToH270 = new int[]{0, 1, 2, 2};
    static final int[] hToV270 = new int[]{3, 1, 0};

    public RasterText(State state) {
        this.init(state);
    }

    public RasterText(State state, String str, double x, double y, double z, int aNangle, Color background, Color backgroundEdge) {
        this(state, str, x, y, z, aNangle, background, backgroundEdge, null);
    }

    public RasterText(State state, String str, double x, double y, double z, int aNangle, Color background, Color backgroundEdge, Insets backgroundPad) {
        this.init(state);
        this.setString(str);
        this.setPosition(x, y, z);
        this.setAngle(aNangle);
        this.setBackgroundColor(background);
        this.setBackgroundEdgeColor(backgroundEdge);
        this.setBackgroundPad(backgroundPad);
    }

    public void init(State state) {
        state.affineTransform = new AffineTransform();
        this.fontAttributes = this.font != null ? this.font.getAttributes() : state.font.getAttributes();
    }

    protected int getShadowAdditionalWidth() {
        return this.shadowOffsetX + 3;
    }

    protected int getShadowAdditionalHeight() {
        return this.shadowOffsetY + 3;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.color = ch.state.color;
        this.font = ch.state.font;
    }

    public void setString(String str) {
        this.makeMultiLine(str);
    }

    private void makeMultiLine(String text) {
        this.lineCount = 1;
        if (text == null) {
            text = "";
        }
        this.singleLineString = text;
        if (text != null && text.length() > 0 && text.indexOf(10) > 0) {
            int nlIndex = 0;
            if (this.multiLineString == null) {
                this.multiLineString = new ArrayList(4);
            }
            this.multiLineString.clear();
            int i = 0;
            while (nlIndex >= 0) {
                nlIndex = text.indexOf(10, i);
                String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
                this.multiLineString.add(line);
                i = 1 + nlIndex;
            }
            this.lineCount = this.multiLineString.size();
            this.singleLineString = null;
        }
    }

    protected double[] getInfoBuffer(State state) {
        int infoLength = 32 + this.lineCount;
        if (state.tempRasterInfo == null || state.tempRasterInfo.length < infoLength) {
            state.tempRasterInfo = new double[infoLength];
        }
        return state.tempRasterInfo;
    }

    protected int index(int x, int y, int rowWidth) {
        return x + y * rowWidth;
    }

    protected void plantPixels(State state, int[] pixels, int left, int top, double z, int w, int h, float alphaValue) {
        int i = 0;
        int lastPixel = pixels[i] - 1;
        float lastR = 0.0f;
        float lastG = 0.0f;
        float lastB = 0.0f;
        float lastA = alphaValue;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = pixels[i];
                if (alphaValue < 1.0f) {
                    if (lastPixel != argb) {
                        lastR = (float)(argb >> 16 & 0xFF) / 255.0f;
                        lastG = (float)(argb >> 8 & 0xFF) / 255.0f;
                        lastB = (float)(argb & 0xFF) / 255.0f;
                        lastPixel = argb;
                    }
                    state.ch.plant(left + x, top + y, z, lastA, lastR, lastG, lastB);
                } else {
                    state.ch.plant(left + x, top + y, z, argb);
                }
                ++i;
            }
        }
    }

    protected void grabPixels(Image textBuffer, int w, int h, int[] pixels) {
        PixelGrabber pg = new PixelGrabber(textBuffer, 0, 0, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        if (this.lineCount == 0) {
            return;
        }
        if (bgc == null) {
            return;
        }
        bgc.setFont(this.font);
        this.setRenderingHints(state, bgc);
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        double[] info = this.computeAlignmentInfo(state, bgc, this.screen.x, this.screen.y);
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc, this.color, info);
        } else {
            this.render(state, bgc, this.color, info);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private void setRenderingHints(State state, Graphics g) {
        Graphics2D bgc = (Graphics2D)g;
        if (state.capabilities[14]) {
            bgc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            bgc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    public double getDescent(State state, Graphics gc, Font f) {
        double pixel = RasterText.getWorldPixelHeight(state);
        double descent = gc.getFontMetrics().getDescent();
        return descent * pixel;
    }

    private boolean needsTextLayout(State state) {
        return (state.capabilities[14] && !state.SVGRendering) | this.fontNeedsTextLayout;
    }

    private static FontRenderContext getFontRenderContext(State state, Graphics2D gc) {
        FontRenderContext frc;
        Object antialiasValue = state.capabilities[14] ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        if (gc != null) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasValue);
            frc = gc.getFontRenderContext();
        } else {
            frc = new FontRenderContext(identity, antialiasValue == RenderingHints.VALUE_TEXT_ANTIALIAS_ON, false);
        }
        return frc;
    }

    private void drawMultiLineText(State state, Graphics2D bgc, AffineTransform xform, double[] info, int xOffset, int yOffset) {
        if (state.outlinedRasterLabel && state.rasterLabelBacklight != 0.0) {
            this.drawBackgroundText(state, bgc, xform, info, xOffset, yOffset);
        }
        float lineOffset = 0.0f;
        for (int i = this.lineCount - 1; i >= 0; --i) {
            String thisLine;
            bgc.setTransform(xform);
            if (this.lineCount > 1) {
                bgc.translate((int)(info[32 + i] + 0.5), 0);
            }
            if ((thisLine = (String)this.multiLineString.get(i)).length() <= 0) continue;
            lineOffset = (float)(info[5] * (double)i + 0.5);
            if (this.needsTextLayout(state)) {
                TextLayout tl = new TextLayout(thisLine, this.fontAttributes, bgc.getFontRenderContext());
                tl.draw(bgc, xOffset, lineOffset + (float)yOffset);
                continue;
            }
            bgc.drawString(thisLine, (float)xOffset, lineOffset + (float)yOffset);
        }
    }

    private void drawSingleLineText(State state, Graphics2D bgc, AffineTransform xform, double[] info, int xOffset, int yOffset) {
        bgc.setTransform(xform);
        if (this.singleLineString.length() > 0) {
            if (state.outlinedRasterLabel && state.rasterLabelBacklight != 0.0) {
                this.drawBackgroundText(state, bgc, xform, info, xOffset, yOffset);
            }
            if (this.needsTextLayout(state)) {
                TextLayout tl = new TextLayout(this.singleLineString, this.fontAttributes, bgc.getFontRenderContext());
                tl.draw(bgc, xOffset, yOffset);
            } else {
                bgc.drawString(this.singleLineString, (float)xOffset, (float)yOffset + 0.5f);
            }
        }
    }

    private void drawBackgroundText(State state, Graphics2D bgc, AffineTransform xform, double[] info, int xOffset, int yOffset) {
        int radius = state.rasterLabelOutlineWidth;
        if (radius == 0) {
            return;
        }
        int margin = radius + 1;
        int img_w = (int)info[30] + margin * 2;
        int img_h = (int)info[31] + margin * 2;
        BufferedImage src = new BufferedImage(img_w, img_h, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2.setFont(this.font);
        int r = state.color.getRed();
        int g = state.color.getGreen();
        int b = state.color.getBlue();
        float[] HSB = Color.RGBtoHSB(r, g, b, null);
        Color c = (double)HSB[2] > 0.5 ? Color.black : Color.white;
        double alpha = state.rasterLabelBacklight;
        if (alpha < 0.0 || alpha > 1.0) {
            alpha = 0.5;
        }
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(alpha * 255.0));
        g2.setColor(c);
        AffineTransform AT = new AffineTransform();
        AT.translate(margin, (int)((double)margin - info[9]));
        if (this.lineCount <= 1) {
            g2.setTransform(AT);
            if (this.needsTextLayout(state)) {
                TextLayout tl = new TextLayout(this.singleLineString, this.fontAttributes, g2.getFontRenderContext());
                tl.draw(g2, xOffset, yOffset);
            } else {
                g2.drawString(this.singleLineString, (float)xOffset, (float)yOffset + 0.5f);
            }
        } else {
            bgc.setTransform(xform);
            float lineOffset = 0.0f;
            for (int i = this.lineCount - 1; i >= 0; --i) {
                String thisLine;
                g2.setTransform(AT);
                if (this.lineCount > 1) {
                    g2.translate((int)(info[32 + i] + 0.5), 0);
                }
                if ((thisLine = (String)this.multiLineString.get(i)).length() <= 0) continue;
                lineOffset = (float)(info[5] * (double)i + 0.5);
                if (this.needsTextLayout(state)) {
                    TextLayout tl = new TextLayout(thisLine, this.fontAttributes, g2.getFontRenderContext());
                    tl.draw(g2, xOffset, lineOffset + (float)yOffset);
                    continue;
                }
                g2.drawString(thisLine, (float)xOffset, lineOffset + (float)yOffset);
            }
        }
        DilationFilter filter = new DilationFilter(radius);
        filter.setForeground(c);
        src = filter.filter(src, null);
        radius = (int)(radius <= 3 ? 2.0 : 2.0 + Math.sqrt((double)radius - 3.0) + 0.5);
        GaussianFilter filter2 = new GaussianFilter((float)radius, (float)radius);
        src = filter2.filter(src, null);
        bgc.drawImage((Image)src, -margin, -margin + (int)info[9], null);
        g2.dispose();
    }

    public void render(State state, Graphics graphics, Color clr, double[] info) {
        Graphics2D bgc = (Graphics2D)graphics;
        AffineTransform originalTx = bgc.getTransform();
        AffineTransform xform = (AffineTransform)state.affineTransform;
        xform.setTransform(originalTx);
        xform.translate(this.screen.x, this.screen.y);
        xform.rotate(-this.angle);
        xform.translate(info[0], info[1]);
        if (this.backgroundColor != null || this.backgroundEdgeColor != null) {
            int h;
            int w;
            int y;
            int x;
            bgc.setTransform(xform);
            if (this.backgroundPad != null) {
                x = 0 - this.backgroundPad.left;
                y = (int)(-info[5] + info[6] + 0.5) - this.backgroundPad.top;
                w = (int)(info[30] + 0.5) + this.backgroundPad.left + this.backgroundPad.right;
                h = (int)(info[31] + 0.5) + this.backgroundPad.top + this.backgroundPad.bottom;
            } else {
                x = 0;
                y = (int)(-info[5] + info[6] + 0.5);
                w = (int)(info[30] + 0.5);
                h = (int)(info[31] + 0.5);
            }
            if (this.backgroundColor != null) {
                bgc.setColor(this.backgroundColor);
                bgc.fillRect(x, y, w, h);
            }
            if (this.backgroundEdgeColor != null) {
                bgc.setColor(this.backgroundEdgeColor);
                bgc.drawRect(x, y, w, h - 1);
            }
        }
        if (this.shadowEnabled) {
            float r = (float)this.shadowColor.getRed() / 255.0f;
            float g = (float)this.shadowColor.getGreen() / 255.0f;
            float b = (float)this.shadowColor.getBlue() / 255.0f;
            for (int i = 0; i < 9; ++i) {
                this.screen.set(this.shadowOffsetX, this.shadowOffsetY, 0.0, 1.0);
                this.screen.x += (double)this.shadowJitterX[i];
                this.screen.y += (double)this.shadowJitterY[i];
                float shade = (float)this.shadowShade[i];
                float clampR = r * shade;
                float clampG = g * shade;
                float clampB = b * shade;
                float clampA = 0.05f * shade;
                if (clampA > 1.0f) {
                    clampA = 1.0f;
                }
                if (clampR > 1.0f) {
                    clampR = 1.0f;
                }
                if (clampG > 1.0f) {
                    clampG = 1.0f;
                }
                if (clampB > 1.0f) {
                    clampB = 1.0f;
                }
                Color c = new Color(clampR, clampG, clampB, clampA);
                bgc.setColor(c);
                if (this.lineCount > 1) {
                    this.drawMultiLineText(state, bgc, xform, info, (int)this.screen.x, (int)this.screen.y);
                    continue;
                }
                this.drawSingleLineText(state, bgc, xform, info, (int)this.screen.x, (int)this.screen.y);
            }
        }
        bgc.setColor(clr);
        if (this.lineCount > 1) {
            this.drawMultiLineText(state, bgc, xform, info, 0, 0);
        } else {
            this.drawSingleLineText(state, bgc, xform, info, 0, 0);
        }
        bgc.setTransform(originalTx);
    }

    protected void softwareRender(State state, Graphics bgc, Color textColor, double[] alignment) {
        int w = (int)alignment[2];
        int h = (int)alignment[3];
        ++w;
        ++h;
        if (this.shadowEnabled) {
            w += this.getShadowAdditionalWidth();
            h += this.getShadowAdditionalHeight();
        }
        state.reallocScratchInt(w * h);
        int[] pixels = state.scratchInt;
        Image textBuffer = state.textBuffer;
        int imageSize = 0;
        if (textBuffer != null) {
            imageSize = textBuffer.getWidth(null);
        }
        if (w > imageSize || h > imageSize) {
            imageSize = Math.max(w, imageSize);
            imageSize = Math.max(h, imageSize);
            textBuffer = state.textBuffer = new BufferedImage(imageSize, imageSize, 2);
            this.width = w;
            this.height = h;
        }
        if (state.ch.isTransparentBackground()) {
            Graphics2D g2d = (Graphics2D)state.textBuffer.getGraphics();
            Composite saved = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(1, 0.0f));
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, imageSize, imageSize);
            g2d.fill(rect);
            g2d.setComposite(saved);
        }
        if (textBuffer == null) {
            return;
        }
        int left = (int)alignment[28];
        int top = (int)alignment[29];
        Graphics2D gt = (Graphics2D)textBuffer.getGraphics();
        this.setRenderingHints(state, gt);
        gt.setFont(this.font);
        int vLeft = 0;
        int vTop = 0;
        if (left < 0) {
            vLeft = -left;
        }
        if (top < 0) {
            vTop = -top;
        }
        state.ch.updateMemoryImage(left + vLeft, top + vTop, w, h);
        gt.drawImage(state.ch.backbuffer[state.ch.currentBuffer], 0 + vLeft, 0 + vTop, w, h, left + vLeft, top + vTop, left + w, top + h, null);
        Point4 screenSaver = state.pt1;
        screenSaver.set(this.screen);
        this.screen.x -= alignment[28];
        this.screen.y -= alignment[29];
        this.render(state, gt, textColor, alignment);
        this.screen.set(screenSaver);
        this.grabPixels(textBuffer, w, h, pixels);
        this.plantPixels(state, pixels, left, top, this.screen.z, w, h, this.alpha);
    }

    public void setAngle(int angle) {
        this.angle = (double)angle * Math.PI / 180.0;
    }

    public void setFont(Font font) {
        if (font != this.font) {
            this.font = font;
            this.fontAttributes = font.getAttributes();
            Object underlineValue = this.fontAttributes.get(TextAttribute.UNDERLINE);
            Object strikethroughValue = this.fontAttributes.get(TextAttribute.STRIKETHROUGH);
            this.fontNeedsTextLayout = underlineValue != null || strikethroughValue != null;
        }
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] r = state.ptArray;
        double[] info = this.computeAlignmentInfo(state, state.ch.getBackbufferGC(), (int)this.screen.x, (int)this.screen.y);
        double right = info[28];
        double top = info[29];
        double w = info[2];
        double h = info[3];
        r[0].set(right, top, this.screen.z, 1.0);
        r[1].set(right, top + h, this.screen.z, 1.0);
        r[2].set(right + w, top + h, this.screen.z, 1.0);
        r[3].set(right + w, top, this.screen.z, 1.0);
        return r;
    }

    @Override
    public boolean pick(State state, Graphics bgc, Rectangle aperture) {
        double[] info = this.computeAlignmentInfo(state, bgc, (int)this.screen.x, (int)this.screen.y);
        Rectangle bounds = state.rt1;
        bounds.setBounds((int)(info[28] + 0.5), (int)(info[29] + 0.5), (int)(info[2] + 0.5), (int)(info[3] + 0.5));
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        return aperture.intersects(clippedBounds);
    }

    void getBBox(String string, double x, double y, double z, int a, Bbox bb, State state, Graphics gc) {
        this.projectText(string, x, y, z, a, state, gc);
        TransInfo trans = state.ch.trans;
        trans.Window2Object(this.textProjection[0]);
        trans.Window2Object(this.textProjection[1]);
        trans.Window2Object(this.textProjection[2]);
        trans.Window2Object(this.textProjection[3]);
        bb.makeEmpty();
        bb.union(this.textProjection[0]);
        bb.union(this.textProjection[1]);
        bb.union(this.textProjection[2]);
        bb.union(this.textProjection[3]);
    }

    private void projectText(String string, double x, double y, double z, int a, State state, Graphics gc) {
        Point4 p1 = state.pt1;
        Point4 p2 = state.pt2;
        Point4 p3 = state.pt3;
        p1.set(x, y, z, 1.0);
        TransInfo trans = state.ch.trans;
        trans.Object2Window2(p1);
        this.makeMultiLine(string);
        double[] info = this.computeAlignmentInfo(state, gc, this.multiLineString, this.font, state.halign, state.valign, (double)a * Math.PI / 180.0, p1.x, p1.y);
        Point4 p4 = state.pt4;
        Point4 p5 = state.pt5;
        p2.set(info[28], info[29], p1.z, 1.0);
        p3.set(info[28] + info[2], info[29], p1.z, 1.0);
        p4.set(info[28] + info[2], info[29] + info[3], p1.z, 1.0);
        p5.set(info[28], info[29] + info[3], p1.z, 1.0);
        if (this.textProjection == null) {
            this.textProjection = new Point4[4];
        }
        this.textProjection[0] = p2;
        this.textProjection[1] = p3;
        this.textProjection[2] = p4;
        this.textProjection[3] = p5;
    }

    public void getTextProjection(String string, double x, double y, double z, int a, Rectangle r, State state, Graphics gc) {
        this.projectText(string, x, y, z, a, state, gc);
        r.setRect(this.textProjection[0].x, this.textProjection[0].y, 0.0, 0.0);
        r.add(this.textProjection[1].x, this.textProjection[1].y);
        r.add(this.textProjection[2].x, this.textProjection[2].y);
        r.add(this.textProjection[3].x, this.textProjection[3].y);
    }

    private static void getWorldPixelCorners(State state, Point4 ll, Point4 ur, int direction) {
        TransInfo trans = state.ch.trans;
        ll.set(0.0, 0.0, 0.0, 1.0);
        trans.Object2Window2(ll);
        if (direction == 0) {
            ur.set(ll.x + 1.0, ll.y, ll.z, 1.0);
        } else {
            ur.set(ll.x, ll.y - 1.0, ll.z, 1.0);
        }
        trans.Window2Object(ll);
        trans.Window2Object(ur);
    }

    static double getWorldPixelWidth(State state) {
        Point4 ll = state.pt1;
        Point4 ur = state.pt2;
        RasterText.getWorldPixelCorners(state, ll, ur, 0);
        ur.sub(ll);
        return ur.length();
    }

    static double getWorldPixelHeight(State state) {
        Point4 ll = state.pt1;
        Point4 ur = state.pt2;
        RasterText.getWorldPixelCorners(state, ll, ur, 1);
        ur.sub(ll);
        return ur.length();
    }

    double getWidth(State state, Graphics gc, Font f, String string) {
        double w = 0.0;
        FontRenderContext frc = RasterText.getFontRenderContext(state, (Graphics2D)gc);
        this.makeMultiLine(string);
        w = this.computeWidths(state, f, frc, gc);
        if (this.shadowEnabled) {
            w = this.angle == 0.0 ? (w += (double)this.shadowOffsetX) : (w += (double)this.shadowOffsetY);
        }
        return (float)(w * RasterText.getWorldPixelWidth(state));
    }

    double getAscent(State state, Graphics gc, Font f) {
        double pixel = RasterText.getWorldPixelHeight(state);
        FontMetrics fm = gc.getFontMetrics(f);
        double ascent = fm.getAscent();
        return ascent * pixel;
    }

    double getHeight(State state, Graphics gc, Font f) {
        return this.getHeight(state, gc, f, null);
    }

    double getHeight(State state, Graphics gc, Font f, String string) {
        double h = gc.getFontMetrics(f).getHeight();
        if (this.shadowEnabled) {
            h = this.angle == 0.0 ? (h += (double)this.shadowOffsetX) : (h += (double)this.shadowOffsetY);
        }
        double pixel = RasterText.getWorldPixelHeight(state);
        h *= pixel;
        if (string != null) {
            this.makeMultiLine(string);
            h *= (double)this.lineCount;
        }
        return (float)h;
    }

    private double computeWidths(State state, Font f, FontRenderContext frc, Graphics g) {
        double max = Double.MIN_VALUE;
        this.reallocTextWidth(state);
        if (this.singleLineString != null) {
            FontMetrics fm = g.getFontMetrics(f);
            this.textWidth[0] = max = fm.getStringBounds(this.singleLineString, g).getWidth();
        } else {
            double tmpWidth = 0.0;
            for (int i = 0; i < this.lineCount; ++i) {
                String s = (String)this.multiLineString.get(i);
                if (s.length() == 0) {
                    tmpWidth = 0.0;
                } else {
                    FontMetrics fm = g.getFontMetrics(f);
                    tmpWidth = fm.getStringBounds(s, g).getWidth();
                }
                if (this.textWidth != null) {
                    this.textWidth[i] = tmpWidth;
                }
                max = Math.max(max, tmpWidth);
            }
        }
        return max;
    }

    private void reallocTextWidth(State state) {
        this.textWidth = state.tempTextWidth;
        if (state.tempTextWidth == null || state.tempTextWidth.length < this.lineCount) {
            state.tempTextWidth = new double[this.lineCount];
            this.textWidth = state.tempTextWidth;
        }
    }

    @Override
    protected double[] computeAlignmentInfo(State state, Graphics gc, double x, double y) {
        FontRenderContext frc = RasterText.getFontRenderContext(state, (Graphics2D)gc);
        this.maxTextWidth = this.computeWidths(state, this.font, frc, gc);
        double[] alignInfo = this.getInfoBuffer(state);
        this.computeAlignmentInfo(state, gc, alignInfo, this.textWidth, this.maxTextWidth, frc, this.font, this.halign, this.valign, this.angle, x, y);
        return alignInfo;
    }

    private double[] computeAlignmentInfo(State state, Graphics gc, List string, Font f, int halign, int valign, double angle, double x, double y) {
        FontRenderContext frc = RasterText.getFontRenderContext(state, (Graphics2D)gc);
        double maxTextWidth = this.computeWidths(state, f, frc, gc);
        double[] info = this.getInfoBuffer(state);
        this.computeAlignmentInfo(state, gc, info, this.textWidth, maxTextWidth, frc, f, halign, valign, angle, x, y);
        return info;
    }

    private void computeAlignmentInfo(State state, Graphics gc, double[] info, double[] widths, double w, FontRenderContext frc, Font f, int halign, int valign, double angle, double x, double y) {
        double descent;
        double sox = 0.0;
        double soy = 0.0;
        if (this.shadowEnabled) {
            sox = this.shadowOffsetX + 2;
            soy = this.shadowOffsetY;
            w += sox;
        }
        info[0] = 0.0;
        info[1] = 0.0;
        FontMetrics fm = gc.getFontMetrics(f);
        info[6] = descent = (double)fm.getDescent() + soy;
        info[7] = fm.getLeading();
        double ascent = fm.getAscent();
        double lineHeight = (double)fm.getDescent() + soy + (double)((float)ascent) + (double)fm.getLeading();
        double h = lineHeight * (double)this.lineCount;
        if (!state.keepOriginalAlignments) {
            int vSave;
            if (angle == 1.5707963267948966) {
                vSave = valign;
                valign = hToV90[halign];
                halign = vToH90[vSave];
            } else if (angle == -1.5707963267948966 || angle == 4.71238898038469) {
                vSave = valign;
                valign = hToV270[halign];
                halign = vToH270[vSave];
            }
        }
        switch (valign) {
            case 0: {
                info[1] = ascent;
                break;
            }
            case 1: {
                info[1] = ascent - h / 2.0;
                break;
            }
            default: {
                info[1] = 0.0;
                break;
            }
            case 3: {
                info[1] = -descent - lineHeight * (double)(this.lineCount - 1);
            }
        }
        switch (halign) {
            default: {
                info[0] = 0.0;
                break;
            }
            case 1: {
                info[0] = -((w + sox) / 2.0);
                info[0] = -(w / 2.0);
                break;
            }
            case 2: {
                info[0] = -w;
            }
        }
        info[8] = 0.0;
        info[9] = -ascent;
        info[10] = w;
        info[11] = -ascent;
        info[12] = w;
        info[13] = -ascent + h;
        info[14] = 0.0;
        info[15] = -ascent + h;
        AffineTransform xform = (AffineTransform)state.affineTransform;
        xform.setToIdentity();
        xform.translate(x, y);
        xform.rotate(-angle);
        xform.translate(info[0], info[1]);
        xform.transform(info, 8, info, 18, 4);
        double maxx = Math.max(Math.max(info[18], info[20]), Math.max(info[22], info[24]));
        double maxy = Math.max(Math.max(info[19], info[21]), Math.max(info[23], info[25]));
        double minx = Math.min(Math.min(info[18], info[20]), Math.min(info[22], info[24]));
        double miny = Math.min(Math.min(info[19], info[21]), Math.min(info[23], info[25]));
        double width = maxx - minx;
        double height = maxy - miny;
        info[2] = width;
        info[3] = height;
        info[28] = minx;
        info[29] = miny;
        info[30] = w;
        info[31] = h;
        block13: for (int i = 0; i < this.lineCount; ++i) {
            switch (halign) {
                default: {
                    info[32 + i] = 0.0;
                    continue block13;
                }
                case 1: {
                    info[32 + i] = (int)((w - widths[i]) / 2.0);
                    continue block13;
                }
                case 2: {
                    info[32 + i] = (int)(w - widths[i]);
                }
            }
        }
        info[5] = (int)lineHeight;
    }
}

