/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;

abstract class RasterShape
extends Shape {
    private static final Point4 negativeZ = new Point4(0.0, 0.0, 1.0, 1.0);
    protected Image image;
    protected Point4 loc = new Point4();
    protected Point4 screen = new Point4();
    protected int halign;
    protected int valign;
    protected int width;
    protected int height;
    protected Color backgroundColor = null;
    protected Color backgroundEdgeColor = null;
    protected Insets backgroundPad = null;

    RasterShape() {
        this.normal = negativeZ;
    }

    @Override
    void copyInit(Shape s) {
        super.copyInit(s);
        RasterShape rs = (RasterShape)s;
        if (this.loc != null) {
            rs.loc = this.loc.copy();
        }
        if (this.screen != null) {
            rs.screen = this.screen.copy();
        }
    }

    protected void init(double x, double y, double z) {
        this.dscr = new Point4[1];
        this.dscr[0] = this.screen;
        this.loc.set(x, y, z, 1.0);
        this.clip = false;
    }

    public void setHorizontalAlignment(int align) {
        this.halign = align;
    }

    public void setVerticalAlignment(int align) {
        this.valign = align;
    }

    public void setPosition(double x, double y, double z) {
        this.loc.set(x, y, z, 1.0);
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBackgroundEdgeColor(Color color) {
        this.backgroundEdgeColor = color;
    }

    public void setBackgroundPad(Insets pad) {
        this.backgroundPad = pad;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.screen.set(this.loc);
        ch.trans.Object2Window(this.screen);
        this.zmin = this.zmax = this.screen.z;
        this.bbox.setBounds((int)this.screen.x, (int)this.screen.y, 1, 1);
        this.clip = this.zmin < 0.0 || this.zmax > 1.0;
    }

    @Override
    public int getVertexCount(State state) {
        return 4;
    }

    @Override
    public Point4 getScreenCenter() {
        return this.screen;
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] r = state.ptArray;
        double[] info = this.computeAlignmentInfo(state, state.ch.getBackbufferGC(), (int)this.screen.x, (int)this.screen.y);
        double right = info[0];
        double top = info[4];
        double w = info[2];
        double h = info[3];
        r[0].set(right, top, this.screen.z, 1.0);
        r[1].set(right, top + h, this.screen.z, 1.0);
        r[2].set(right + w, top + h, this.screen.z, 1.0);
        r[3].set(right + w, top, this.screen.z, 1.0);
        return r;
    }

    @Override
    public boolean pick(State state, Graphics bgc, Rectangle aperture) {
        double[] info = this.computeAlignmentInfo(state, bgc, (int)this.screen.x, (int)this.screen.y);
        Rectangle bounds = state.rt1;
        bounds.setBounds((int)info[0], (int)info[4], (int)info[2], (int)info[3]);
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        return aperture.intersects(clippedBounds);
    }

    @Override
    public double getZmin() {
        return this.screen.z;
    }

    @Override
    public double getZmax() {
        return this.screen.z;
    }

    protected double[] computeAlignmentInfo(State state, Graphics gc, double x, double y) {
        double[] info = new double[5];
        double xo = 0.0;
        double yo = 0.0;
        switch (this.halign) {
            default: {
                break;
            }
            case 1: {
                xo -= (double)(this.width / 2);
                break;
            }
            case 2: {
                xo -= (double)this.width;
            }
        }
        switch (this.valign) {
            case 0: {
                break;
            }
            case 1: {
                yo -= (double)(this.height / 2);
                break;
            }
            case 3: {
                yo -= (double)this.height;
                break;
            }
        }
        info[2] = this.width;
        info[3] = this.height;
        info[4] = y + yo;
        info[0] = x + xo;
        info[1] = y + yo;
        return info;
    }
}

