/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.Markers;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.SoftGraphics;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.VertexSet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;

class PolyMarker
extends VertexSet
implements Cloneable {
    private Color edgeColor;
    private int markerType;
    private int size = 8;

    PolyMarker() {
    }

    @Override
    protected void copyInit(Shape s) {
        super.copyInit(s);
        PolyMarker m = (PolyMarker)s;
        m.allocScreen();
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (state.isSoftwareRender()) {
            bgc = state.softGraphics;
        }
        if (state.fillmode != 5) {
            boolean subpixel;
            boolean bl = subpixel = state.subpixelRendering && !(bgc instanceof SoftGraphics);
            if (subpixel) {
                ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
            for (int i = 0; i < this.vertexCount; ++i) {
                Color c = this.color;
                if (state.capabilities[0]) {
                    c = this.colorPerVertex[i];
                }
                state.softGraphics.setZ(this.dscr[i].z);
                if (this.markerType < 189) {
                    if (subpixel) {
                        Markers.draw((Graphics)bgc, (Color)c, (Color)this.edgeColor, (int)this.markerType, (double)this.size, (double)this.xpointsD[i], (double)this.ypointsD[i], (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                        continue;
                    }
                    Markers.draw((Graphics)bgc, (Color)c, (Color)this.edgeColor, (int)this.markerType, (int)this.size, (int)this.xpoints[i], (int)this.ypoints[i], (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                    continue;
                }
                if (Markers.isUserDefinedMarker((int)this.markerType)) {
                    UserDefinedMarkerInterface udm = Markers.getUserDefinedMarker((int)this.markerType);
                    if (subpixel) {
                        double x = this.xpointsD[i] + udm.getMarkerOffsetX() * (double)state.markerSize;
                        double y = this.ypointsD[i] + udm.getMarkerOffsetY() * (double)state.markerSize;
                        Markers.draw((Graphics)bgc, (Color)c, (Color)this.edgeColor, (int)this.markerType, (double)this.size, (double)x, (double)y, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                        continue;
                    }
                    int x = this.xpoints[i] + (int)(udm.getMarkerOffsetX() * (double)state.markerSize + 0.5);
                    int y = this.ypoints[i] + (int)(udm.getMarkerOffsetY() * (double)state.markerSize + 0.5);
                    Markers.draw((Graphics)bgc, (Color)c, (Color)this.edgeColor, (int)this.markerType, (int)this.size, (int)x, (int)y, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                    continue;
                }
                CustomMarkerInterface marker = (CustomMarkerInterface)state.customMarkers.elementAt(this.markerType - 189 - 1);
                bgc.setColor(c);
                marker.paint(bgc, c, this.edgeColor, this.xpoints[i] - (this.size - 1) / 2, this.ypoints[i] - (this.size - 1) / 2, this.size, this.size);
            }
            if (subpixel) {
                ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            }
        }
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        return aperture.intersects(this.bbox);
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.size = ch.state.markerSize;
        this.edgeColor = ch.state.edgecolor;
        this.markerType = ch.state.markerType;
        if (this.size > 1) {
            this.bbox.setBounds(this.bbox.x - this.size / 2, this.bbox.y - this.size / 2, this.bbox.width + this.size, this.bbox.height + this.size);
        }
    }

    @Override
    public Point4 getScreenCenter() {
        return this.dscr[0];
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] t = state.ptArray;
        t[0].x = this.bbox.x;
        t[0].y = this.bbox.y;
        t[0].z = 0.0;
        t[1].x = this.bbox.x + this.bbox.width;
        t[1].y = this.bbox.y;
        t[1].z = 0.0;
        t[2].x = this.bbox.x + this.bbox.width;
        t[2].y = this.bbox.y + this.bbox.height;
        t[2].z = 0.0;
        t[3].x = this.bbox.x;
        t[3].y = this.bbox.y + this.bbox.height;
        t[3].z = 0.0;
        return t;
    }

    @Override
    public int getVertexCount(State state) {
        return 4;
    }
}

