/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import java.util.Hashtable;

class NameTree {
    private NameTree parent = null;
    private Hashtable children = null;
    private Object name = null;
    private static final NameTree nullKey = new NameTree(null, null);

    public NameTree(NameTree parent, Object name) {
        this.parent = parent;
        this.name = name;
    }

    public NameTree getParent() {
        return this.parent;
    }

    public Object getName() {
        Object result = null;
        if (this.name != nullKey) {
            result = this.name;
        }
        return result;
    }

    public NameTree addChild(Object child) {
        NameTree nt;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if (child == null) {
            child = nullKey;
        }
        if ((nt = (NameTree)this.children.get(child)) == null) {
            nt = new NameTree(this, child);
            this.children.put(child, nt);
        }
        return nt;
    }

    public void removeChild(NameTree child) {
        this.children.remove(child.name);
    }

    public NameTree getChild(Object n) {
        NameTree nt;
        if (this.children == null) {
            return null;
        }
        if (n == null) {
            n = nullKey;
        }
        if ((nt = (NameTree)this.children.get(n)) == nullKey) {
            return null;
        }
        return nt;
    }
}

