/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gl.Matrix3;
import com.sas.graphics.util.gl.Point4;

final class Matrix4 {
    protected double[][] e;
    static final double DEG2RAD = 0.01745329252;
    private double[] temp = new double[4];
    private static final double[] e0 = new double[]{1.0, 0.0, 0.0, 0.0};
    private static final double[] e1 = new double[]{0.0, 1.0, 0.0, 0.0};
    private static final double[] e2 = new double[]{0.0, 0.0, 1.0, 0.0};
    private static final double[] e3 = new double[]{0.0, 0.0, 0.0, 1.0};
    private Matrix3 m3t1 = null;
    private Matrix3 m3t2 = null;
    private Matrix3 m3t3;
    private Matrix4 m4t1 = null;
    private Point4 pt1 = null;

    public Matrix4() {
        this(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
    }

    public Matrix4(double x1, double y1, double z1, double t1, double x2, double y2, double z2, double t2, double x3, double y3, double z3, double t3, double x4, double y4, double z4, double t4) {
        this.e = new double[4][];
        this.e[0] = new double[4];
        this.e[1] = new double[4];
        this.e[2] = new double[4];
        this.e[3] = new double[4];
        this.e[0][0] = x1;
        this.e[0][1] = x2;
        this.e[0][2] = x3;
        this.e[0][3] = x4;
        this.e[1][0] = y1;
        this.e[1][1] = y2;
        this.e[1][2] = y3;
        this.e[1][3] = y4;
        this.e[2][0] = z1;
        this.e[2][1] = z2;
        this.e[2][2] = z3;
        this.e[2][3] = z4;
        this.e[3][0] = t1;
        this.e[3][1] = t2;
        this.e[3][2] = t3;
        this.e[3][3] = t4;
    }

    public void inverse(Matrix4 m) {
        m.setIdentity();
        this.adjoint(m);
        double det = this.det();
        m.scale(1.0 / det);
    }

    void preMultiply(Matrix4 mi) {
        for (int i = 0; i < 4; ++i) {
            this.temp[0] = this.e[0][i];
            this.temp[1] = this.e[1][i];
            this.temp[2] = this.e[2][i];
            this.temp[3] = this.e[3][i];
            for (int j = 0; j < 4; ++j) {
                this.e[j][i] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = this.e[j];
                    int n = i;
                    dArray[n] = dArray[n] + mi.e[j][k] * this.temp[k];
                }
            }
        }
    }

    void preMultiply(Point4 p) {
        double x = p.x;
        double y = p.y;
        double z = p.z;
        double t = p.t;
        p.x = x * this.e[0][0] + y * this.e[1][0] + z * this.e[2][0] + t * this.e[3][0];
        p.y = x * this.e[0][1] + y * this.e[1][1] + z * this.e[2][1] + t * this.e[3][1];
        p.z = x * this.e[0][2] + y * this.e[1][2] + z * this.e[2][2] + t * this.e[3][2];
        p.t = x * this.e[0][3] + y * this.e[1][3] + z * this.e[2][3] + t * this.e[3][3];
    }

    public void rotate(double dirx, double diry, double dirz, double angle) {
        double length = dirx * dirx + diry * diry + dirz * dirz;
        if (length < (double)1.4E-45f) {
            return;
        }
        if (this.m3t1 == null) {
            this.m3t1 = new Matrix3();
            this.m3t2 = new Matrix3();
            this.m3t3 = new Matrix3();
            this.m4t1 = new Matrix4();
            this.pt1 = new Point4();
        }
        Point4 u = this.pt1;
        u.x = dirx;
        u.y = diry;
        u.z = dirz;
        u.t = 0.0;
        u.normalize();
        Matrix3 uu = this.m3t1;
        uu.e[0][0] = u.x * u.x;
        uu.e[0][1] = u.x * u.y;
        uu.e[0][2] = u.x * u.z;
        uu.e[1][0] = u.y * u.x;
        uu.e[1][1] = u.y * u.y;
        uu.e[1][2] = u.y * u.z;
        uu.e[2][0] = u.z * u.x;
        uu.e[2][1] = u.z * u.y;
        uu.e[2][2] = u.z * u.z;
        Matrix3 m = this.m3t2;
        m.setIdentity();
        m.sub(uu);
        double a = angle * 0.01745329252;
        m.scale(Math.cos(a));
        double sina = Math.sin(a);
        Matrix3 s = this.m3t3;
        s.e[0][0] = 0.0;
        s.e[0][1] = u.z;
        s.e[0][2] = -u.y;
        s.e[1][0] = -u.z;
        s.e[1][1] = 0.0;
        s.e[1][2] = u.x;
        s.e[2][0] = u.y;
        s.e[2][1] = -u.x;
        s.e[2][2] = 0.0;
        s.scale(sina);
        m.add(uu).add(s);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m4t1.e[i][j] = m.e[i][j];
            }
        }
        this.preMultiply(this.m4t1);
    }

    public void scale(double s) {
        for (int i = 0; i < 4; ++i) {
            int j = 0;
            while (j < 4) {
                double[] dArray = this.e[i];
                int n = j++;
                dArray[n] = dArray[n] * s;
            }
        }
    }

    public void scale(double sx, double sy, double sz) {
        int i = 0;
        while (i < 3) {
            double[] dArray = this.e[0];
            int n = i;
            dArray[n] = dArray[n] * sx;
            double[] dArray2 = this.e[1];
            int n2 = i;
            dArray2[n2] = dArray2[n2] * sy;
            double[] dArray3 = this.e[2];
            int n3 = i++;
            dArray3[n3] = dArray3[n3] * sz;
        }
    }

    public void set(Matrix4 m) {
        System.arraycopy(m.e[0], 0, this.e[0], 0, this.e[0].length);
        System.arraycopy(m.e[1], 0, this.e[1], 0, this.e[1].length);
        System.arraycopy(m.e[2], 0, this.e[2], 0, this.e[2].length);
        System.arraycopy(m.e[3], 0, this.e[3], 0, this.e[3].length);
    }

    public void set(double x1, double y1, double z1, double t1, double x2, double y2, double z2, double t2, double x3, double y3, double z3, double t3, double x4, double y4, double z4, double t4) {
        this.e[0][0] = x1;
        this.e[0][1] = x2;
        this.e[0][2] = x3;
        this.e[0][3] = x4;
        this.e[1][0] = y1;
        this.e[1][1] = y2;
        this.e[1][2] = y3;
        this.e[1][3] = y4;
        this.e[2][0] = z1;
        this.e[2][1] = z2;
        this.e[2][2] = z3;
        this.e[2][3] = z4;
        this.e[3][0] = t1;
        this.e[3][1] = t2;
        this.e[3][2] = t3;
        this.e[3][3] = t4;
    }

    public void set(double[] m) {
        if (m.length != 16) {
            return;
        }
        System.arraycopy(m, 0, this.e[0], 0, this.e[0].length);
        System.arraycopy(m, 4, this.e[1], 0, this.e[1].length);
        System.arraycopy(m, 8, this.e[2], 0, this.e[2].length);
        System.arraycopy(m, 12, this.e[3], 0, this.e[3].length);
    }

    public void set(int i, int j, double s) {
        try {
            this.e[i][j] = s;
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            Debug.println((String)"Invalid array index");
            System.exit(0);
        }
    }

    public void setIdentity() {
        System.arraycopy(e0, 0, this.e[0], 0, e0.length);
        System.arraycopy(e1, 0, this.e[1], 0, e1.length);
        System.arraycopy(e2, 0, this.e[2], 0, e2.length);
        System.arraycopy(e3, 0, this.e[3], 0, e3.length);
    }

    public void translate(double x, double y, double z) {
        double[] dArray = this.e[3];
        dArray[0] = dArray[0] + (this.e[0][0] * x + this.e[1][0] * y + this.e[2][0] * z);
        double[] dArray2 = this.e[3];
        dArray2[1] = dArray2[1] + (this.e[0][1] * x + this.e[1][1] * y + this.e[2][1] * z);
        double[] dArray3 = this.e[3];
        dArray3[2] = dArray3[2] + (this.e[0][2] * x + this.e[1][2] * y + this.e[2][2] * z);
        double[] dArray4 = this.e[3];
        dArray4[3] = dArray4[3] + (this.e[0][3] * x + this.e[1][3] * y + this.e[2][3] * z);
    }

    private void adjoint(Matrix4 m) {
        this.cofactors(m);
        this.transpose(m);
    }

    private void cofactors(Matrix4 m) {
        m.e[0][0] = this.e[1][1] * (this.e[2][2] * this.e[3][3] - this.e[2][3] * this.e[3][2]) - this.e[1][2] * (this.e[2][1] * this.e[3][3] - this.e[2][3] * this.e[3][1]) + this.e[1][3] * (this.e[2][1] * this.e[3][2] - this.e[2][2] * this.e[3][1]);
        m.e[0][1] = -this.e[1][0] * (this.e[2][2] * this.e[3][3] - this.e[2][3] * this.e[3][2]) + this.e[1][2] * (this.e[2][0] * this.e[3][3] - this.e[2][3] * this.e[3][0]) - this.e[1][3] * (this.e[2][0] * this.e[3][2] - this.e[2][2] * this.e[3][0]);
        m.e[0][2] = this.e[1][0] * (this.e[2][1] * this.e[3][3] - this.e[2][3] * this.e[3][1]) - this.e[1][1] * (this.e[2][0] * this.e[3][3] - this.e[2][3] * this.e[3][0]) + this.e[1][3] * (this.e[2][0] * this.e[3][1] - this.e[2][1] * this.e[3][0]);
        m.e[0][3] = -this.e[1][0] * (this.e[2][1] * this.e[3][2] - this.e[2][2] * this.e[3][1]) + this.e[1][1] * (this.e[2][0] * this.e[3][2] - this.e[2][2] * this.e[3][0]) - this.e[1][2] * (this.e[2][0] * this.e[3][1] - this.e[2][1] * this.e[3][0]);
        m.e[1][0] = -this.e[0][1] * (this.e[2][2] * this.e[3][3] - this.e[2][3] * this.e[3][2]) + this.e[0][2] * (this.e[2][1] * this.e[3][3] - this.e[2][3] * this.e[3][1]) - this.e[0][3] * (this.e[2][1] * this.e[3][2] - this.e[2][2] * this.e[3][1]);
        m.e[1][1] = this.e[0][0] * (this.e[2][2] * this.e[3][3] - this.e[2][3] * this.e[3][2]) - this.e[0][2] * (this.e[2][0] * this.e[3][3] - this.e[2][3] * this.e[3][0]) + this.e[0][3] * (this.e[2][0] * this.e[3][2] - this.e[2][2] * this.e[3][0]);
        m.e[1][2] = -this.e[0][0] * (this.e[2][1] * this.e[3][3] - this.e[2][3] * this.e[3][1]) + this.e[0][1] * (this.e[2][0] * this.e[3][3] - this.e[2][3] * this.e[3][0]) - this.e[0][3] * (this.e[2][0] * this.e[3][1] - this.e[2][1] * this.e[3][0]);
        m.e[1][3] = this.e[0][0] * (this.e[2][1] * this.e[3][2] - this.e[2][2] * this.e[3][1]) - this.e[0][1] * (this.e[2][0] * this.e[3][2] - this.e[2][2] * this.e[3][0]) + this.e[0][2] * (this.e[2][0] * this.e[3][1] - this.e[2][1] * this.e[3][0]);
        m.e[2][0] = this.e[0][1] * (this.e[1][2] * this.e[3][3] - this.e[1][3] * this.e[3][2]) - this.e[0][2] * (this.e[1][1] * this.e[3][3] - this.e[1][3] * this.e[3][1]) + this.e[0][3] * (this.e[1][1] * this.e[3][2] - this.e[1][2] * this.e[3][1]);
        m.e[2][1] = -this.e[0][0] * (this.e[1][2] * this.e[3][3] - this.e[1][3] * this.e[3][2]) + this.e[0][2] * (this.e[1][0] * this.e[3][3] - this.e[1][3] * this.e[3][0]) - this.e[0][3] * (this.e[1][0] * this.e[3][2] - this.e[1][2] * this.e[3][0]);
        m.e[2][2] = this.e[0][0] * (this.e[1][1] * this.e[3][3] - this.e[1][3] * this.e[3][1]) - this.e[0][1] * (this.e[1][0] * this.e[3][3] - this.e[1][3] * this.e[3][0]) + this.e[0][3] * (this.e[1][0] * this.e[3][1] - this.e[1][1] * this.e[3][0]);
        m.e[2][3] = -this.e[0][0] * (this.e[1][1] * this.e[3][2] - this.e[1][2] * this.e[3][1]) + this.e[0][1] * (this.e[1][0] * this.e[3][2] - this.e[1][2] * this.e[3][0]) - this.e[0][2] * (this.e[1][0] * this.e[3][1] - this.e[1][1] * this.e[3][0]);
        m.e[3][0] = -this.e[0][1] * (this.e[1][2] * this.e[2][3] - this.e[1][3] * this.e[2][2]) + this.e[0][2] * (this.e[1][1] * this.e[2][3] - this.e[1][3] * this.e[2][1]) - this.e[0][3] * (this.e[1][1] * this.e[2][2] - this.e[1][2] * this.e[2][1]);
        m.e[3][1] = this.e[0][0] * (this.e[1][2] * this.e[2][3] - this.e[1][3] * this.e[2][2]) - this.e[0][2] * (this.e[1][0] * this.e[2][3] - this.e[1][3] * this.e[2][0]) + this.e[0][3] * (this.e[1][0] * this.e[2][2] - this.e[1][2] * this.e[2][0]);
        m.e[3][2] = -this.e[0][0] * (this.e[1][1] * this.e[2][3] - this.e[1][3] * this.e[2][1]) + this.e[0][1] * (this.e[1][0] * this.e[2][3] - this.e[1][3] * this.e[2][0]) - this.e[0][3] * (this.e[1][0] * this.e[2][1] - this.e[1][1] * this.e[2][0]);
        m.e[3][3] = this.e[0][0] * (this.e[1][1] * this.e[2][2] - this.e[1][2] * this.e[2][1]) - this.e[0][1] * (this.e[1][0] * this.e[2][2] - this.e[1][2] * this.e[2][0]) + this.e[0][2] * (this.e[1][0] * this.e[2][1] - this.e[1][1] * this.e[2][0]);
    }

    private void transpose(Matrix4 m) {
        for (int i = 0; i < 4; ++i) {
            for (int j = i; j < 4; ++j) {
                double t = m.e[i][j];
                m.e[i][j] = m.e[j][i];
                m.e[j][i] = t;
            }
        }
    }

    private double det() {
        double d0 = this.e[1][1] * (this.e[2][2] * this.e[3][3] - this.e[2][3] * this.e[3][2]) - this.e[1][2] * (this.e[2][1] * this.e[3][3] - this.e[2][3] * this.e[3][1]) + this.e[1][3] * (this.e[2][1] * this.e[3][2] - this.e[2][2] * this.e[3][1]);
        double d1 = -this.e[1][0] * (this.e[2][2] * this.e[3][3] - this.e[2][3] * this.e[3][2]) + this.e[1][2] * (this.e[2][0] * this.e[3][3] - this.e[2][3] * this.e[3][0]) - this.e[1][3] * (this.e[2][0] * this.e[3][2] - this.e[2][2] * this.e[3][0]);
        double d2 = this.e[1][0] * (this.e[2][1] * this.e[3][3] - this.e[2][3] * this.e[3][1]) - this.e[1][1] * (this.e[2][0] * this.e[3][3] - this.e[2][3] * this.e[3][0]) + this.e[1][3] * (this.e[2][0] * this.e[3][1] - this.e[2][1] * this.e[3][0]);
        double d3 = -this.e[1][0] * (this.e[2][1] * this.e[3][2] - this.e[2][2] * this.e[3][1]) + this.e[1][1] * (this.e[2][0] * this.e[3][2] - this.e[2][2] * this.e[3][0]) - this.e[1][2] * (this.e[2][0] * this.e[3][1] - this.e[2][1] * this.e[3][0]);
        return this.e[0][0] * d0 + this.e[0][1] * d1 + this.e[0][2] * d2 + this.e[0][3] * d3;
    }
}

