/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Light;
import com.sas.graphics.util.gl.LightParameter;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.State;
import java.awt.Color;

final class LightManager {
    private static int numberOfLights = 8;
    protected transient Light[] lights;
    protected transient State state;
    Point4 N = new Point4();
    private Point4 clr = new Point4();
    private Point4 V = new Point4();
    private Point4 R = new Point4();

    public LightManager(State s) {
        this.lights = new Light[numberOfLights];
        for (int i = 0; i < numberOfLights; ++i) {
            this.lights[i] = new Light();
        }
        this.lights[0].diffuse.set(1.0, 1.0, 1.0, 1.0);
        this.lights[0].specular.set(1.0, 1.0, 1.0, 1.0);
        this.state = s;
    }

    public void setLightParam(int lightID, int paramName, Point4 param) {
        if (lightID < 19 || lightID > 26) {
            return;
        }
        if (this.state.isDisplayListOpen()) {
            this.state.getOpenDisplayList().addElement(new LightParameter(this.lights[lightID - 19], paramName, param));
        } else {
            this.lights[lightID - 19].setParam(paramName, param);
            this.lights[lightID - 19].applyTransformations(this.state.ch.trans, paramName);
        }
    }

    public void setLightParam(int lightID, int paramName, double param) {
        if (lightID < 19 || lightID > 26) {
            return;
        }
        if (this.state.isDisplayListOpen()) {
            this.state.getOpenDisplayList().addElement(new LightParameter(this.lights[lightID - 19], paramName, param));
        } else {
            this.lights[lightID - 19].setParam(paramName, param);
        }
    }

    public void setEnabled(int lightID, boolean b) {
        if (lightID < 19 || lightID > 26) {
            return;
        }
        this.lights[lightID - 19].setEnabled(b);
    }

    public boolean isEnabled(int lightID) {
        if (lightID < 19 || lightID > 26) {
            return false;
        }
        return this.lights[lightID - 19].isEnabled();
    }

    public Color computeColor(Point4 vertex, Point4 normal, Point4 viewpoint, Color color) {
        Point4 result = this.state.pt3;
        Point4 tmp = this.state.pt4;
        Point4 L = this.state.pt5;
        double attenuation = 1.0;
        result.set(0.0, 0.0, 0.0, 0.0);
        tmp.set(0.0, 0.0, 0.0, 0.0);
        L.set(0.0, 0.0, 0.0, 0.0);
        this.N.set(normal);
        for (int i = 0; i < numberOfLights; ++i) {
            Light light = this.lights[i];
            if (!light.isEnabled()) continue;
            L.set(light.position);
            if (light.position.t != 0.0) {
                L.sub(vertex);
            }
            attenuation = this.attenuation(light, L);
            tmp.add(light.ambient);
            L.normalize();
            this.diffuseContribution(light, this.N, L, tmp);
            this.specularContribution(light, this.N, L, vertex, viewpoint, tmp);
            tmp.scale(attenuation);
            L.set(vertex);
            L.sub(light.position);
            L.normalize();
            tmp.scale(this.spotlight(light, L));
            result.add(tmp);
            tmp.set(0.0, 0.0, 0.0, 0.0);
        }
        this.clamp(0.0, 1.0, result);
        result.x = (double)color.getRed() / 255.0 * result.x;
        result.y = (double)color.getGreen() / 255.0 * result.y;
        result.z = (double)color.getBlue() / 255.0 * result.z;
        return new Color((float)result.x, (float)result.y, (float)result.z, (float)color.getAlpha() / 255.0f);
    }

    private void diffuseContribution(Light light, Point4 N, Point4 L, Point4 result) {
        this.clr.set(light.diffuse);
        this.clr.scale(Math.max(L.dot(N), 0.0));
        result.add(this.clr);
    }

    private void specularContribution(Light light, Point4 N, Point4 L, Point4 vertex, Point4 viewpoint, Point4 result) {
        this.R.set(N);
        this.R.scale(2.0 * L.dot(N));
        this.R.sub(L);
        this.V.set(viewpoint);
        this.V.sub(vertex);
        this.V.normalize();
        this.clr.set(light.specular);
        this.clr.scale(Math.max(this.R.dot(this.V), 0.0));
        result.add(this.clr);
    }

    private double attenuation(Light light, Point4 L) {
        double result = 1.0;
        if (light.position.t != 0.0) {
            double distance = L.length();
            result = 1.0 / (light.constantAttenuation + light.linearAttenuation * distance + light.quadraticAttenuation * distance * distance);
            result = Math.max(result, 1.0);
        }
        return result;
    }

    private double spotlight(Light light, Point4 L) {
        if (light.spotCutoff < 0.0 || light.spotCutoff > 90.0 || light.position.t == 0.0) {
            return 1.0;
        }
        this.R.set(light.spotDirection);
        this.R.normalize();
        double dot = L.dot(this.R);
        if (Math.max(dot, 0.0) < Math.cos(light.spotCutoff / 180.0 * Math.PI)) {
            return 0.0;
        }
        return Math.pow(Math.max(dot, 0.0), light.spotExponent);
    }

    private void clamp(double min, double max, Point4 p) {
        if (p.x > max) {
            p.x = max;
        } else if (p.x < min) {
            p.x = min;
        }
        if (p.y > max) {
            p.y = max;
        } else if (p.y < min) {
            p.y = min;
        }
        if (p.z > max) {
            p.z = max;
        } else if (p.z < min) {
            p.z = min;
        }
        p.t = 0.0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(400);
        for (int i = 0; i < numberOfLights; ++i) {
            buf.append(this.lights[i].toString());
            buf.append('\n');
        }
        return buf.toString();
    }
}

