/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.State;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

class J3Wedge
extends Shape {
    protected Point4 world = new Point4();
    protected double innerRadius;
    protected double outerRadius;
    protected double startAngle;
    protected double extentAngle;
    protected Point4 t1 = new Point4();
    protected Point4 t2 = new Point4();
    protected Point4 screenOuterUL = new Point4();
    protected Point4 screenOuterSize = new Point4();
    protected Point4 screenInnerUL = new Point4();
    protected Point4 screenInnerSize = new Point4();
    protected Point4 screenCenter = new Point4();
    protected int fillmode;
    protected Color edgeColor;
    private Arc2D outerArc = new Arc2D.Double();
    private Arc2D innerArc = null;
    private GeneralPath generalPath = null;
    private static final BasicStroke lineWidthOne = new BasicStroke(1.0f, 2, 2, 1.0f);
    private static final BasicStroke lineWidthTwo = new BasicStroke(2.0f, 2, 2, 1.0f);
    private static final BasicStroke lineWidthThree = new BasicStroke(3.0f, 2, 2, 1.0f);
    protected Image texImage;
    private int texEnvMode;
    private java.awt.Shape lastWedge = null;
    private int[] stipplePattern;

    @Override
    public Point4 getScreenCenter() {
        return this.screenCenter;
    }

    public java.awt.Shape getLastWedgeRendered() {
        return this.lastWedge;
    }

    private PathIterator getPathIterator(java.awt.Shape wedge) {
        double flatness = Math.max(2.0, this.screenOuterSize.x / 100.0);
        return wedge.getPathIterator(null, flatness);
    }

    @Override
    public int getVertexCount(State state) {
        java.awt.Shape wedge = this.computeWedge();
        int vertexCount = 0;
        PathIterator pi = this.getPathIterator(wedge);
        while (!pi.isDone()) {
            ++vertexCount;
            pi.next();
        }
        return vertexCount;
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        java.awt.Shape wedge = this.computeWedge();
        double[] coord = new double[6];
        Point4[] coords = new Point4[this.getVertexCount(state)];
        PathIterator pi = this.getPathIterator(wedge);
        int i = 0;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coord);
            coords[i] = new Point4();
            switch (type) {
                default: {
                    System.out.println("Unhandled PathIterator type.");
                    break;
                }
                case 0: 
                case 1: {
                    coords[i].x = coord[0];
                    coords[i].y = coord[1];
                    ++i;
                    break;
                }
                case 4: {
                    coords[i].x = coords[0].x;
                    coords[i].y = coords[0].y;
                    ++i;
                }
            }
            pi.next();
        }
        return coords;
    }

    @Override
    public final void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (!state.isSoftwareRender()) {
            this.awtRender(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private java.awt.Shape computeWedge() {
        int type = this.extentAngle < 360.0 ? 2 : 0;
        this.outerArc.setArc(this.screenOuterUL.x, this.screenOuterUL.y, this.screenOuterSize.x, this.screenOuterSize.y, this.startAngle, this.extentAngle, type);
        java.awt.Shape result = this.outerArc;
        if (this.innerRadius <= 0.0) {
            result = (java.awt.Shape)this.outerArc.clone();
        } else {
            this.outerArc.setArcType(0);
            if (this.innerArc == null) {
                this.innerArc = new Arc2D.Double();
            }
            this.innerArc.setArc(this.screenInnerUL.x, this.screenInnerUL.y, this.screenInnerSize.x, this.screenInnerSize.y, this.startAngle + this.extentAngle, -this.extentAngle, 0);
            if (this.generalPath == null) {
                this.generalPath = new GeneralPath();
            }
            this.generalPath = new GeneralPath();
            this.generalPath.reset();
            this.generalPath.append(this.outerArc, false);
            boolean close = this.extentAngle < 360.0;
            this.generalPath.append(this.innerArc, close);
            this.generalPath.closePath();
            result = (java.awt.Shape)this.generalPath.clone();
        }
        return result;
    }

    protected void awtRender(State state, Graphics bgc) {
        Graphics2D g2 = (Graphics2D)bgc;
        this.lastWedge = this.computeWedge();
        switch (this.fillmode) {
            default: {
                this.drawFill(state, this.lastWedge, g2, this.color);
                break;
            }
            case 6: 
            case 7: {
                Paint save = g2.getPaint();
                g2.setPaint(state.fillPattern.getHatch45(this.color));
                g2.fill(this.lastWedge);
                g2.setPaint(save);
                if (this.fillmode != 6) break;
                this.drawOutline(state, this.lastWedge, g2, this.color);
                break;
            }
            case 2: {
                this.drawOutline(state, this.lastWedge, g2, this.color);
                break;
            }
            case 4: {
                this.drawFill(state, this.lastWedge, g2, this.color);
                this.drawOutline(state, this.lastWedge, g2, this.edgeColor);
            }
            case 5: 
        }
    }

    private void drawFill(State state, java.awt.Shape wedge, Graphics2D g, Color color) {
        if (!this.isDecalTexture()) {
            g.setColor(color);
            g.fill(wedge);
        }
        if (this.texImage != null) {
            Paint savePaint = g.getPaint();
            Composite saveComposite = g.getComposite();
            if (!(this.texImage instanceof BufferedImage)) {
                throw new RuntimeException("Texture images must be of type BufferedImage.");
            }
            BufferedImage i = (BufferedImage)this.texImage;
            int w = this.texImage.getWidth(null);
            int h = this.texImage.getHeight(null);
            Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, w, h);
            TexturePaint tp = new TexturePaint(i, tr);
            if (this.isModulatedTexture()) {
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                g.setComposite(ac);
            }
            g.setPaint(tp);
            g.fill(wedge);
            g.setPaint(savePaint);
            g.setComposite(saveComposite);
        }
    }

    private boolean isDecalTexture() {
        return this.texImage != null && this.texEnvMode == 2;
    }

    private boolean isModulatedTexture() {
        return this.texImage != null && this.texEnvMode == 3;
    }

    protected void drawOutline(State state, java.awt.Shape wedge, Graphics2D g, Color color) {
        BasicStroke bs = state.getStroke(state.lineWidth, 0, 0, this.stipplePattern);
        Stroke save = g.getStroke();
        g.setStroke(bs);
        g.setColor(this.edgeColor);
        g.draw(wedge);
        g.setStroke(save);
    }

    public void setShape(double x, double y, double innerRadius, double outerRadius, double startAngle, double extentAngle) {
        this.world.x = x;
        this.world.y = y;
        this.world.z = 0.0;
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.startAngle = startAngle;
        this.extentAngle = extentAngle;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.texImage = null;
        if (ch.state.capabilities[10]) {
            this.texImage = ch.state.texImage;
            this.texEnvMode = ch.state.texEnvMode;
        }
        this.stipplePattern = (int[])(ch.state.capabilities[6] && ch.state.getStipplePattern() != null ? ch.state.getStipplePattern() : null);
        this.edgeColor = ch.state.edgecolor;
        this.fillmode = ch.state.fillmode;
        this.t1.set(this.world);
        ch.trans.Object2Window(this.t1);
        this.t2.set(this.world);
        this.t2.x += this.outerRadius;
        this.t2.y += this.outerRadius;
        ch.trans.Object2Window(this.t2);
        this.screenOuterUL.x = Math.min(this.t1.x - (this.t2.x - this.t1.x), this.t2.x);
        this.screenOuterUL.y = Math.min(this.t1.y - (this.t2.y - this.t1.y), this.t2.y);
        this.screenOuterSize.x = Math.abs((this.t1.x - this.t2.x) * 2.0);
        this.screenOuterSize.y = Math.abs((this.t1.y - this.t2.y) * 2.0);
        if (this.innerRadius > 0.0) {
            this.t2.set(this.world);
            this.t2.x += this.innerRadius;
            this.t2.y += this.innerRadius;
            ch.trans.Object2Window(this.t2);
            this.screenInnerUL.x = Math.min(this.t1.x - (this.t2.x - this.t1.x), this.t2.x);
            this.screenInnerUL.y = Math.min(this.t1.y - (this.t2.y - this.t1.y), this.t2.y);
            this.screenInnerSize.x = Math.abs((this.t1.x - this.t2.x) * 2.0);
            this.screenInnerSize.y = Math.abs((this.t1.y - this.t2.y) * 2.0);
        }
        this.screenCenter.set(this.screenOuterUL.x + this.screenOuterSize.x / 2.0, this.screenOuterUL.y + this.screenOuterSize.y / 2.0, this.screenOuterUL.z + this.screenOuterSize.z / 2.0, 1.0);
        this.bbox.x = (int)this.screenOuterUL.x;
        this.bbox.y = (int)this.screenOuterUL.y;
        this.bbox.width = (int)this.screenOuterSize.x;
        this.bbox.height = (int)this.screenOuterSize.y;
        this.clip = false;
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        Rectangle bounds = state.rt1;
        bounds.setBounds(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        if (aperture.intersects(clippedBounds)) {
            java.awt.Shape wedge = this.computeWedge();
            return wedge.intersects(aperture);
        }
        return false;
    }
}

