/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.DropShadowFilter;
import com.sas.graphics.image.GlowFilter;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.ScanConvert;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.VertexSet;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;

class J3Line
extends VertexSet
implements Cloneable {
    int[] stipplePattern;
    int lineWidth = 1;
    int capStyle = 0;
    int joinStyle = 1;
    Point4 center = new Point4();
    private Vec3d tempE = new Vec3d();
    private Vec3d tempP = new Vec3d();
    private Vec3d tempTeak = new Vec3d();

    J3Line() {
    }

    @Override
    protected void copyInit(Shape s) {
        super.copyInit(s);
        J3Line l = (J3Line)s;
        l.allocScreen();
        l.center = new Point4();
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip || this.lineWidth <= 0 && state.capabilities[29]) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (state.isSoftwareRender()) {
            this.renderSoftware(state, bgc);
        } else if (state.skinType == 0) {
            this.renderAWT(state, bgc);
        } else {
            this.drawSkin(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    public void renderSoftware(State state, Graphics g) {
        if (state.capabilities[30]) {
            double depth = this.zmax - this.zmin;
            double width = this.bbox.width;
            double height = this.bbox.height;
            double maxDepthSlope = Math.max(Math.abs(depth / width), Math.abs(depth / height));
            state.ch.setMaxDepthSlope(maxDepthSlope);
        }
        this.renderGeneric(state, g);
    }

    public void renderGeneric(State state, Graphics g) {
        if (this.stipplePattern != null) {
            state.stippleHistory[1] = 0;
            state.stippleHistory[0] = 0;
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                this.stipple(state, g, this.stipplePattern, state.stippleHistory, this.dscr[i].x, this.dscr[i].y, this.dscr[i].z, this.dscr[i + 1].x, this.dscr[i + 1].y, this.dscr[i + 1].z);
            }
        } else {
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                this.drawSegment(state, g, this.dscr[i].x, this.dscr[i].y, this.dscr[i].z, this.dscr[i + 1].x, this.dscr[i + 1].y, this.dscr[i + 1].z, null);
            }
        }
    }

    void drawLine(State state, Graphics g, int lw, Point4 dir, double x0, double y0, double z0, Color color1, float alpha1, double x1, double y1, double z1, Color color2, float alpha2) {
        boolean isSoft = state.isSoftwareRender();
        if (lw <= 1) {
            if (isSoft) {
                ScanConvert.bresenhamLine(state, lw, (int)(x0 + 0.5), (int)(y0 + 0.5), z0, color1, alpha1, (int)(x1 + 0.5), (int)(y1 + 0.5), z1, color2, alpha2);
            } else {
                g.drawLine((int)(x0 + 0.5), (int)(y0 + 0.5), (int)(x1 + 0.5), (int)(y1 + 0.5));
            }
        } else if (isSoft) {
            Color[] wideColor = state.wideLineColor;
            wideColor[0] = color1;
            wideColor[1] = color2;
            wideColor[2] = color2;
            wideColor[3] = color1;
            float[] wideAlpha = state.wideLineAlpha;
            wideAlpha[0] = alpha1;
            wideAlpha[1] = alpha2;
            wideAlpha[2] = alpha2;
            wideAlpha[3] = alpha1;
            state.appearance.color = this.color;
            state.appearance.litColor = this.color;
            state.appearance.colorPerVertex = wideColor;
            state.appearance.litColorPerVertex = wideColor;
            state.appearance.alphaPerVertex = wideAlpha;
            state.appearance.alpha = this.alpha;
            state.appearance.isLightOn = false;
            Point4[] wideDscr = state.ptArray;
            J3Line.makeWideLine(state, lw, state.ptArray, x0, y0, z0, x1, y1, z1, dir, false);
            state.scanConvert.drawConcavePolygon(state, 4, wideDscr, state.appearance);
        } else {
            J3Line.makeWideLine(state, lw, state.wideLineX, state.wideLineY, x0, y0, x1, y1, dir);
            g.fillPolygon(state.wideLineX, state.wideLineY, state.wideLineX.length);
        }
    }

    private void drawEndCap(State state, Graphics gc, double x1, double y1, double x2, double y2, Point4 dir) {
        double halfWidth = (double)this.lineWidth / 2.0 - 0.5;
        if (state.isSoftwareRender()) {
            state.appearance.color = this.color;
            state.appearance.litColor = this.color;
            state.appearance.colorPerVertex = this.colorPerVertex;
            state.appearance.litColorPerVertex = this.colorPerVertex;
            state.appearance.alphaPerVertex = this.alphaPerVertex;
            state.appearance.alpha = this.alpha;
            state.appearance.isLightOn = false;
            ScanConvert.drawCircle(state, x1, y1, 0.0, (double)this.lineWidth / 2.0, 5, state.appearance);
            ScanConvert.drawCircle(state, x2, y2, 0.0, (double)this.lineWidth / 2.0, 5, state.appearance);
        } else {
            gc.fillOval((int)(x1 - halfWidth + 0.5), (int)(y1 - halfWidth + 0.5), this.lineWidth, this.lineWidth);
            gc.fillOval((int)(x2 - halfWidth + 0.5), (int)(y2 - halfWidth + 0.5), this.lineWidth, this.lineWidth);
        }
    }

    public void drawSegment(State state, Graphics gc, double x1, double y1, double z1, double x2, double y2, double z2, Point4 dir) {
        this.drawLine(state, gc, this.lineWidth, dir, x1, y1, z1, this.color, this.alpha, x2, y2, z2, this.color, this.alpha);
        if (this.lineWidth > 1 && this.capStyle == 1) {
            this.drawEndCap(state, gc, x1, y1, x2, y2, dir);
        }
        if (this.shadowEnabled) {
            double dy;
            double dx = Math.abs(x2 - x1);
            if (dx > (dy = Math.abs(y2 - y1))) {
                x1 += 0.5;
                x2 += 0.5;
                y1 += 0.5 + (double)this.shadowOffsetY;
                y2 += 0.5 + (double)this.shadowOffsetY;
            } else {
                x1 += 0.5 + (double)this.shadowOffsetX;
                x2 += 0.5 + (double)this.shadowOffsetX;
                y1 += 0.5;
                y2 += 0.5;
            }
            this.drawLine(state, gc, this.lineWidth, dir, x1, y1, z1, Color.black, 0.5f, x2, y2, z2, Color.black, 0.5f);
        }
    }

    private void stipple(State state, Graphics gc, int[] pattern, int[] remainder, double beginX, double beginY, double beginZ, double endX, double endY, double endZ) {
        double x = beginX;
        double y = beginY;
        double dx = endX - beginX;
        double dy = endY - beginY;
        Point4 dir = state.pt6;
        double length = Math.sqrt(dx * dx + dy * dy);
        Point4 v1 = state.pt1;
        Point4 v2 = state.pt2;
        v1.set(beginX, beginY, 0.0);
        if (length > 0.0) {
            double ez;
            double bz;
            double lerpa;
            double l1;
            double drawn;
            dx /= length;
            dy /= length;
            dir.set(endX - beginX, endY - beginY, 0.0, 1.0);
            dir.normalize();
            int index = remainder[0];
            double d = drawn = remainder[1] > 0 ? (double)remainder[1] : (double)Math.abs(pattern[index]);
            while (length > drawn) {
                endX = beginX + dx * drawn;
                endY = beginY + dy * drawn;
                if (pattern[index] > 0) {
                    v2.set(x, y, 0.0);
                    v2.sub(v1);
                    l1 = v2.length();
                    lerpa = l1 / length;
                    bz = ScanConvert.lerp(lerpa, beginZ, endZ);
                    l1 += (double)pattern[index];
                    lerpa = v2.length() / length;
                    ez = ScanConvert.lerp(lerpa, beginZ, endZ);
                    this.drawSegment(state, gc, x, y, bz, endX, endY, ez, dir);
                } else {
                    x = beginX + dx * (drawn + 1.0);
                    y = beginY + dy * (drawn + 1.0);
                }
                index = (index + 1) % pattern.length;
                drawn += (double)Math.abs(pattern[index]);
            }
            if (pattern[index] > 0) {
                v2.set(x, y, 0.0);
                v2.sub(v1);
                l1 = v2.length();
                lerpa = l1 / length;
                bz = ScanConvert.lerp(lerpa, beginZ, endZ);
                l1 += (double)pattern[index];
                lerpa = v2.length() / length;
                ez = ScanConvert.lerp(lerpa, beginZ, endZ);
                this.drawSegment(state, gc, x, y, bz, beginX + dx * length, beginY + dy * length, ez, dir);
            }
            remainder[0] = index;
            remainder[1] = (int)(drawn - length);
        }
    }

    static void makeWideLine(State state, int lineWidth, int[] wideX, int[] wideY, double x1, double y1, double x2, double y2, Point4 direction) {
        Point4[] vertex = state.ptArray;
        J3Line.makeWideLine(state, lineWidth, state.ptArray, x1, y1, 0.0, x2, y2, 0.0, direction, false);
        for (int i = 0; i < 4; ++i) {
            wideX[i] = (int)(vertex[i].x + 0.5);
            wideY[i] = (int)(vertex[i].y + 0.5);
        }
    }

    static void makeWideLine(State state, int lineWidth, Point4[] vertex, double x1, double y1, double z1, double x2, double y2, double z2, Point4 direction, boolean squareCap) {
        double slope;
        double halfWidth = (double)lineWidth / 2.0;
        Point4 crossDir = state.pt2;
        Point4 v = state.pt3;
        Point4 dir = state.pt4;
        Point4 unitDir = state.pt5;
        if (direction == null) {
            dir.set(x2 - x1, y2 - y1, 0.0, 1.0);
        } else {
            v.set(x2 - x1, y2 - y1, 0.0, 1.0);
            dir.set(direction);
            if (v.x != 0.0 || v.y != 0.0) {
                dir.scale(v.length());
            }
        }
        if (dir.x == 0.0 && dir.y == 0.0) {
            dir.set(1.0, 0.0, 0.0, 1.0);
        }
        if ((slope = dir.y / dir.x) > 0.0) {
            crossDir.set(-dir.y, dir.x, 0.0, 1.0);
        } else {
            crossDir.set(dir.y, -dir.x, 0.0, 1.0);
        }
        crossDir.normalize();
        crossDir.scale(halfWidth);
        if (squareCap) {
            unitDir.set(dir);
            unitDir.normalize();
            unitDir.scale(crossDir.length());
        }
        v.set(x1, y1, 0.0, 1.0);
        if (squareCap) {
            v.sub(unitDir);
        }
        v.add(crossDir);
        vertex[0].x = v.x;
        vertex[0].y = v.y;
        vertex[0].z = z1;
        v.add(dir);
        if (squareCap) {
            v.add(unitDir);
        }
        vertex[1].x = v.x;
        vertex[1].y = v.y;
        vertex[1].z = z2;
        crossDir.normalize();
        crossDir.scale(-lineWidth);
        v.add(crossDir);
        vertex[2].x = v.x;
        vertex[2].y = v.y;
        vertex[2].z = z2;
        v.sub(dir);
        if (squareCap) {
            v.sub(unitDir);
        }
        vertex[3].x = v.x;
        vertex[3].y = v.y;
        vertex[3].z = z1;
    }

    @Override
    public Point4 getScreenCenter() {
        return this.center;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.stipplePattern = (int[])(ch.state.capabilities[6] && ch.state.getStipplePattern() != null ? ch.state.getStipplePattern() : null);
        this.capStyle = ch.state.capStyle;
        this.joinStyle = ch.state.joinStyle;
        this.lineWidth = ch.state.lineWidth;
        if (this.lineWidth > 1) {
            this.bbox.setBounds(this.bbox.x - this.lineWidth / 2, this.bbox.y - this.lineWidth / 2, this.bbox.width + this.lineWidth, this.bbox.height + this.lineWidth);
        }
        this.center.set(0.0, 0.0, 0.0, 1.0);
        for (int i = 0; i < this.vertexCount; ++i) {
            this.center.add(this.dscr[i]);
        }
        this.center.scale(1.0 / (double)this.vertexCount);
        this.center.t = 1.0;
    }

    void split(Channel ch) {
        if (this.vertexCount == 1) {
            J3Line line = new J3Line();
            Point4 p = this.vertex[0];
            line.vertex(ch, p.x, p.y, p.z);
            line.end(ch);
            ch.state.openDisplayList.primitives.addElement(line);
        } else {
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                J3Line line = new J3Line();
                Point4 p = this.vertex[i];
                line.vertex(ch, p.x, p.y, p.z);
                p = this.vertex[i + 1];
                line.vertex(ch, p.x, p.y, p.z);
                line.end(ch);
                ch.state.openDisplayList.primitives.addElement(line);
            }
        }
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        if (!aperture.intersects(this.bbox)) {
            return false;
        }
        for (int i = 0; i < this.vertexCount; ++i) {
            if (!aperture.contains(this.xpoints[i], this.ypoints[i])) continue;
            return true;
        }
        if (this.lineWidth == 1) {
            return this.pickSkinnyLine(aperture);
        }
        return this.pickWideLine(aperture, state);
    }

    private boolean pickWideLine(Rectangle aperture, State state) {
        J3Line.makeWideLine(state, this.lineWidth, state.wideLineX, state.wideLineY, (int)this.dscr[0].x, (int)this.dscr[0].y, (int)this.dscr[1].x, (int)this.dscr[1].y, null);
        return J3Line.apertureIntersectsPolygon(state, aperture, state.wideLineX, state.wideLineY, 4, this.falseEdgeFlagIndex, this.falseEdgeFlagCount);
    }

    private boolean pickSkinnyLine(Rectangle aperture) {
        return J3Line.apertureIntersectsEdges(aperture, this.xpoints, this.ypoints, this.vertexCount, this.falseEdgeFlagIndex, this.falseEdgeFlagCount);
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        if (state.render_mode == 2) {
            Point4[] t = state.ptArray;
            if (this.dscr.length <= 0) {
                t = new Point4[]{};
            } else {
                int feedbackLineWidth;
                int n = feedbackLineWidth = this.lineWidth <= 1 ? 2 : this.lineWidth;
                if (this.dscr.length == 1) {
                    J3Line.makeWideLine(state, feedbackLineWidth, state.wideLineX, state.wideLineY, (int)this.dscr[0].x, (int)this.dscr[0].y, (int)this.dscr[0].x, (int)this.dscr[0].y, null);
                } else {
                    J3Line.makeWideLine(state, feedbackLineWidth, state.wideLineX, state.wideLineY, (int)this.dscr[0].x, (int)this.dscr[0].y, (int)this.dscr[1].x, (int)this.dscr[1].y, null);
                }
                for (int i = 0; i < 4; ++i) {
                    t[i].x = state.wideLineX[i];
                    t[i].y = state.wideLineY[i];
                }
            }
            return t;
        }
        return super.getScreenCoords(state);
    }

    @Override
    protected void addShapeToFeedbackBuffer(State state) {
        int n = this.getVertexCount(state);
        if (n <= 0) {
            state.feedbackBuffer.addElement(new Polygon());
        } else if (n == 1) {
            Polygon polygon = this.newLineSegmentPolygon(state, 0);
            state.feedbackBuffer.addElement(polygon);
        } else {
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                if (i > 0) {
                    this.addNamestackToFeedbackBuffer(state);
                }
                Polygon polygon = this.newLineSegmentPolygon(state, i);
                state.feedbackBuffer.addElement(polygon);
            }
        }
    }

    @Override
    protected void addSVGSelectionShape(State state, Graphics bgc) {
        int n = this.getVertexCount(state);
        if (n <= 0) {
            bgc.fillPolygon(new Polygon());
        } else if (n == 1) {
            Polygon polygon = this.newLineSegmentPolygon(state, 0);
            bgc.fillPolygon(polygon);
        } else {
            for (int i = 0; i < this.vertexCount - 1; ++i) {
                if (i > 0) {
                    this.addSVGSelectionText(state, bgc);
                }
                Polygon polygon = this.newLineSegmentPolygon(state, i);
                bgc.fillPolygon(polygon);
            }
        }
    }

    private Polygon newLineSegmentPolygon(State state, int firstIndex) {
        Polygon polygon = new Polygon();
        int feedbackLineWidth = this.lineWidth <= 1 ? 2 : this.lineWidth;
        int i1 = firstIndex;
        int i2 = firstIndex + 1;
        if (i2 > this.getVertexCount(state) - 1) {
            i2 = i1;
        }
        J3Line.makeWideLine(state, feedbackLineWidth, state.wideLineX, state.wideLineY, (int)this.dscr[i1].x, (int)this.dscr[i1].y, (int)this.dscr[i2].x, (int)this.dscr[i2].y, null);
        for (int i = 0; i < 4; ++i) {
            polygon.addPoint(state.wideLineX[i], state.wideLineY[i]);
        }
        return polygon;
    }

    public void renderAWT(State state, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        BasicStroke s = state.getStroke(this.lineWidth, this.capStyle, this.joinStyle, this.stipplePattern);
        if (s != null) {
            Stroke saveStroke;
            block16: {
                saveStroke = g2.getStroke();
                g2.setStroke(s);
                g2.setColor(this.color);
                if (this.vertexCount == 1) {
                    int half = Math.round((float)this.lineWidth / 2.0f);
                    int size = this.lineWidth < 1 ? 1 : this.lineWidth;
                    g.fillRect(this.xpoints[0] - half, this.ypoints[0] - half, size, size);
                } else if (this.vertexCount == 2) {
                    if (state.capabilities[17] && this.lineWidth > 1 && g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON && (this.xpoints[0] == this.xpoints[1] || this.ypoints[0] == this.ypoints[1])) {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        g2.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    } else if (state.subpixelRendering) {
                        this.drawSubpixelLine(g2, this.xpointsD[0], this.ypointsD[0], this.xpointsD[1], this.ypointsD[1]);
                    } else {
                        g2.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[1], this.ypoints[1]);
                    }
                } else {
                    String os = System.getProperty("os.name");
                    if (os != null && os.toLowerCase().indexOf("z/os") >= 0) {
                        try {
                            if (state.subpixelRendering) {
                                this.drawSubpixelPolyline(g2, this.xpointsD, this.ypointsD, this.vertexCount);
                                break block16;
                            }
                            g2.drawPolyline(this.xpoints, this.ypoints, this.vertexCount);
                        }
                        catch (InternalError ie) {
                            System.out.println("%1zThe graph experienced an internal Java error while rendering polygons. You may be able to avoid this error by increasing your REGION size.");
                        }
                    } else if (state.subpixelRendering) {
                        this.drawSubpixelPolyline(g2, this.xpointsD, this.ypointsD, this.vertexCount);
                    } else {
                        g2.drawPolyline(this.xpoints, this.ypoints, this.vertexCount);
                    }
                }
            }
            this.drawEnd(state, g2);
            g2.setStroke(saveStroke);
        }
    }

    protected void drawSkin(State state, Graphics bgc) {
        int margin = state.lineWidth + J3Line.getBlurringMargin(3.0f * state.DPIScaleFactor, 3.0f * state.DPIScaleFactor, 3);
        int img_w = this.bbox.width + margin * 2;
        int img_h = this.bbox.height + margin * 2;
        BufferedImage src = new BufferedImage(img_w, img_h, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.translate(-this.bbox.x + margin, -this.bbox.y + margin);
        Color saveColor = this.color;
        int r = this.color.getRed();
        int g = this.color.getGreen();
        int b = this.color.getBlue();
        int a = this.color.getAlpha();
        this.alpha = (float)a / 255.0f;
        this.color = new Color(r, g, b, 255);
        this.renderAWT(state, g2);
        this.color = saveColor;
        g2.dispose();
        int dx = this.bbox.x - margin;
        int dy = this.bbox.y - margin;
        Composite saveComposite = ((Graphics2D)bgc).getComposite();
        Graphics gc = bgc;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (this.alpha < 1.0f) {
            combined = new BufferedImage(img_w, img_h, 2);
            bgc = combined.getGraphics();
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        switch (state.skinType) {
            case 5: {
                BufferedImage s_img = src;
                DropShadowFilter shadow = new DropShadowFilter();
                shadow.setHideObject(false);
                shadow.setInner(false);
                shadow.setAngle(45.0f);
                shadow.setBlurX(4.0f * state.DPIScaleFactor);
                shadow.setBlurY(4.0f * state.DPIScaleFactor);
                shadow.setDistance(2.0f * state.DPIScaleFactor);
                shadow.setAlpha(0.25f);
                shadow.setColor(Color.black);
                shadow.setQuality(0);
                shadow.setStrength(1.0f);
                s_img = shadow.filter(s_img, null);
                bgc.drawImage(s_img, dx, dy, null);
                break;
            }
            case 6: {
                BufferedImage b_img = src;
                bgc.drawImage(b_img, dx, dy, null);
                break;
            }
            case 7: {
                BufferedImage s_img = src;
                DropShadowFilter shadow = new DropShadowFilter();
                shadow.setHideObject(false);
                shadow.setInner(false);
                shadow.setAngle(45.0f);
                shadow.setBlurX(3.0f * state.DPIScaleFactor);
                shadow.setBlurY(3.0f * state.DPIScaleFactor);
                shadow.setDistance(1.7f * state.DPIScaleFactor);
                shadow.setAlpha(0.4f);
                shadow.setColor(Color.black);
                shadow.setQuality(3);
                shadow.setStrength(1.0f);
                s_img = shadow.filter(s_img, null);
                bgc.drawImage(s_img, dx, dy, null);
                break;
            }
            case 3: {
                BufferedImage g_img = src;
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(false);
                glow.setBlurX(1.1f * state.DPIScaleFactor);
                glow.setBlurY(1.1f * state.DPIScaleFactor);
                glow.setAlpha(0.3f);
                glow.setColor(Color.black);
                glow.setQuality(3);
                glow.setStrength(5.0f);
                glow.setInner(false);
                g_img = glow.filter(g_img, null);
                bgc.drawImage(g_img, dx, dy, null);
                break;
            }
            case 4: {
                BufferedImage s_img = src;
                DropShadowFilter shadow = new DropShadowFilter();
                shadow.setHideObject(false);
                shadow.setInner(false);
                shadow.setAngle(45.0f);
                shadow.setBlurX(3.0f * state.DPIScaleFactor);
                shadow.setBlurY(3.0f * state.DPIScaleFactor);
                shadow.setDistance(3.0f * state.DPIScaleFactor);
                shadow.setAlpha(0.25f);
                shadow.setColor(Color.black);
                shadow.setQuality(3);
                shadow.setStrength(1.0f);
                s_img = shadow.filter(s_img, null);
                bgc.drawImage(s_img, dx, dy, null);
                break;
            }
            default: {
                bgc.drawImage(src, dx, dy, null);
            }
        }
        if (this.alpha < 1.0f) {
            bgc.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, this.alpha));
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    private void drawEnd(State state, Graphics2D g2) {
        if (this.vertexCount > 1 && this.isPatterned()) {
            BasicStroke s = new BasicStroke(this.lineWidth, 0, 0);
            g2.setStroke(s);
            Vec3d e = this.tempE;
            Vec3d p = this.tempP;
            Vec3d tweak = this.tempTeak;
            if (state.subpixelRendering) {
                e.set(this.xpointsD[this.vertexCount - 1], this.ypointsD[this.vertexCount - 1], 0.0);
                p.set(this.xpointsD[this.vertexCount - 2], this.ypointsD[this.vertexCount - 2], 0.0);
            } else {
                e.set((double)this.xpoints[this.vertexCount - 1], (double)this.ypoints[this.vertexCount - 1], 0.0);
                p.set((double)this.xpoints[this.vertexCount - 2], (double)this.ypoints[this.vertexCount - 2], 0.0);
            }
            tweak.set(p);
            tweak.subtract(e);
            tweak.normalize();
            tweak.scale(1.0);
            tweak.add(e);
            if (state.subpixelRendering) {
                this.drawSubpixelLine(g2, Math.round(tweak.x), Math.round(tweak.y), this.xpointsD[this.vertexCount - 1], this.ypointsD[this.vertexCount - 1]);
            } else {
                g2.drawLine((int)Math.round(tweak.x), (int)Math.round(tweak.y), this.xpoints[this.vertexCount - 1], this.ypoints[this.vertexCount - 1]);
            }
        }
    }

    private boolean isPatterned() {
        return this.stipplePattern != null && this.stipplePattern.length >= 1;
    }

    private void drawSubpixelPolyline(Graphics2D g2, double[] xp, double[] yp, int count) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        GeneralPath path = new GeneralPath();
        path.moveTo(xp[0], yp[0]);
        for (int i = 1; i < count; ++i) {
            path.lineTo(xp[i], yp[i]);
        }
        g2.draw(path);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }

    private void drawSubpixelLine(Graphics2D g2, double x1, double y1, double x2, double y2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.draw(new Line2D.Double(x1, y1, x2, y2));
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }
}

