/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.BevelFilter;
import com.sas.graphics.image.DropShadowFilter;
import com.sas.graphics.image.GlowFilter;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.State;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;

class J3Ellipse
extends Shape {
    protected double xRadius;
    protected double yRadius;
    protected double angle;
    protected Point4 world = new Point4();
    protected Point4 screenCenter = new Point4();
    protected Ellipse2D ellipse = new Ellipse2D.Double();
    protected java.awt.Shape rotatedEllipse;
    protected Point4 t1 = new Point4();
    protected int fillmode;
    protected Color edgeColor;
    protected int lineWidth;
    private GeneralPath generalPath = null;
    private AffineTransform affineT;
    private boolean SVGRender = true;
    private double screenAngle;
    private double screenXRadius;
    private double screenYRadius;
    private Image skin;

    @Override
    public Point4 getScreenCenter() {
        return this.screenCenter;
    }

    private PathIterator getPathIterator(java.awt.Shape s) {
        double flatness = 2.0;
        return s.getPathIterator(null, flatness);
    }

    @Override
    public int getVertexCount(State state) {
        java.awt.Shape s = this.fillmode == 2 ? this.computeEllipseRing() : this.rotatedEllipse;
        int vertexCount = 0;
        PathIterator pi = this.getPathIterator(s);
        while (!pi.isDone()) {
            ++vertexCount;
            pi.next();
        }
        return vertexCount;
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        java.awt.Shape s = this.fillmode == 2 ? this.computeEllipseRing() : this.rotatedEllipse;
        double[] coord = new double[6];
        Point4[] coords = new Point4[this.getVertexCount(state)];
        PathIterator pi = this.getPathIterator(s);
        int i = 0;
        while (!pi.isDone()) {
            int type = pi.currentSegment(coord);
            coords[i] = new Point4();
            switch (type) {
                default: {
                    System.out.println("Unhandled PathIterator type.");
                    break;
                }
                case 0: 
                case 1: {
                    coords[i].x = coord[0];
                    coords[i].y = coord[1];
                    ++i;
                    break;
                }
                case 4: {
                    coords[i].x = coords[0].x;
                    coords[i].y = coords[0].y;
                    ++i;
                }
            }
            pi.next();
        }
        return coords;
    }

    @Override
    public final void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (!state.isSoftwareRender()) {
            if (state.skinType == 0) {
                this.awtRender(state, bgc);
            } else {
                this.drawSkin(state, bgc);
            }
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private java.awt.Shape computeEllipse() {
        java.awt.Shape result;
        AffineTransform af;
        this.ellipse.setFrame(-this.xRadius, -this.yRadius, this.xRadius * 2.0, this.yRadius * 2.0);
        if (this.angle != 0.0) {
            af = AffineTransform.getRotateInstance(-this.angle, 0.0, 0.0);
            result = af.createTransformedShape(this.ellipse);
        } else {
            result = this.ellipse;
        }
        af = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        result = af.createTransformedShape(result);
        result = this.affineT.createTransformedShape(result);
        Rectangle bounds = result.getBounds();
        this.bbox.x = bounds.x;
        this.bbox.y = bounds.y;
        this.bbox.width = bounds.width;
        this.bbox.height = bounds.height;
        if (this.SVGRender) {
            this.computeScreenAngle();
            this.computeScreenRadius();
        }
        return result;
    }

    private void computeScreenAngle() {
        double slopeInData = Math.tan(this.angle);
        Line2D.Double line = new Line2D.Double(0.0, 0.0, 1.0, -slopeInData);
        PathIterator path = line.getPathIterator(this.affineT);
        double[] coord1 = new double[2];
        path.currentSegment(coord1);
        path.next();
        double[] coord2 = new double[2];
        path.currentSegment(coord2);
        if (coord2[0] - coord1[0] == 0.0) {
            this.screenAngle = 1.5707963267948966;
        } else {
            double slopeInScreen = (coord2[1] - coord1[1]) / (coord2[0] - coord1[0]);
            this.screenAngle = Math.atan(slopeInScreen);
        }
    }

    private void computeScreenRadius() {
        java.awt.Shape result;
        Line2D.Double lineX = new Line2D.Double(0.0, 0.0, this.xRadius, 0.0);
        if (this.angle != 0.0) {
            AffineTransform af = AffineTransform.getRotateInstance(-this.angle, 0.0, 0.0);
            result = af.createTransformedShape(lineX);
        } else {
            result = lineX;
        }
        PathIterator path = result.getPathIterator(this.affineT);
        double[] coord1 = new double[2];
        path.currentSegment(coord1);
        path.next();
        double[] coord2 = new double[2];
        path.currentSegment(coord2);
        this.screenXRadius = Math.sqrt((coord2[0] - coord1[0]) * (coord2[0] - coord1[0]) + (coord2[1] - coord1[1]) * (coord2[1] - coord1[1]));
        Line2D.Double lineY = new Line2D.Double(0.0, 0.0, 0.0, this.yRadius);
        if (this.angle != 0.0) {
            AffineTransform af = AffineTransform.getRotateInstance(-this.angle, 0.0, 0.0);
            result = af.createTransformedShape(lineY);
        } else {
            result = lineY;
        }
        path = result.getPathIterator(this.affineT);
        coord1 = new double[2];
        path.currentSegment(coord1);
        path.next();
        coord2 = new double[2];
        path.currentSegment(coord2);
        this.screenYRadius = Math.sqrt((coord2[0] - coord1[0]) * (coord2[0] - coord1[0]) + (coord2[1] - coord1[1]) * (coord2[1] - coord1[1]));
    }

    private java.awt.Shape computeEllipseRing() {
        if (this.generalPath == null) {
            this.generalPath = new GeneralPath(0);
        }
        double tx = this.affineT.getTranslateX();
        double ty = this.affineT.getTranslateY();
        this.generalPath.reset();
        this.generalPath.append(this.rotatedEllipse, false);
        AffineTransform af = AffineTransform.getTranslateInstance(-tx, -ty);
        java.awt.Shape result = af.createTransformedShape(this.rotatedEllipse);
        af = AffineTransform.getScaleInstance(0.95, 0.95);
        result = af.createTransformedShape(result);
        af = AffineTransform.getTranslateInstance(tx, ty);
        result = af.createTransformedShape(result);
        this.generalPath.append(result, false);
        this.generalPath.closePath();
        return (java.awt.Shape)this.generalPath.clone();
    }

    protected void awtRender(State state, Graphics bgc) {
        Graphics2D g2 = (Graphics2D)bgc;
        switch (this.fillmode) {
            default: {
                this.drawFill(state, this.rotatedEllipse, g2, this.color);
                break;
            }
            case 2: {
                this.drawOutline(state, this.rotatedEllipse, g2, this.edgeColor);
                break;
            }
            case 4: {
                this.drawFill(state, this.rotatedEllipse, g2, this.color);
                this.drawOutline(state, this.rotatedEllipse, g2, this.edgeColor);
                break;
            }
            case 8: {
                this.drawFillPattern(state, this.rotatedEllipse, g2, state.fillPatternColor);
                break;
            }
            case 9: {
                this.drawFill(state, this.rotatedEllipse, g2, this.color);
                this.drawFillPattern(state, this.rotatedEllipse, g2, state.fillPatternColor);
                break;
            }
            case 10: {
                this.drawFillPattern(state, this.rotatedEllipse, g2, state.fillPatternColor);
                this.drawOutline(state, this.rotatedEllipse, g2, this.edgeColor);
                break;
            }
            case 11: {
                this.drawFill(state, this.rotatedEllipse, g2, this.color);
                this.drawFillPattern(state, this.rotatedEllipse, g2, state.fillPatternColor);
                this.drawOutline(state, this.rotatedEllipse, g2, this.edgeColor);
            }
            case 5: 
        }
    }

    protected void drawSkin(State state, Graphics bgc) {
        Color c;
        int a;
        int b;
        int g;
        int r;
        if (this.bbox.width == 0 || this.bbox.height == 0) {
            this.awtRender(state, bgc);
            return;
        }
        BufferedImage[] actualSizeImages = null;
        if (this.fillmode != 2 && state.pixelBenderImages != null) {
            actualSizeImages = new BufferedImage[state.pixelBenderImages.length];
            for (int i = 0; i < state.pixelBenderImages.length; ++i) {
                actualSizeImages[i] = new BufferedImage(this.bbox.width, this.bbox.height, 2);
                Graphics2D g2 = actualSizeImages[i].createGraphics();
                g2.drawImage(state.pixelBenderImages[i], 0, 0, this.bbox.width, this.bbox.height, null);
                g2.dispose();
            }
        }
        int margin = state.lineWidth + J3Ellipse.getBlurringMargin(3.0f * state.DPIScaleFactor, 4.0f * state.DPIScaleFactor, 3);
        int img_w = this.bbox.width + margin * 2;
        int img_h = this.bbox.height + margin * 2;
        BufferedImage src = new BufferedImage(img_w, img_h, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.translate(-this.bbox.x + margin, -this.bbox.y + margin);
        float alpha = 1.0f;
        if (this.fillmode == 2) {
            r = this.edgeColor.getRed();
            g = this.edgeColor.getGreen();
            b = this.edgeColor.getBlue();
            a = this.edgeColor.getAlpha();
            alpha = (float)a / 255.0f;
            c = new Color(r, g, b, 255);
            this.drawOutline(state, this.rotatedEllipse, g2, c);
        } else {
            r = this.color.getRed();
            g = this.color.getGreen();
            b = this.color.getBlue();
            a = this.color.getAlpha();
            alpha = (float)a / 255.0f;
            c = new Color(r, g, b, 255);
            this.drawFill(state, this.rotatedEllipse, g2, c);
        }
        g2.dispose();
        int dx = this.bbox.x - margin;
        int dy = this.bbox.y - margin;
        Composite saveComposite = ((Graphics2D)bgc).getComposite();
        Graphics gc = bgc;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (alpha < 1.0f) {
            combined = new BufferedImage(img_w, img_h, 2);
            bgc = combined.getGraphics();
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        if (this.fillmode != 2 && actualSizeImages != null) {
            src = this.blendImages(src, actualSizeImages, state.skinCategory, state.skinType, margin, margin);
        }
        boolean filtering = true;
        if ((state.skinRenderMode & 2) != 0) {
            BufferedImage s_img = src;
            DropShadowFilter shadow = new DropShadowFilter();
            shadow.setHideObject(false);
            shadow.setKnockout(false);
            shadow.setInner(false);
            shadow.setAngle(45.0f);
            shadow.setColor(Color.black);
            switch (state.skinType) {
                case 5: {
                    float dist = this.fillmode == 2 ? 2.0f : 3.0f;
                    shadow.setBlurX(4.0f * state.DPIScaleFactor);
                    shadow.setBlurY(4.0f * state.DPIScaleFactor);
                    shadow.setDistance(dist * state.DPIScaleFactor);
                    shadow.setAlpha(0.25f);
                    shadow.setQuality(0);
                    shadow.setStrength(1.0f);
                    break;
                }
                case 6: {
                    filtering = false;
                    break;
                }
                case 7: {
                    float dist = this.fillmode == 2 ? 1.7f : 2.5f;
                    shadow.setBlurX(3.0f * state.DPIScaleFactor);
                    shadow.setBlurY(3.0f * state.DPIScaleFactor);
                    shadow.setDistance(dist * state.DPIScaleFactor);
                    shadow.setAlpha(0.4f);
                    shadow.setQuality(3);
                    shadow.setStrength(1.0f);
                    break;
                }
                case 3: {
                    filtering = false;
                    break;
                }
                case 4: {
                    shadow.setBlurX(3.0f * state.DPIScaleFactor);
                    shadow.setBlurY(3.0f * state.DPIScaleFactor);
                    shadow.setDistance(3.0f * state.DPIScaleFactor);
                    shadow.setAlpha(0.25f);
                    shadow.setQuality(3);
                    shadow.setStrength(1.0f);
                    break;
                }
                default: {
                    filtering = false;
                }
            }
            if (filtering) {
                s_img = shadow.filter(s_img, null);
                bgc.drawImage(s_img, dx, dy, null);
            }
        }
        if ((state.skinRenderMode & 1) != 0 && !filtering) {
            bgc.drawImage(src, dx, dy, null);
        }
        filtering = true;
        if ((state.skinRenderMode & 4) != 0 && this.fillmode != 2) {
            BufferedImage b_img = src;
            BevelFilter bevel = new BevelFilter();
            bevel.setKnockout(true);
            bevel.setHighlightColor(Color.white);
            bevel.setShadowColor(Color.black);
            bevel.setAngle(45.0f);
            switch (state.skinType) {
                case 5: {
                    bevel.setDistance(4.0f * state.DPIScaleFactor);
                    bevel.setBlurX(0.0f);
                    bevel.setBlurY(0.0f);
                    bevel.setHighlightAlpha(0.3f);
                    bevel.setShadowAlpha(0.2f);
                    bevel.setQuality(0);
                    bevel.setStrength(1.0f);
                    break;
                }
                case 6: {
                    filtering = false;
                    break;
                }
                case 7: {
                    float fac = (float)this.bbox.width / 50.0f;
                    bevel.setBlurX(25.0f * fac * state.DPIScaleFactor);
                    bevel.setBlurY(25.0f * fac * state.DPIScaleFactor);
                    bevel.setDistance(10.0f * fac * state.DPIScaleFactor);
                    bevel.setHighlightAlpha(0.5f);
                    bevel.setShadowAlpha(0.4f);
                    bevel.setQuality(3);
                    bevel.setStrength(1.0f);
                    bevel.setPostProcessRequired(true);
                    break;
                }
                case 3: {
                    filtering = false;
                    break;
                }
                case 4: {
                    filtering = false;
                    break;
                }
                default: {
                    filtering = false;
                }
            }
            if (filtering) {
                b_img = bevel.filter(b_img, null);
                bgc.drawImage(b_img, dx, dy, null);
            }
        }
        if (this.fillmode != 2 && this.skin != null && this.angle == 0.0 && this.bbox.width > 0 && this.bbox.height > 0) {
            int skinWidth = (int)Math.ceil(this.bbox.width);
            int skinHeight = (int)Math.ceil(this.bbox.height);
            BufferedImage scaledImage = new BufferedImage(skinWidth, skinHeight, 2);
            Graphics2D imageGraphics = scaledImage.createGraphics();
            imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            imageGraphics.drawImage(this.skin, 0, 0, skinWidth, skinHeight, null);
            if (alpha < 1.0f) {
                bgc.drawImage(scaledImage, margin, margin, skinWidth, skinHeight, null);
            } else {
                bgc.drawImage(scaledImage, this.bbox.x, this.bbox.y, skinWidth, skinHeight, null);
            }
            imageGraphics.dispose();
        }
        filtering = true;
        if ((state.skinRenderMode & 8) != 0 && (this.fillmode == 2 || (float)this.bbox.width >= 5.0f * state.DPIScaleFactor && (float)this.bbox.height >= 5.0f * state.DPIScaleFactor)) {
            BufferedImage g_img = src;
            GlowFilter glow = new GlowFilter();
            glow.setKnockout(true);
            glow.setColor(Color.black);
            switch (state.skinType) {
                case 5: {
                    if (this.fillmode == 2) {
                        filtering = false;
                        break;
                    }
                    glow.setBlurX(1.2f * state.DPIScaleFactor);
                    glow.setBlurY(1.2f * state.DPIScaleFactor);
                    glow.setAlpha(0.8f);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    glow.setInner(true);
                    break;
                }
                case 6: {
                    if (this.fillmode == 2) {
                        glow.setBlurX(1.1f * state.DPIScaleFactor);
                        glow.setBlurY(1.1f * state.DPIScaleFactor);
                        glow.setAlpha(0.3f);
                        glow.setQuality(3);
                        glow.setStrength(5.0f);
                        glow.setInner(false);
                        break;
                    }
                    glow.setBlurX(1.2f * state.DPIScaleFactor);
                    glow.setBlurY(1.2f * state.DPIScaleFactor);
                    glow.setAlpha(0.6f);
                    glow.setQuality(2);
                    glow.setStrength(5.0f);
                    glow.setInner(true);
                    break;
                }
                case 7: {
                    if (this.fillmode == 2) {
                        filtering = false;
                        break;
                    }
                    glow.setBlurX(1.5f * state.DPIScaleFactor);
                    glow.setBlurY(1.5f * state.DPIScaleFactor);
                    glow.setAlpha(0.6f);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    glow.setInner(true);
                    break;
                }
                case 3: {
                    if (this.fillmode == 2) {
                        glow.setBlurX(1.1f * state.DPIScaleFactor);
                        glow.setBlurY(1.1f * state.DPIScaleFactor);
                        glow.setAlpha(0.3f);
                        glow.setQuality(3);
                        glow.setStrength(5.0f);
                        glow.setInner(false);
                        break;
                    }
                    glow.setBlurX(1.2f * state.DPIScaleFactor);
                    glow.setBlurY(1.2f * state.DPIScaleFactor);
                    glow.setAlpha(0.5f);
                    glow.setQuality(4);
                    glow.setStrength(3.0f);
                    glow.setInner(false);
                    break;
                }
                case 4: {
                    if (this.fillmode == 2) {
                        filtering = false;
                        break;
                    }
                    glow.setBlurX(1.5f * state.DPIScaleFactor);
                    glow.setBlurY(1.5f * state.DPIScaleFactor);
                    glow.setAlpha(0.5f);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    glow.setInner(true);
                    break;
                }
                default: {
                    filtering = false;
                }
            }
            if (filtering) {
                g_img = glow.filter(g_img, null);
                bgc.drawImage(g_img, dx, dy, null);
            }
        }
        if (alpha < 1.0f) {
            bgc.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, alpha));
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    private void drawFill(State state, java.awt.Shape s, Graphics2D g, Color color) {
        g.setColor(color);
        if (!this.SVGRender) {
            g.fill(s);
        } else {
            AffineTransform save_af = g.getTransform();
            AffineTransform af = AffineTransform.getRotateInstance(-this.screenAngle, this.screenCenter.x, this.screenCenter.y);
            af.preConcatenate(save_af);
            g.setTransform(af);
            g.fillOval((int)(this.screenCenter.x - this.screenXRadius), (int)(this.screenCenter.y - this.screenYRadius), (int)(this.screenXRadius * 2.0), (int)(this.screenYRadius * 2.0));
            g.setTransform(save_af);
        }
        if (state.skinType == 0 && this.skin != null && this.angle == 0.0 && this.bbox.width > 0 && this.bbox.height > 0) {
            int skinWidth = (int)Math.ceil(this.bbox.width);
            int skinHeight = (int)Math.ceil(this.bbox.height);
            BufferedImage scaledImage = new BufferedImage(skinWidth, skinHeight, 2);
            Graphics2D imageGraphics = scaledImage.createGraphics();
            imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            imageGraphics.drawImage(this.skin, 0, 0, skinWidth, skinHeight, null);
            g.drawImage(scaledImage, this.bbox.x, this.bbox.y, skinWidth, skinHeight, null);
            imageGraphics.dispose();
        }
    }

    protected void drawOutline(State state, java.awt.Shape s, Graphics2D g, Color color) {
        BasicStroke bs = state.getStroke(state.lineWidth, 0, 0, state.getStipplePattern());
        Stroke save = g.getStroke();
        g.setStroke(bs);
        g.setColor(color);
        if (!this.SVGRender) {
            g.draw(s);
        } else {
            AffineTransform save_af = g.getTransform();
            AffineTransform af = AffineTransform.getRotateInstance(-this.screenAngle, this.screenCenter.x, this.screenCenter.y);
            af.preConcatenate(save_af);
            g.setTransform(af);
            g.drawOval((int)(this.screenCenter.x - this.screenXRadius), (int)(this.screenCenter.y - this.screenYRadius), (int)(this.screenXRadius * 2.0), (int)(this.screenYRadius * 2.0));
            g.setTransform(save_af);
        }
        g.setStroke(save);
    }

    private void drawFillPattern(State state, java.awt.Shape s, Graphics2D g2, Color color) {
        java.awt.Shape clip;
        boolean doubleLine;
        g2.setColor(color);
        AffineTransform afSave = g2.getTransform();
        Stroke strokeSave = g2.getStroke();
        Rectangle clipSave = g2.getClipBounds();
        Rectangle bboxSave = this.bbox;
        int gap = 0;
        int step = 0;
        int thickness = state.fillPatternWidth;
        boolean bl = doubleLine = state.fillPatternWidth == 4 || state.fillPatternWidth == 5;
        if (doubleLine) {
            gap = state.fillPatternWidth == 4 ? 3 : 5;
            thickness = state.fillPatternWidth == 4 ? 1 : 2;
            step = gap + thickness;
        }
        int stride = 5 + state.fillPatternWidth * 3;
        thickness = (int)Math.round((double)thickness * state.fillPatternScaleFactor);
        gap = (int)Math.round((double)gap * state.fillPatternScaleFactor);
        step = (int)Math.round((double)step * state.fillPatternScaleFactor);
        stride = (int)Math.round((double)stride * state.fillPatternScaleFactor);
        if (this.SVGRender) {
            AffineTransform af = AffineTransform.getRotateInstance(-this.screenAngle, this.screenCenter.x, this.screenCenter.y);
            af.preConcatenate(afSave);
            g2.setTransform(af);
            clip = new Ellipse2D.Double((int)(this.screenCenter.x - this.screenXRadius), (int)(this.screenCenter.y - this.screenYRadius), (int)(this.screenXRadius * 2.0), (int)(this.screenYRadius * 2.0));
            this.bbox = clip.getBounds();
        } else {
            clip = s;
        }
        g2.setStroke(new BasicStroke(thickness));
        if (clipSave == null) {
            g2.setClip(clip);
        } else {
            Area area1 = new Area(clip);
            Area area2 = new Area(clipSave);
            area1.intersect(area2);
            g2.setClip(area1);
        }
        int w = this.bbox.width - 1;
        int x2 = this.bbox.x + w;
        int y2 = this.bbox.y + this.bbox.height - 1;
        switch (state.fillPatternType) {
            case 0: {
                for (int y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y, x2, y + w);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, x2, y + step + w);
                }
                int x = this.bbox.x;
                for (int y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(x += stride, this.bbox.y, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(x - step, this.bbox.y, x2, y + step);
                }
                break;
            }
            case 1: {
                int y;
                for (y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step + w, x2, y + step);
                }
                int x = x2;
                for (y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(this.bbox.x, y, x -= stride, this.bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, x + step, this.bbox.y);
                }
                break;
            }
            case 2: {
                for (int y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y, x2, y + w);
                    if (doubleLine) {
                        g2.drawLine(this.bbox.x, y + step, x2, y + step + w);
                    }
                    g2.drawLine(this.bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step + w, x2, y + step);
                }
                int xl = this.bbox.x;
                int xr = x2;
                for (int y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(xl += stride, this.bbox.y, x2, y);
                    if (doubleLine) {
                        g2.drawLine(xl - step, this.bbox.y, x2, y + step);
                    }
                    g2.drawLine(this.bbox.x, y, xr -= stride, this.bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, xr + step, this.bbox.y);
                }
                break;
            }
            case 3: {
                g2.fill(s);
                break;
            }
        }
        this.bbox = bboxSave;
        g2.setClip(clipSave);
        g2.setStroke(strokeSave);
        g2.setTransform(afSave);
    }

    public void setShape(double x, double y, double xRadius, double yRadius, double angle) {
        this.world.x = x;
        this.world.y = y;
        this.world.z = 0.0;
        this.xRadius = xRadius;
        this.yRadius = yRadius;
        this.angle = angle;
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.edgeColor = ch.state.edgecolor;
        this.fillmode = ch.state.fillmode;
        this.lineWidth = ch.state.lineWidth;
        this.t1.set(this.world);
        ch.trans.Object2Window(this.t1);
        this.screenCenter.x = this.t1.x;
        this.screenCenter.y = this.t1.y;
        this.affineT = ch.trans.getAffineTransform();
        this.rotatedEllipse = this.computeEllipse();
        this.clip = false;
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        Rectangle bounds = state.rt1;
        bounds.setBounds(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        if (aperture.intersects(clippedBounds)) {
            java.awt.Shape s = this.fillmode == 2 ? this.computeEllipseRing() : this.rotatedEllipse;
            return s.intersects(aperture);
        }
        return false;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public void setSkin(Image skinImage) {
        this.skin = skinImage;
    }
}

