/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Primitive;
import com.sas.graphics.util.gl.State;
import java.awt.Graphics;
import java.util.Vector;

class DisplayList {
    long id;
    Vector primitives;

    DisplayList(long lid) {
        this.id = lid;
        this.primitives = new Vector();
    }

    public void computeScreen(Channel ch) {
        int num = this.primitives.size();
        for (int i = 0; i < num; ++i) {
            Primitive prim = (Primitive)this.primitives.elementAt(i);
            prim.computeScreen(ch);
        }
    }

    public void render(State state, Graphics bgc) {
        int num = this.primitives.size();
        for (int i = 0; i < num; ++i) {
            Primitive prim = (Primitive)this.primitives.elementAt(i);
            prim.render(state, bgc);
        }
    }

    public boolean isClipped() {
        boolean clip = true;
        int num = this.primitives.size();
        for (int i = 0; i < num; ++i) {
            Primitive prim = (Primitive)this.primitives.elementAt(i);
            clip &= prim.isClipped();
        }
        return clip;
    }

    public long getId() {
        return this.id;
    }

    public void insertToSortlist(State state) {
        int num = this.primitives.size();
        for (int i = 0; i < num; ++i) {
            Primitive prim = (Primitive)this.primitives.elementAt(i);
            prim.insertToSortlist(state);
        }
    }
}

