/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.ColorGradient;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.TransInfo;
import com.sas.graphics.util.gl.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Stack;
import java.util.Vector;

public class Channel {
    protected Component component;
    protected Image[] backbuffer;
    protected int backbufferCount = 2;
    private Graphics[] bgc;
    int currentBuffer;
    private Color backgroundColor = Color.gray;
    private Color rasterBackgroundColor = null;
    private Color rasterBackgroundEdgeColor = null;
    private Insets rasterBackgroundPad = null;
    private Image backgroundImage = null;
    private int backgroundImageStyle = 2;
    private int backgroundImagePositionX = 0;
    private int backgroundImagePositionY = 0;
    private Image scaledBackgroundImage = null;
    protected int maxwidth = 10;
    protected int maxheight = 10;
    State state;
    TransInfo trans;
    protected myComponentAdapter componentListener = null;
    protected Rectangle viewportClipRectangle = new Rectangle();
    protected Rectangle userClipRectangle = null;
    protected Rectangle maximumProjectionArea = null;
    protected Rectangle tempRectangle = new Rectangle();
    private ColorGradient tempColorGradient = new ColorGradient();
    private int[] pixels;
    private float[] alpha;
    private double[] zbuffer = null;
    private MemoryImageSource memoryImageSource;
    private boolean texturePlant = false;
    int displayMode;
    int refreshCount = -1;
    private boolean transparentBackground = false;
    static final int PIXEL_TYPE_POLYGON_FILL = 0;
    static final int PIXEL_TYPE_POLYGON_LINE = 1;
    static final int PIXEL_TYPE_POLYGON_POINT = 2;
    static final int PIXEL_TYPE_POLYGON_OTHER = 3;
    int pixelType = 0;
    double maxDepthSlope;

    public Channel(Component component) {
        this(component, 1);
    }

    public Channel(Component component, int displayMode) {
        if (component == null) {
            throw new Error("Channel: component can't be null.");
        }
        this.state = new State(this);
        this.trans = new TransInfo(this);
        this.component = component;
        this.componentListener = new myComponentAdapter(this);
        component.addComponentListener(this.componentListener);
        this.backbufferCount += 4;
        this.bgc = new Graphics[this.backbufferCount];
        this.backbuffer = new Image[this.backbufferCount];
        this.glViewport(0, 0, 1, 1);
        this.glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
        this.gluLookAt(0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.setDisplayMode(displayMode);
    }

    public void setDisplayMode(int displayMode) {
        if (displayMode != 2 && displayMode != 1) {
            throw new IllegalArgumentException("displayMode must be one of GL.SINGLE or GL.DOUBLE");
        }
        this.displayMode = displayMode;
        if ((displayMode & 1) > 0) {
            this.setBackbuffer(0);
        } else {
            this.currentBuffer = 0;
        }
        this.bgc[0] = this.state.softGraphics.getDelegateGraphics();
        this.allocateBackbuffer();
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setVertexBufferReallocationSize(int size) {
        this.state.setVertexBufferReallocationSize(size);
    }

    public void setSingleBufferGraphics(Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException("Graphics object may not be null.");
        }
        this.bgc[0] = g;
    }

    public void glTexImage2D(Image i) {
        this.state.setTexImage2D(i);
    }

    public void glTexEnv(int target, int pname, int param) {
        this.state.setTexEnv(target, pname, param);
    }

    public void setDepthTestAlgorithm(int algorithm) {
        this.state.setDepthTestAlgorithm(algorithm);
        this.allocateBackbuffer();
    }

    State getState() {
        return this.state;
    }

    public void addNotify() {
    }

    public void setBackgroundColor(Color color) {
        this.glClearColor(color);
    }

    public void glClearColor(Color color) {
        if (color != null) {
            this.backgroundColor = color;
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setExtrusionVector(double x, double y, double z) {
        this.state.setExtrusionVector(x, y, z);
    }

    public void setRasterBackgroundColor(Color color) {
        this.rasterBackgroundColor = color;
    }

    public Color getRasterBackgroundColor() {
        return this.rasterBackgroundColor;
    }

    public void setRasterBackgroundEdgeColor(Color color) {
        this.rasterBackgroundEdgeColor = color;
    }

    public Color getRasterBackgroundEdgeColor() {
        return this.rasterBackgroundEdgeColor;
    }

    public void removeBackgroundImage() {
        this.backgroundImage = null;
        this.scaledBackgroundImage = null;
    }

    public void setBackgroundImage(Image image, int style) {
        this.backgroundImage = image;
        this.scaledBackgroundImage = null;
        if (image != null) {
            image.getWidth(this.component);
            image.getHeight(this.component);
        }
        this.backgroundImageStyle = style;
    }

    public void setBackgroundImagePosition(int x, int y) {
        this.backgroundImagePositionX = x;
        this.backgroundImagePositionY = y;
    }

    public Graphics getGraphics() {
        return this.component.getGraphics();
    }

    public int getWidth() {
        Dimension size = this.component.getSize();
        return size.width;
    }

    public int getHeight() {
        Dimension size = this.component.getSize();
        return size.height;
    }

    public Component getComponent() {
        return this.component;
    }

    public Graphics getBackbufferGC() {
        return this.bgc[this.currentBuffer];
    }

    public Image getBackbuffer() {
        return this.backbuffer[this.currentBuffer];
    }

    public int getBackbufferId() {
        return this.bufferIndexToId(this.currentBuffer);
    }

    public void glDisable(int cap) {
        this.state.Disable(cap);
    }

    public void glEnable(int cap) {
        this.state.Enable(cap);
    }

    public boolean glIsEnabled(int cap) {
        return this.state.capabilities[cap];
    }

    public void glPushAttrib(int mask) {
        this.state.PushAttrib(mask);
    }

    public void glPopAttrib() {
        this.state.PopAttrib();
    }

    public synchronized void glCallList(long lid) {
        this.glCallList(this.bgc[this.currentBuffer], lid, true);
    }

    public synchronized void glCallList(Graphics g, long lid, boolean reComputeScreenCoordinates) {
        Debug.println((String)("glCallList: name=" + lid));
        if (g == null) {
            return;
        }
        Rectangle c = g.getClipBounds();
        this.setClip(g);
        this.state.CallList(this, g, lid, reComputeScreenCoordinates);
        g.setClip(c);
    }

    public void glCallList(Graphics g, long lid) {
        this.glCallList(g, lid, true);
    }

    public synchronized void glCallList(long lid, boolean reComputeScreenCoordinates) {
        this.glCallList(this.bgc[this.currentBuffer], lid, reComputeScreenCoordinates);
    }

    public synchronized void glDeleteList(long lid) {
        this.state.DeleteList(lid);
    }

    public synchronized void glNewList(long lid) {
        Debug.println((String)("glNewList: name=" + lid));
        this.state.NewList(lid);
    }

    public synchronized void glNewList(long lid, boolean optimized) {
        this.glNewList(lid);
    }

    public synchronized void glEndList() {
        this.state.EndList();
    }

    public long glGenLists(long size) {
        return this.state.GenLists(size);
    }

    public boolean glIsList(long lid) {
        return this.state.IsList(lid);
    }

    public void glViewport(int x, int y, int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        if (width > this.maxwidth || height > this.maxheight) {
            this.maxwidth = width;
            this.maxheight = height;
            Dimension d = this.component.getSize();
            if (d.width > this.maxwidth) {
                this.maxwidth = d.width;
            }
            if (d.height > this.maxheight) {
                this.maxheight = d.height;
            }
        }
        this.allocateBackbuffer();
        this.trans.Viewport(x, y, width, height);
        this.viewportClipRectangle.setBounds(x, y, width, height);
        this.setClip();
    }

    public void glViewport(int width, int height, Insets border) {
        this.glViewport(border.left, border.top, width - border.left - border.right, height - border.top - border.bottom);
    }

    public void glShadeModel(int shadeModel) {
        if (shadeModel != 1 && shadeModel != 0) {
            shadeModel = 1;
        }
        this.state.shadeModel(shadeModel);
    }

    private void setClip() {
        Graphics g = this.bgc[this.currentBuffer];
        this.setClip(g);
    }

    final Rectangle getClip() {
        return this.userClipRectangle == null ? this.viewportClipRectangle : this.userClipRectangle;
    }

    private void setClip(Graphics g) {
        if (this.state.capabilities[27]) {
            Rectangle r;
            Rectangle rectangle = r = this.userClipRectangle == null ? this.viewportClipRectangle : this.userClipRectangle;
            if (g != null) {
                g.setClip(r.x, r.y, r.width, r.height);
            }
        }
    }

    public void glOblique(double left, double right, double bottom, double top, double near, double far, double distort, double angle) {
        this.trans.Oblique(left, right, bottom, top, near, far, distort, angle);
    }

    public void glOrtho(double left, double right, double bottom, double top, double near, double far) {
        this.trans.Ortho(left, right, bottom, top, near, far);
    }

    public void glFrustum(double left, double right, double bottom, double top, double near, double far) {
        this.trans.Frustum(left, right, bottom, top, near, far);
    }

    public void gluPerspective(double fov, double aspect, double near, double far) {
        this.trans.Perspective(fov, aspect, near, far);
    }

    public void gluLookAt(double eyex, double eyey, double eyez, double centerx, double centery, double centerz, double upx, double upy, double upz) {
        this.trans.LookAt(eyex, eyey, eyez, centerx, centery, centerz, upx, upy, upz);
    }

    public void gluLookAt(double centerx, double centery, double centerz, double dist, double azim, double inc, double twist) {
        this.trans.LookAt(centerx, centery, centerz, dist, azim, inc, twist);
    }

    public void gluUnProject(double[] win, double[] obj) {
        Point4 p = this.state.pt1;
        p.set(win[0], win[1], win[2], 1.0);
        this.trans.Window2Object(p);
        obj[0] = p.x;
        obj[1] = p.y;
        obj[2] = p.z;
    }

    public void gluProject(double[] obj, double[] win) {
        Point4 p = this.state.pt1;
        p.set(obj[0], obj[1], obj[2], 1.0);
        this.trans.Object2Window2(p);
        win[0] = p.x;
        win[1] = p.y;
        win[2] = p.z;
    }

    public void glLoadIdentity() {
        this.trans.LoadIdentity(this.state.render_mode, this.state);
    }

    public void glScale(double x, double y, double z) {
        this.trans.Scale(x, y, z, this.state.render_mode, this.state);
    }

    public void glTranslate(double x, double y, double z) {
        this.trans.Translate(x, y, z, this.state);
    }

    public void glRotate(double angle, double x, double y, double z) {
        this.trans.Rotate(angle, x, y, z, this.state);
    }

    public void glRotate(double centerx, double centery, double centerz, double x, double y, double z, double angle) {
        this.trans.Rotate(centerx, centery, centerz, x, y, z, angle, this.state);
    }

    public double[] gluGetScreenX() {
        return this.trans.getWindow(1.0, 0.0, 0.0);
    }

    public double[] gluGetScreenY() {
        return this.trans.getWindow(0.0, 1.0, 0.0);
    }

    public double[] gluGetScreenZ() {
        return this.trans.getWindow(0.0, 0.0, 1.0);
    }

    public void glLoadMatrix(double[] matrix) {
        this.trans.LoadMatrix(matrix, this.state.render_mode, this.state);
    }

    public void glGetMatrix(double[] matrix) {
        this.trans.GetMatrix(matrix);
    }

    public void glPopMatrix() {
        this.trans.PopMatrix(this.state.render_mode, this.state);
    }

    public void glPushMatrix() {
        this.trans.PushMatrix(this.state.render_mode, this.state);
    }

    public void glEdgeFlag(boolean f) {
        this.state.EdgeFlag(f);
    }

    public void glRect(double x1, double y1, double x2, double y2) {
        this.state.Rect(x1, y1, x2, y2, null);
    }

    public Shape glWedge(double x, double y, double innerRadius, double outerRadius, double startAngle, double extentAngle) {
        return this.state.Wedge(x, y, innerRadius, outerRadius, startAngle, extentAngle);
    }

    public Shape glEllipse(double x, double y, double xRadius, double yRadius, double angle, boolean SVGRender, Image skin) {
        return this.state.Ellipse(x, y, xRadius, yRadius, angle, SVGRender, skin);
    }

    public void glRect(double x1, double y1, Color color1, float alpha1, double x2, double y2, Color color2, float alpha2, int gradientDirection) {
        this.tempColorGradient.color1 = color1;
        this.tempColorGradient.color2 = color2;
        this.tempColorGradient.alpha1 = alpha1;
        this.tempColorGradient.alpha2 = alpha2;
        this.tempColorGradient.direction = gradientDirection;
        this.state.Rect(x1, y1, x2, y2, this.tempColorGradient);
    }

    public void glBegin(int mode) {
        this.state.Begin(mode);
    }

    public void glEnd() {
        this.state.End(this.bgc[this.currentBuffer]);
    }

    public void Image2D(Image img, double px, double py, double pz, int width, int height) {
        this.state.Image2D(img, px, py, pz, width, height, this.rasterBackgroundColor);
    }

    public void ImageWaitImage(Image aImage) {
        this.state.ImageWaitImage(aImage);
    }

    public void glSelect2DFont(Font font) {
        this.state.Select2DFont(font);
    }

    public void glSelect2DFont(String name, int style) {
        this.state.Select2DFont(name, style);
    }

    public void glTextHeight(double height) {
        this.state.TextHeight(height);
    }

    public void glTextHeight(int point) {
        this.state.TextHeight(point);
    }

    public void gl2DText(String string) {
        this.state.Text2D(string, 0.0, 0.0, 0.0, 0, this.rasterBackgroundColor, this.rasterBackgroundEdgeColor, this.rasterBackgroundPad);
    }

    public void gl2DText(String string, int angle) {
        this.state.Text2D(string, 0.0, 0.0, 0.0, angle, this.rasterBackgroundColor, this.rasterBackgroundEdgeColor, this.rasterBackgroundPad);
    }

    public void gl2DText(String string, double x, double y, double z) {
        this.state.Text2D(string, x, y, z, 0, this.rasterBackgroundColor, this.rasterBackgroundEdgeColor, this.rasterBackgroundPad);
    }

    public void gl2DText(String string, double x, double y, double z, int angle) {
        this.state.Text2D(string, x, y, z, angle, this.rasterBackgroundColor, this.rasterBackgroundEdgeColor, this.rasterBackgroundPad);
    }

    public void glTextAlign(int halign, int valign) {
        this.state.Alignment(halign, valign);
    }

    public void glAlignment(int halign, int valign) {
        this.state.Alignment(halign, valign);
    }

    public void glGetText2DBbox(String string, double x, double y, double z, int angle, Bbox bbox) {
        if (bbox != null) {
            this.setupRasterTextShadows();
            this.state.rasterTextBuffer.getBBox(string, x, y, z, angle, bbox, this.state, this.bgc[this.currentBuffer]);
        }
    }

    public void glGetTextProjection(String string, double x, double y, double z, int angle, Rectangle r) {
        if (r != null) {
            this.setupRasterTextShadows();
            this.state.rasterTextBuffer.getTextProjection(string, x, y, z, angle, r, this.state, this.bgc[this.currentBuffer]);
        }
    }

    private void setupRasterTextShadows() {
        this.state.rasterTextBuffer.shadowEnabled = this.state.capabilities[11];
        this.state.rasterTextBuffer.shadowOffsetX = this.state.shadowOffsetX;
        this.state.rasterTextBuffer.shadowOffsetY = this.state.shadowOffsetY;
    }

    public double glGetTextWidth(String string) {
        double result = 0.0;
        if (!"".equals(string)) {
            this.setupRasterTextShadows();
            result = this.state.rasterTextBuffer.getWidth(this.state, this.bgc[this.currentBuffer], this.state.font, string);
        }
        return result;
    }

    public double glGetTextAscent() {
        this.setupRasterTextShadows();
        return this.state.rasterTextBuffer.getAscent(this.state, this.bgc[this.currentBuffer], this.state.font);
    }

    public double glGetTextDescent() {
        this.setupRasterTextShadows();
        return this.state.rasterTextBuffer.getDescent(this.state, this.bgc[this.currentBuffer], this.state.font);
    }

    public double glGetTextHeight() {
        this.setupRasterTextShadows();
        return this.state.rasterTextBuffer.getHeight(this.state, this.bgc[this.currentBuffer], this.state.font);
    }

    public double glGetTextHeight(String string) {
        this.setupRasterTextShadows();
        return this.state.rasterTextBuffer.getHeight(this.state, this.bgc[this.currentBuffer], this.state.font, string);
    }

    public void glVertex(double x, double y) {
        this.state.Vertex(x, y, 0.0);
    }

    public void glVertex(double x, double y, double z) {
        this.state.Vertex(x, y, z);
    }

    public void glNormal(double x, double y, double z) {
        this.state.Normal(x, y, z);
    }

    public void glColor(float r, float g, float b, float a) {
        this.state.Color(new Color(r, g, b), a);
    }

    public void glColor(Color color) {
        this.glColor(color, (float)color.getAlpha() / 255.0f);
    }

    public void glColor(Color color, float a) {
        if (color == null) {
            Debug.println((String)"Channel.glColor(): null color replaced by Color.black");
            color = Color.black;
        }
        this.state.Color(color, a);
    }

    public void glEdgeColor(Color color) {
        if (color == null) {
            Debug.println((String)"Channel.glEdgeColor(): null color replaced by Color.black");
            color = Color.black;
        }
        this.state.EdgeColor(color);
    }

    public void glColor(double r, double g, double b) {
        this.state.Color(new Color((float)r, (float)g, (float)b), 1.0f);
    }

    public void glEdgeColor(double r, double g, double b) {
        this.state.EdgeColor(new Color((float)r, (float)g, (float)b));
    }

    public void glFillPatternType(int type) {
        this.state.fillPatternType = type;
    }

    public void glFillPatternWidth(double width) {
        this.state.fillPatternWidth = (int)width;
    }

    public void glFillPatternScaleFactor(double scale) {
        this.state.fillPatternScaleFactor = scale;
    }

    public void glFillPatternColor(Color fpc) {
        this.state.fillPatternColor = fpc;
    }

    public void glBound() {
        this.state.Bound();
    }

    public void glRefresh(Rectangle area) {
        this.glRefresh(null, area);
    }

    public void glRefresh(Graphics graphics) {
        this.glRefresh(graphics, null);
    }

    public void glRefresh() {
        this.glRefresh(null, null);
    }

    public synchronized void glRefresh(Graphics graphics, Rectangle area) {
        Viewport viewport;
        if (this.refreshCount >= 0) {
            ++this.refreshCount;
        }
        if (graphics == null) {
            graphics = this.component.getGraphics();
        }
        if (area == null) {
            viewport = this.trans.GetViewport();
            area = this.tempRectangle;
            area.x = viewport.xo;
            area.y = viewport.yo;
            area.width = viewport.width;
            area.height = viewport.height;
        }
        viewport = this.trans.GetViewport();
        int xo = Math.max(viewport.xo, area.x);
        int yo = Math.max(viewport.yo, area.y);
        int x1 = Math.min(viewport.xo + viewport.width, area.x + area.width);
        int y1 = Math.min(viewport.yo + viewport.height, area.y + area.height);
        if (this.currentBuffer == 1) {
            this.updateMemoryImage();
        }
        if (this.backbuffer[this.currentBuffer] != null) {
            graphics.drawImage(this.backbuffer[this.currentBuffer], xo, yo, x1, y1, xo, yo, x1, y1, null);
        }
    }

    public void glCullFace(int mode) {
        this.state.CullFace(mode);
    }

    public void glFrontFace(int dir) {
        this.state.FrontFace(dir);
    }

    public void glPolygonOffset(float factor, float units) {
        this.state.PolygonOffset(factor, units);
    }

    public void glPolygonMode(int fill) {
        this.glPolygonMode(0, fill);
    }

    public void glPolygonMode(int face, int fill) {
        this.state.PolygonMode(face, fill);
    }

    public int getPolygonMode() {
        return this.state.getPolygonMode();
    }

    public boolean glRenderMode(int mode) {
        return this.state.RenderMode(mode);
    }

    public void glSelectBuffer(Stack buffer) {
        this.state.SelectBuffer(buffer);
    }

    public void glFeedbackBuffer(int type, Vector buffer) {
        this.state.feedbackBuffer(type, buffer);
    }

    public void gluPickMatrix(int curx, int cury, int width, int height) {
        Rectangle aperture = this.tempRectangle;
        aperture.x = curx;
        aperture.y = cury;
        aperture.width = width;
        aperture.height = height;
        Rectangle r = this.userClipRectangle == null ? this.viewportClipRectangle : this.userClipRectangle;
        aperture = aperture.intersection(r);
        this.state.PickMatrix(aperture.x, aperture.y, aperture.width, aperture.height);
    }

    public void glInitNames() {
        this.state.InitNames();
    }

    public void glPopName() {
        this.state.PopName();
    }

    public void glPushName(Object name) {
        this.state.PushName(name);
    }

    public void glLoadName(Object name) {
        this.state.LoadName(name);
    }

    public void glLight(int lightID, int pName, Color clr) {
        if (pName >= 0 && pName <= 2) {
            Point4 color = this.state.pt1;
            color.set((double)clr.getRed() / 255.0, (double)clr.getGreen() / 255.0, (double)clr.getBlue() / 255.0, 0.0);
            this.state.lightMgr.setLightParam(lightID, pName, color);
        }
    }

    public void glLight(int lightID, int pName, double[] param) {
        if (param.length > 0) {
            Point4 pm = this.state.pt1;
            if (param.length == 1) {
                this.glLight(lightID, pName, param[0]);
            } else if (param.length >= 4) {
                pm.set(param[0], param[1], param[2], param[3]);
            } else if (param.length == 3) {
                pm.set(param[0], param[1], param[2], 0.0);
            } else {
                pm.set(param[0], param[1], 0.0, 0.0);
            }
            this.state.lightMgr.setLightParam(lightID, pName, pm);
        }
    }

    public void glLight(int lightID, int pName, double param) {
        this.state.lightMgr.setLightParam(lightID, pName, param);
    }

    public void setClipBounds(Bbox aClipBbox) {
        this.state.SetClipBounds(aClipBbox);
    }

    public Bbox getClipBounds() {
        return this.state.GetClipBounds();
    }

    public void clearClipBounds() {
        this.state.ClearClipBounds();
    }

    public void setClip(Rectangle rectangle) {
        this.userClipRectangle = rectangle.intersection(this.viewportClipRectangle);
        this.setClip();
    }

    public void resetClip() {
        this.userClipRectangle = null;
        this.setClip();
    }

    private boolean backbufferReady() {
        if ((this.displayMode & 2) > 0) {
            return true;
        }
        if (this.backbuffer[this.currentBuffer] == null) {
            return false;
        }
        if (this.currentBuffer == 1) {
            return true;
        }
        return this.bgc[this.currentBuffer] != null;
    }

    public void glClear(int mask) {
        if ((mask & 1) == 1) {
            this.clearBGC();
        }
        if ((mask & 2) == 2) {
            this.clearZBuffer();
        }
    }

    public void clearBGC() {
        Viewport viewport = this.trans.GetViewport();
        this.tempRectangle.x = viewport.xo;
        this.tempRectangle.y = viewport.yo;
        this.tempRectangle.width = viewport.width;
        this.tempRectangle.height = viewport.height;
        this.clearBuffer(this.tempRectangle);
    }

    public void clearBuffer(double xo, double yo, double zo, double x1, double y1, double z1) {
        Point4 po = new Point4(xo, yo, zo, 1.0);
        this.trans.Object2Window(po);
        Point4 p1 = new Point4(x1, y1, z1, 1.0);
        this.trans.Object2Window(p1);
        this.tempRectangle.x = (int)po.x;
        this.tempRectangle.y = (int)po.y;
        this.tempRectangle.width = (int)(p1.x - po.x);
        this.tempRectangle.height = (int)(p1.y - po.y);
        this.clearBuffer(this.tempRectangle);
    }

    public synchronized void clearBuffer(Rectangle area) {
        if (!this.backbufferReady()) {
            return;
        }
        if (area == null) {
            this.clearBGC();
        }
        if (this.currentBuffer == 1) {
            this.clearSoftwareBuffer(this.backgroundColor, 1.0f);
        } else {
            this.bgc[this.currentBuffer].setColor(this.backgroundColor);
            this.bgc[this.currentBuffer].fillRect(area.x, area.y, area.width, area.height);
        }
        if (this.backgroundImage != null) {
            switch (this.backgroundImageStyle) {
                case 0: {
                    int h;
                    int w;
                    Viewport viewport = this.trans.GetViewport();
                    if (this.scaledBackgroundImage == null) {
                        this.scaledBackgroundImage = this.backgroundImage.getScaledInstance(viewport.width, viewport.height, 1);
                        MediaTracker mediaTracker = new MediaTracker(this.component);
                        mediaTracker.addImage(this.scaledBackgroundImage, 0);
                        try {
                            mediaTracker.waitForAll();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        w = this.scaledBackgroundImage.getWidth(this.component);
                        h = this.scaledBackgroundImage.getHeight(this.component);
                        if (w > 0 && h > 0 && (w != viewport.width || h != viewport.height)) {
                            this.scaledBackgroundImage = this.backgroundImage.getScaledInstance(viewport.width, viewport.height, 1);
                        }
                    }
                    if (this.currentBuffer == 1) {
                        w = this.scaledBackgroundImage.getWidth(this.component);
                        h = this.scaledBackgroundImage.getHeight(this.component);
                        this.grabPixels(this.scaledBackgroundImage, viewport.xo, viewport.yo, w, h, this.pixels, 0, this.maxwidth);
                        break;
                    }
                    this.bgc[this.currentBuffer].drawImage(this.scaledBackgroundImage, viewport.xo, viewport.yo, this.backgroundColor, this.component);
                    break;
                }
                case 1: {
                    int w = this.backgroundImage.getWidth(this.component);
                    int h = this.backgroundImage.getHeight(this.component);
                    if (!(w > 0 & h > 0)) break;
                    Viewport viewport = this.trans.GetViewport();
                    if (this.currentBuffer == 1) {
                        if (w > viewport.width) {
                            w = viewport.width;
                        }
                        if (h > viewport.height) {
                            h = viewport.height;
                        }
                        this.grabPixels(this.backgroundImage, 0, 0, w, h, this.pixels, 0, this.maxwidth);
                        for (int iy = 0; iy < viewport.height; iy += h) {
                            for (int ix = 0; ix < viewport.width; ix += w) {
                                if (ix == 0 && iy == 0) continue;
                                this.copyImage(this.pixels, 0, 0, w, h, ix, iy);
                            }
                        }
                    } else {
                        for (int iy = 0; iy < viewport.height; iy += h) {
                            for (int ix = 0; ix < viewport.width; ix += w) {
                                this.bgc[this.currentBuffer].drawImage(this.backgroundImage, ix, iy, this.backgroundColor, this.component);
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    int w = this.backgroundImage.getWidth(this.component);
                    int h = this.backgroundImage.getHeight(this.component);
                    if (!(w > 0 & h > 0)) break;
                    Viewport viewport = this.trans.GetViewport();
                    int x = (viewport.width - w) / 2;
                    int y = (viewport.height - h) / 2;
                    if (this.currentBuffer == 1) {
                        int imagex = 0;
                        int imagey = 0;
                        if (x < 0) {
                            imagex = -x;
                            x = 0;
                        }
                        if (y < 0) {
                            imagey = -y;
                            y = 0;
                        }
                        if (w > viewport.width) {
                            w = viewport.width;
                        }
                        if (h > viewport.height) {
                            h = viewport.height;
                        }
                        this.grabPixels(this.backgroundImage, imagex, imagey, w, h, this.pixels, this.maxwidth * y + x, this.maxwidth);
                        break;
                    }
                    this.bgc[this.currentBuffer].drawImage(this.backgroundImage, x, y, this.backgroundColor, this.component);
                    break;
                }
                case 3: {
                    int w = this.backgroundImage.getWidth(this.component);
                    int h = this.backgroundImage.getHeight(this.component);
                    if (!(w > 0 & h > 0)) break;
                    Viewport viewport = this.trans.GetViewport();
                    int x = this.backgroundImagePositionX;
                    int y = this.backgroundImagePositionY;
                    if (this.currentBuffer == 1) {
                        int imagex = 0;
                        int imagey = 0;
                        if (x < 0) {
                            imagex = -x;
                            x = 0;
                        }
                        if (y < 0) {
                            imagey = -y;
                            y = 0;
                        }
                        if (w > viewport.width) {
                            w = viewport.width;
                        }
                        if (h > viewport.height) {
                            h = viewport.height;
                        }
                        this.grabPixels(this.backgroundImage, imagex, imagey, w, h, this.pixels, this.maxwidth * y + x, this.maxwidth);
                        break;
                    }
                    this.bgc[this.currentBuffer].drawImage(this.backgroundImage, x, y, this.backgroundColor, this.component);
                    break;
                }
            }
        }
    }

    private void grabPixels(Image image, int x, int y, int w, int h, int[] pix, int offset, int scanWidth) {
        PixelGrabber pg = new PixelGrabber(image, x, y, w, h, pix, offset, scanWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < pix.length; ++i) {
            pix[i] = pix[i] | 0xFF000000;
        }
    }

    public void copyBuffer(int sourceId) {
        Viewport viewport = this.trans.GetViewport();
        Rectangle r = this.tempRectangle;
        r.x = viewport.xo;
        r.y = viewport.yo;
        r.width = viewport.width;
        r.height = viewport.height;
        this.copyBuffer(r, sourceId);
    }

    public void copyBuffer(Rectangle rect, int sourceId) {
        if (rect == null) {
            return;
        }
        int currentId = this.getBackbufferId();
        if (!this.backbufferReady()) {
            return;
        }
        this.setBackbuffer(sourceId);
        if (!this.backbufferReady()) {
            return;
        }
        this.setBackbuffer(currentId);
        int srcIndex = this.bufferIdToIndex(sourceId);
        if (this.currentBuffer == 1) {
            this.grabPixels(this.backbuffer[srcIndex], rect.x, rect.y, rect.width, rect.height, this.pixels, 0, this.maxwidth);
        } else {
            if (sourceId == -1) {
                this.updateMemoryImage();
            }
            this.bgc[this.currentBuffer].drawImage(this.backbuffer[srcIndex], rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, this.component);
        }
    }

    void updateMemoryImage() {
        Viewport viewport = this.trans.GetViewport();
        Rectangle r = this.tempRectangle;
        r.x = viewport.xo;
        r.y = viewport.yo;
        r.width = viewport.width;
        r.height = viewport.height;
        this.memoryImageSource.newPixels(r.x, r.y, r.width, r.height, false);
    }

    void updateMemoryImage(int x, int y, int width, int height) {
        if (x > this.maxwidth || y > this.maxheight) {
            return;
        }
        if (x + width > this.maxwidth) {
            width = this.maxwidth - x;
        }
        if (y + height > this.maxheight) {
            height = this.maxheight - y;
        }
        this.memoryImageSource.newPixels(x, y, width, height, false);
    }

    public void copyBuffer(double xo, double yo, double zo, double x1, double y1, double z1, int sourceId) {
        Point4 po = new Point4(xo, yo, zo, 1.0);
        this.trans.Object2Window(po);
        Point4 p1 = new Point4(x1, y1, z1, 1.0);
        this.trans.Object2Window(p1);
        Rectangle r = this.tempRectangle;
        r.x = (int)po.x;
        r.y = (int)po.y;
        r.width = (int)(p1.x - po.x);
        r.height = (int)(p1.y - po.y);
        this.copyBuffer(r, sourceId);
    }

    private int bufferIdToIndex(int id) {
        int index = id + 2;
        if (index < 0 || index >= this.backbufferCount) {
            throw new RuntimeException("Buffer Id is out of range.");
        }
        return index;
    }

    private int bufferIndexToId(int index) {
        return index - 2;
    }

    public void setBackbuffer(int id) {
        int index;
        if ((this.displayMode & 2) > 0) {
            return;
        }
        this.currentBuffer = index = this.bufferIdToIndex(id);
        this.allocateBackbuffer();
        this.setClip();
    }

    public void glLineStipple(int factor, int pattern) {
        this.state.setStipple(factor, pattern);
    }

    public void glLineWidth(float width) {
        this.state.lineWidth(width);
    }

    public void lineCapStyle(int capStyle) {
        this.setLineCapStyle(capStyle);
    }

    public void setLineCapStyle(int capStyle) {
        this.state.capStyle(capStyle);
    }

    public void setLineJoinStyle(int joinStyle) {
        this.state.joinStyle(joinStyle);
    }

    public int addCustomMarker(CustomMarkerInterface marker) {
        return this.state.addCustomMarker(marker);
    }

    public void setMarkerskin(Image markerImage) {
        this.state.markerSkin(markerImage);
    }

    public void setMarkerType(int markerType) {
        this.state.markerType(markerType);
    }

    public void setMarkerSize(int size) {
        this.state.markerSize(size);
    }

    public void setMarkerWeight(int edgeWeight) {
        if (edgeWeight != 0 && edgeWeight != 1 && edgeWeight != 2) {
            throw new IllegalArgumentException("Invalid edge weight");
        }
        this.state.setEdgeWeight(edgeWeight);
    }

    public void glPointSize(float size) {
        this.state.pointSize(size);
    }

    public void setShadowOffset(int x, int y) {
        this.state.setShadowOffset(x, y);
    }

    public void setShadowColor(Color color) {
        this.state.setShadowColor(color);
    }

    public void setShadowTransparency(float t) {
        this.state.setShadowTransparency(t);
    }

    public void setShadowSoftness(float t) {
        this.state.setShadowSoftness(t);
    }

    void allocateBackbuffer() {
        Image i;
        boolean imageNeedsUpdate = false;
        boolean zBufferOn = false;
        if (this.currentBuffer == 1) {
            Image i2 = this.backbuffer[1];
            int pixelCount = this.maxwidth * this.maxheight;
            boolean bl = imageNeedsUpdate = i2 == null || i2.getHeight(this.component) < this.maxheight || i2.getWidth(this.component) < this.maxwidth;
            if (imageNeedsUpdate) {
                this.pixels = new int[pixelCount];
                this.alpha = new float[pixelCount];
                this.memoryImageSource = new MemoryImageSource(this.maxwidth, this.maxheight, this.pixels, 0, this.maxwidth);
                this.memoryImageSource.setAnimated(true);
                this.clearSoftwareBuffer(Color.black, 1.0f);
                this.backbuffer[1] = i2 = this.component.createImage(this.memoryImageSource);
            }
            boolean bl2 = zBufferOn = (this.state.depthTestAlgorithm & 4) == 4;
            if (zBufferOn && (this.zbuffer == null || this.zbuffer.length < pixelCount)) {
                this.zbuffer = new double[this.maxwidth * this.maxheight];
            }
            this.bgc[this.currentBuffer] = this.state.softGraphics;
        } else if (this.currentBuffer != 0 && ((i = this.backbuffer[this.currentBuffer]) == null || i.getHeight(this.component) < this.maxheight || i.getWidth(this.component) < this.maxwidth) && (i = new BufferedImage(this.maxwidth, this.maxheight, 1)) != null) {
            this.backbuffer[this.currentBuffer] = i;
            this.bgc[this.currentBuffer] = i.getGraphics();
        }
    }

    protected void clearSoftwareBuffer(Color color, float a) {
        int pixelCount = this.maxwidth * this.maxheight;
        if (this.pixels == null || this.pixels.length < pixelCount) {
            this.allocateBackbuffer();
        }
        int pixel = this.isTransparentBackground() ? 0 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue() : 0xFF000000 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        for (int j = 0; j < this.maxwidth * this.maxheight; ++j) {
            this.alpha[j] = a;
            this.pixels[j] = pixel;
        }
    }

    protected void clearZBuffer() {
        if (this.state.isZBufferingOn) {
            int pixelCount = this.maxwidth * this.maxheight;
            if (this.zbuffer == null || this.zbuffer.length < pixelCount) {
                this.allocateBackbuffer();
            }
            if (this.zbuffer != null) {
                float depthClearValue = -3.4028235E38f;
                for (int i = 0; i < pixelCount; ++i) {
                    this.zbuffer[i] = depthClearValue;
                }
            }
        }
    }

    protected void setTexturePlant(boolean b) {
        this.texturePlant = b;
    }

    void setPixelType(int pixelType) {
        this.pixelType = pixelType;
    }

    void setMaxDepthSlope(double maxDepthSlope) {
        this.maxDepthSlope = maxDepthSlope;
    }

    protected void plant(int x, int y, double z, float As, float Rs, float Gs, float Bs) {
        int argb;
        float resultA;
        float resultB;
        float resultG;
        float resultR;
        int bits = 8;
        int index = x + this.maxwidth * y;
        Rectangle clipRect = this.getClip();
        if (x < 0 || y < 0 || x >= this.maxwidth || y >= this.maxheight || x < clipRect.x || y < clipRect.y || x >= clipRect.x + clipRect.width || y >= clipRect.y + clipRect.height) {
            return;
        }
        if (this.state.capabilities[4] && (this.state.depthTestAlgorithm & 4) == 4) {
            if (this.state.capabilities[16] && this.pixelType == 0 || this.state.capabilities[30] && this.pixelType == 1) {
                double r = 1.0E-4;
                double m = this.maxDepthSlope;
                double o = m * (double)this.state.polygonOffsetFactor + r * (double)this.state.polygonOffsetUnits;
                z -= o;
            }
            if (z < this.zbuffer[index]) {
                return;
            }
            this.zbuffer[index] = z;
        }
        if (this.texturePlant) {
            int rgb = this.pixels[index];
            float Rd = (float)(rgb >> 2 * bits & 0xFF) / 255.0f;
            float Gd = (float)(rgb >> bits & 0xFF) / 255.0f;
            float Bd = (float)(rgb & 0xFF) / 255.0f;
            float Ad = this.alpha[index];
            resultR = Rd * Rs;
            resultG = Gd * Gs;
            resultB = Bd * Bs;
            resultA = Ad * As;
        } else if (As < 1.0f && (this.state.capabilities[12] || this.state.capabilities[13])) {
            int rgb = this.pixels[index];
            float Rd = (float)(rgb >> 2 * bits & 0xFF) / 255.0f;
            float Gd = (float)(rgb >> bits & 0xFF) / 255.0f;
            float Bd = (float)(rgb & 0xFF) / 255.0f;
            float Ad = this.alpha[index];
            float Sr = As;
            float Sg = As;
            float Sb = As;
            float Sa = As;
            float Dr = 1.0f - As;
            float Dg = 1.0f - As;
            float Db = 1.0f - As;
            float Da = 1.0f - As;
            resultR = Rs * Sr + Rd * Dr;
            resultG = Gs * Sg + Gd * Dg;
            resultB = Bs * Sb + Bd * Db;
            resultA = As * Sa + Ad * Da;
        } else {
            resultR = Rs;
            resultG = Gs;
            resultB = Bs;
            resultA = As;
        }
        if (resultR > 1.0f) {
            resultR = 1.0f;
        }
        if (resultR < 0.0f) {
            resultR = 0.0f;
        }
        if (resultG > 1.0f) {
            resultG = 1.0f;
        }
        if (resultG < 0.0f) {
            resultG = 0.0f;
        }
        if (resultB > 1.0f) {
            resultB = 1.0f;
        }
        if (resultB < 0.0f) {
            resultB = 0.0f;
        }
        if (resultA > 1.0f) {
            resultA = 1.0f;
        }
        if (resultA < 0.0f) {
            resultA = 0.0f;
        }
        this.pixels[index] = argb = 0xFF000000 | (int)((double)resultR * 255.0) << 2 * bits | (int)((double)resultG * 255.0) << bits | (int)((double)resultB * 255.0);
        this.alpha[index] = resultA;
    }

    protected void plant(int x, int y, double z, int argb) {
        int index = x + this.maxwidth * y;
        Rectangle clipRect = this.getClip();
        if (x < 0 || y < 0 || x >= this.maxwidth || y >= this.maxheight || x < clipRect.x || y < clipRect.y || x >= clipRect.x + clipRect.width || y >= clipRect.y + clipRect.height) {
            return;
        }
        if (this.state.isZBufferingOn) {
            if (z < this.zbuffer[index]) {
                return;
            }
            this.zbuffer[index] = z;
        }
        this.pixels[index] = argb;
    }

    public double[] glGetDoublev(int pname) {
        double[] r;
        switch (pname) {
            case 0: {
                r = this.trans.getViewport();
                break;
            }
            default: {
                throw new IllegalArgumentException("glGetDoublev() Unknown pname: " + pname);
            }
        }
        return r;
    }

    public int[] glGetIntegerv(int pname) {
        int[] r;
        switch (pname) {
            case 1: {
                r = new int[]{this.state.render_mode};
                break;
            }
            default: {
                throw new IllegalArgumentException("glGetIntegerv() Unknown pname: " + pname);
            }
        }
        return r;
    }

    private void copyImage(int[] image, int sourceX, int sourceY, int width, int height, int targetX, int targetY) {
        int end = Math.min(height, this.maxheight - targetY);
        for (int i = 0; i < end; ++i) {
            int sourceIndex = sourceX + this.maxwidth * i + sourceY * this.maxwidth;
            int targetIndex = targetX + this.maxwidth * i + targetY * this.maxwidth;
            int length = Math.min(width, this.maxwidth - targetX);
            System.arraycopy(image, sourceIndex, image, targetIndex, length);
        }
    }

    public void enableRefreshCount() {
        this.refreshCount = 0;
    }

    public void disableRefreshCount() {
        this.refreshCount = -1;
    }

    public void resetRefreshCount() {
        this.refreshCount = 0;
    }

    public int getRefreshCount() {
        return this.refreshCount;
    }

    public boolean isDisplayListOpen() {
        return this.state.isDisplayListOpen();
    }

    public void glMarker(double x, double y, double z) {
        this.state.Marker(x, y, z);
    }

    public boolean getVertexHasBeenClamped() {
        return this.state.getVertexHasBeenClamped();
    }

    public void setMinScaleValue(double d) {
        this.trans.setMinScaleValue(d);
    }

    public double getMinScaleValue() {
        return this.trans.getMinScaleValue();
    }

    public void glColorGradient(ColorGradient cg) {
        this.state.colorGradient = cg;
    }

    public void glDPIScaleFactor(float fac) {
        this.state.DPIScaleFactor = fac;
    }

    public void glSkinType(int type) {
        this.state.skinType = type;
    }

    public void glSkinImage(Image img) {
        this.state.skinImage = img;
    }

    public void glPixelBenderImages(Image[] imgs) {
        this.state.pixelBenderImages = imgs;
    }

    public void glSkinCategory(int cat) {
        this.state.skinCategory = cat;
    }

    public void glSkinRenderMode(int mode) {
        this.state.skinRenderMode = mode;
    }

    public void glCacheSkinFilters(boolean b) {
        this.state.cacheSkinFilters = b;
    }

    public void clearSkinFilterCache() {
        this.state.skinFilterMap.clear();
    }

    public void setSubpixelRendering(boolean b) {
        this.state.subpixelRendering = b;
    }

    public boolean isSubpixelRendering() {
        return this.state.subpixelRendering;
    }

    public boolean isSVGSelectionMode() {
        return this.state.render_mode == 3;
    }

    public void setSVGSelectionText(String[] text) {
        this.setSVGSelectionText(text, true);
    }

    public void setSVGSelectionText(String[] text, boolean clearText) {
        this.state.SVGSelectionText = text;
        this.state.clearSVGSelectionText = clearText;
    }

    public String[] getSVGSelectionText() {
        return this.state.SVGSelectionText;
    }

    public void clearSVGSelectionText() {
        this.state.SVGSelectionText = null;
    }

    public void setOutlinedRasterLabel(boolean b) {
        this.state.outlinedRasterLabel = b;
    }

    public boolean isOutlinedRasterLabel() {
        return this.state.outlinedRasterLabel;
    }

    public void setRasterLabelBacklight(double l) {
        this.state.rasterLabelBacklight = l;
    }

    public double getRasterLabelBacklight() {
        return this.state.rasterLabelBacklight;
    }

    public void setRasterLabelOutlineWidth(int w) {
        this.state.rasterLabelOutlineWidth = w;
    }

    public int getRasterLabelOutlineWidth() {
        return this.state.rasterLabelOutlineWidth;
    }

    public void setMaximumProjectionArea(Rectangle area) {
        this.maximumProjectionArea = area;
    }

    public Rectangle getMaximumProjectionArea() {
        return this.maximumProjectionArea;
    }

    public Insets getRasterBackgroundPad() {
        return this.rasterBackgroundPad;
    }

    public void setRasterBackgroundPad(Insets rasterBackgroundPad) {
        this.rasterBackgroundPad = rasterBackgroundPad;
    }

    public void setKeepOrginalAlignments(boolean b) {
        this.state.keepOriginalAlignments = b;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public void setDrawPolyOutline(boolean polyOutline) {
        this.state.drawPolyOutline = polyOutline;
    }

    public boolean isDrawPolyOutline() {
        return this.state.drawPolyOutline;
    }

    public void setSVGRendering(boolean b) {
        this.state.SVGRendering = b;
    }

    public boolean isSVGRendering() {
        return this.state.SVGRendering;
    }

    static class myComponentAdapter
    extends ComponentAdapter {
        private Channel container;

        public myComponentAdapter(Channel container) {
            this.container = container;
        }

        @Override
        public void componentShown(ComponentEvent event) {
            this.container.allocateBackbuffer();
        }
    }
}

