/*
 * Decompiled with CFR 0.152.
 */
package com.sas.antlr.build;

import com.sas.antlr.build.StreamScarfer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;

public class Tool {
    public String os = System.getProperty("os.name");

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: java antlr.build.Tool action");
            return;
        }
        String app = "antlr.build.ANTLR";
        String action = args[0];
        Tool t = new Tool();
        t.perform(app, action);
    }

    public void perform(String app, String action) {
        if (app == null || action == null) {
            this.error("missing app or action");
            return;
        }
        Class<?> c = null;
        Method m = null;
        Object appObj = null;
        try {
            c = Class.forName(app);
            appObj = c.newInstance();
        }
        catch (Exception e) {
            try {
                if (!app.startsWith("antlr.build.")) {
                    c = Class.forName("antlr.build." + app);
                }
                this.error("no such application " + app, e);
            }
            catch (Exception e2) {
                this.error("no such application " + app, e2);
            }
        }
        if (c == null || appObj == null) {
            return;
        }
        try {
            m = c.getMethod(action, Tool.class);
            m.invoke(appObj, this);
        }
        catch (Exception e) {
            this.error("no such action for application " + app, e);
        }
    }

    public void system(String cmd) {
        Runtime rt = Runtime.getRuntime();
        try {
            this.log(cmd);
            Process proc = null;
            proc = !this.os.startsWith("Windows") ? rt.exec(new String[]{"sh", "-c", cmd}) : rt.exec(cmd);
            StreamScarfer stderrScarfer = new StreamScarfer(proc.getErrorStream(), "stderr", this);
            StreamScarfer stdoutScarfer = new StreamScarfer(proc.getInputStream(), "stdout", this);
            stderrScarfer.start();
            stdoutScarfer.start();
            int n = proc.waitFor();
        }
        catch (Exception e) {
            this.error("cannot exec " + cmd, e);
        }
    }

    public void antlr(String fullyQualifiedFilename) {
        String path = null;
        try {
            path = new File(fullyQualifiedFilename).getParent();
            if (path != null) {
                path = new File(path).getCanonicalPath();
            }
        }
        catch (IOException ioe) {
            this.error("Invalid grammar file: " + fullyQualifiedFilename);
        }
        if (path != null) {
            this.log("java antlr.Tool -o " + path + " " + fullyQualifiedFilename);
            com.sas.antlr.Tool theTool = new com.sas.antlr.Tool();
            theTool.doEverything(new String[]{"-o", path, fullyQualifiedFilename});
        }
    }

    public void stdout(String s) {
        System.out.println(s);
    }

    public void stderr(String s) {
        System.err.println(s);
    }

    public void error(String msg) {
        System.err.println("antlr.build.Tool: " + msg);
    }

    public void log(String cmd) {
        System.out.println("executing: " + cmd);
    }

    public void error(String msg, Exception e) {
        System.err.println("antlr.build.Tool: " + msg);
        e.printStackTrace(System.err);
    }
}

