/*
 * Decompiled with CFR 0.152.
 */
package com.sas.antlr;

import com.sas.antlr.TokenManager;
import com.sas.antlr.TokenSymbol;
import com.sas.antlr.Tool;
import com.sas.antlr.collections.impl.Vector;
import java.util.Enumeration;
import java.util.Hashtable;

class SimpleTokenManager
implements TokenManager,
Cloneable {
    protected int maxToken = 4;
    protected Vector vocabulary;
    private Hashtable table;
    protected Tool antlrTool;
    protected String name;
    protected boolean readOnly = false;

    SimpleTokenManager(String name_, Tool tool_) {
        this.antlrTool = tool_;
        this.name = name_;
        this.vocabulary = new Vector(1);
        this.table = new Hashtable();
        TokenSymbol ts = new TokenSymbol("EOF");
        ts.setTokenType(1);
        this.define(ts);
        this.vocabulary.ensureCapacity(3);
        this.vocabulary.setElementAt("NULL_TREE_LOOKAHEAD", 3);
    }

    @Override
    public Object clone() {
        SimpleTokenManager tm;
        try {
            tm = (SimpleTokenManager)super.clone();
            tm.vocabulary = (Vector)this.vocabulary.clone();
            tm.table = (Hashtable)this.table.clone();
            tm.maxToken = this.maxToken;
            tm.antlrTool = this.antlrTool;
            tm.name = this.name;
        }
        catch (CloneNotSupportedException e) {
            this.antlrTool.panic("cannot clone token manager");
            return null;
        }
        return tm;
    }

    @Override
    public void define(TokenSymbol ts) {
        this.vocabulary.ensureCapacity(ts.getTokenType());
        this.vocabulary.setElementAt(ts.getId(), ts.getTokenType());
        this.mapToTokenSymbol(ts.getId(), ts);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTokenStringAt(int idx) {
        return (String)this.vocabulary.elementAt(idx);
    }

    @Override
    public TokenSymbol getTokenSymbol(String sym) {
        return (TokenSymbol)this.table.get(sym);
    }

    @Override
    public TokenSymbol getTokenSymbolAt(int idx) {
        return this.getTokenSymbol(this.getTokenStringAt(idx));
    }

    @Override
    public Enumeration getTokenSymbolElements() {
        return this.table.elements();
    }

    @Override
    public Enumeration getTokenSymbolKeys() {
        return this.table.keys();
    }

    @Override
    public Vector getVocabulary() {
        return this.vocabulary;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mapToTokenSymbol(String name, TokenSymbol sym) {
        this.table.put(name, sym);
    }

    @Override
    public int maxTokenType() {
        return this.maxToken - 1;
    }

    @Override
    public int nextTokenType() {
        return this.maxToken++;
    }

    @Override
    public void setName(String name_) {
        this.name = name_;
    }

    @Override
    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    @Override
    public boolean tokenDefined(String symbol) {
        return this.table.containsKey(symbol);
    }
}

