/*
 * Decompiled with CFR 0.152.
 */
package com.sas.antlr;

import com.sas.antlr.AlternativeBlock;
import com.sas.antlr.ExceptionSpec;
import com.sas.antlr.Grammar;
import com.sas.antlr.LexerGrammar;
import com.sas.antlr.Lookahead;
import com.sas.antlr.ParserGrammar;
import com.sas.antlr.RuleEndElement;
import com.sas.antlr.Token;
import com.sas.antlr.TokenSymbol;
import com.sas.antlr.collections.impl.Vector;
import java.util.Hashtable;

public class RuleBlock
extends AlternativeBlock {
    protected String ruleName;
    protected String argAction = null;
    protected String throwsSpec = null;
    protected String returnAction = null;
    protected RuleEndElement endNode;
    protected boolean testLiterals = false;
    Vector labeledElements;
    protected boolean[] lock;
    protected Lookahead[] cache;
    Hashtable exceptionSpecs;
    protected boolean defaultErrorHandler = true;
    protected String ignoreRule = null;

    public RuleBlock(Grammar g, String r) {
        super(g);
        this.ruleName = r;
        this.labeledElements = new Vector();
        this.cache = new Lookahead[g.maxk + 1];
        this.exceptionSpecs = new Hashtable();
        this.setAutoGen(g instanceof ParserGrammar);
    }

    public RuleBlock(Grammar g, String r, int line, boolean doAutoGen_) {
        this(g, r);
        this.line = line;
        this.setAutoGen(doAutoGen_);
    }

    public void addExceptionSpec(ExceptionSpec ex) {
        if (this.findExceptionSpec(ex.label) != null) {
            if (ex.label != null) {
                this.grammar.antlrTool.error("Rule '" + this.ruleName + "' already has an exception handler for label: " + ex.label);
            } else {
                this.grammar.antlrTool.error("Rule '" + this.ruleName + "' already has an exception handler");
            }
        } else {
            this.exceptionSpecs.put(ex.label == null ? "" : ex.label.getText(), ex);
        }
    }

    public ExceptionSpec findExceptionSpec(Token label) {
        return (ExceptionSpec)this.exceptionSpecs.get(label == null ? "" : label.getText());
    }

    public ExceptionSpec findExceptionSpec(String label) {
        return (ExceptionSpec)this.exceptionSpecs.get(label == null ? "" : label);
    }

    @Override
    public void generate() {
        this.grammar.generator.gen(this);
    }

    public boolean getDefaultErrorHandler() {
        return this.defaultErrorHandler;
    }

    public RuleEndElement getEndElement() {
        return this.endNode;
    }

    public String getIgnoreRule() {
        return this.ignoreRule;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public boolean getTestLiterals() {
        return this.testLiterals;
    }

    public boolean isLexerAutoGenRule() {
        return this.ruleName.equals("nextToken");
    }

    @Override
    public Lookahead look(int k) {
        return this.grammar.theLLkAnalyzer.look(k, this);
    }

    @Override
    public void prepareForAnalysis() {
        super.prepareForAnalysis();
        this.lock = new boolean[this.grammar.maxk + 1];
    }

    public void setDefaultErrorHandler(boolean value) {
        this.defaultErrorHandler = value;
    }

    public void setEndElement(RuleEndElement re) {
        this.endNode = re;
    }

    @Override
    public void setOption(Token key, Token value) {
        if (key.getText().equals("defaultErrorHandler")) {
            if (value.getText().equals("true")) {
                this.defaultErrorHandler = true;
            } else if (value.getText().equals("false")) {
                this.defaultErrorHandler = false;
            } else {
                this.grammar.antlrTool.error("Value for defaultErrorHandler must be true or false", this.grammar.getFilename(), key.getLine(), key.getColumn());
            }
        } else if (key.getText().equals("testLiterals")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.antlrTool.error("testLiterals option only valid for lexer rules", this.grammar.getFilename(), key.getLine(), key.getColumn());
            } else if (value.getText().equals("true")) {
                this.testLiterals = true;
            } else if (value.getText().equals("false")) {
                this.testLiterals = false;
            } else {
                this.grammar.antlrTool.error("Value for testLiterals must be true or false", this.grammar.getFilename(), key.getLine(), key.getColumn());
            }
        } else if (key.getText().equals("ignore")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.antlrTool.error("ignore option only valid for lexer rules", this.grammar.getFilename(), key.getLine(), key.getColumn());
            } else {
                this.ignoreRule = value.getText();
            }
        } else if (key.getText().equals("paraphrase")) {
            if (!(this.grammar instanceof LexerGrammar)) {
                this.grammar.antlrTool.error("paraphrase option only valid for lexer rules", this.grammar.getFilename(), key.getLine(), key.getColumn());
            } else {
                TokenSymbol ts = this.grammar.tokenManager.getTokenSymbol(this.ruleName);
                if (ts == null) {
                    this.grammar.antlrTool.panic("cannot find token associated with rule " + this.ruleName);
                }
                ts.setParaphrase(value.getText());
            }
        } else if (key.equals("generateAmbigWarnings")) {
            if (value.getText().equals("true")) {
                this.generateAmbigWarnings = true;
            } else if (value.getText().equals("false")) {
                this.generateAmbigWarnings = false;
            } else {
                this.grammar.antlrTool.error("Value for generateAmbigWarnings must be true or false", this.grammar.getFilename(), key.getLine(), key.getColumn());
            }
        } else {
            this.grammar.antlrTool.error("Invalid rule option: " + key.getText(), this.grammar.getFilename(), key.getLine(), key.getColumn());
        }
    }

    @Override
    public String toString() {
        String s = " FOLLOW={";
        Lookahead[] cache = this.endNode.cache;
        int k = this.grammar.maxk;
        boolean allNull = true;
        for (int j = 1; j <= k; ++j) {
            if (cache[j] == null) continue;
            s = s + cache[j].toString(",", this.grammar.tokenManager.getVocabulary());
            allNull = false;
            if (j >= k || cache[j + 1] == null) continue;
            s = s + ";";
        }
        s = s + "}";
        if (allNull) {
            s = "";
        }
        return this.ruleName + ": " + super.toString() + " ;" + s;
    }
}

