/*
 * Decompiled with CFR 0.152.
 */
package com.sas.antlr;

import com.sas.antlr.ActionElement;
import com.sas.antlr.ActionTransInfo;
import com.sas.antlr.Alternative;
import com.sas.antlr.AlternativeBlock;
import com.sas.antlr.AlternativeElement;
import com.sas.antlr.BlockEndElement;
import com.sas.antlr.CharLiteralElement;
import com.sas.antlr.CharRangeElement;
import com.sas.antlr.CodeGenerator;
import com.sas.antlr.Grammar;
import com.sas.antlr.GrammarAtom;
import com.sas.antlr.GrammarSymbol;
import com.sas.antlr.JavaCharFormatter;
import com.sas.antlr.LexerGrammar;
import com.sas.antlr.Lookahead;
import com.sas.antlr.MakeGrammar;
import com.sas.antlr.OneOrMoreBlock;
import com.sas.antlr.ParserGrammar;
import com.sas.antlr.RuleBlock;
import com.sas.antlr.RuleRefElement;
import com.sas.antlr.RuleSymbol;
import com.sas.antlr.StringLiteralElement;
import com.sas.antlr.SynPredBlock;
import com.sas.antlr.TokenManager;
import com.sas.antlr.TokenRangeElement;
import com.sas.antlr.TokenRefElement;
import com.sas.antlr.Tool;
import com.sas.antlr.TreeElement;
import com.sas.antlr.TreeWalkerGrammar;
import com.sas.antlr.WildcardElement;
import com.sas.antlr.ZeroOrMoreBlock;
import com.sas.antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;

public class HTMLCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;
    protected boolean firstElementInAlt;
    protected AlternativeElement prevAltElem = null;

    public HTMLCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    static String HTMLEncode(String s) {
        StringBuffer buf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (c == '\'') {
                buf.append("&#039;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @Override
    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setCodeGenerator(this);
                g.generate();
                if (!this.antlrTool.hasError()) continue;
                this.antlrTool.fatalError("Exiting due to errors.");
            }
        }
        catch (IOException e) {
            this.antlrTool.reportException(e, null);
        }
    }

    @Override
    public void gen(ActionElement action) {
    }

    @Override
    public void gen(AlternativeBlock blk) {
        this.genGenericBlock(blk, "");
    }

    @Override
    public void gen(BlockEndElement end) {
    }

    @Override
    public void gen(CharLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(HTMLCodeGenerator.HTMLEncode(atom.atomText) + " ");
    }

    @Override
    public void gen(CharRangeElement r) {
        this.print(r.beginText + ".." + r.endText + " ");
    }

    @Override
    public void gen(LexerGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + TokenTypesFileExt);
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + TokenTypesFileExt);
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("Definition of lexer " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
        this.genNextToken();
        Enumeration ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol rs = (RuleSymbol)ids.nextElement();
            if (rs.id.equals("mnextToken")) continue;
            this.genRule(rs);
        }
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    @Override
    public void gen(OneOrMoreBlock blk) {
        this.genGenericBlock(blk, "+");
    }

    @Override
    public void gen(ParserGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("Definition of parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.genTail();
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public void gen(RuleRefElement rr) {
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        this._print("<a href=\"" + this.grammar.getClassName() + ".html#" + rr.targetRule + "\">");
        this._print(rr.targetRule);
        this._print("</a>");
        this._print(" ");
    }

    @Override
    public void gen(StringLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(HTMLCodeGenerator.HTMLEncode(atom.atomText));
        this._print(" ");
    }

    @Override
    public void gen(TokenRangeElement r) {
        this.print(r.beginText + ".." + r.endText + " ");
    }

    @Override
    public void gen(TokenRefElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(atom.atomText);
        this._print(" ");
    }

    @Override
    public void gen(TreeElement t) {
        this.print(t + " ");
    }

    @Override
    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("");
        if (this.grammar.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("Definition of tree parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
        this.println("");
        ++this.tabs;
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public void gen(WildcardElement wc) {
        this._print(". ");
    }

    @Override
    public void gen(ZeroOrMoreBlock blk) {
        this.genGenericBlock(blk, "*");
    }

    protected void genAlt(Alternative alt) {
        if (alt.getTreeSpecifier() != null) {
            this._print(alt.getTreeSpecifier().getText());
        }
        this.prevAltElem = null;
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            this.firstElementInAlt = false;
            this.prevAltElem = elem;
            elem = elem.next;
        }
    }

    public void genCommonBlock(AlternativeBlock blk) {
        for (int i = 0; i < blk.alternatives.size(); ++i) {
            Alternative alt = blk.getAlternativeAt(i);
            AlternativeElement elem = alt.head;
            if (i > 0 && blk.alternatives.size() > 1) {
                this._println("");
                this.print("|\t");
            }
            boolean save = this.firstElementInAlt;
            this.firstElementInAlt = true;
            ++this.tabs;
            this.genAlt(alt);
            --this.tabs;
            this.firstElementInAlt = save;
        }
    }

    public void genFollowSetForRuleBlock(RuleBlock blk) {
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, blk.endNode);
        this.printSet(this.grammar.maxk, 1, follow);
    }

    protected void genGenericBlock(AlternativeBlock blk, String blkOp) {
        if (blk.alternatives.size() > 1) {
            if (!this.firstElementInAlt) {
                if (this.prevAltElem == null || !(this.prevAltElem instanceof AlternativeBlock) || ((AlternativeBlock)this.prevAltElem).alternatives.size() == 1) {
                    this._println("");
                    this.print("(\t");
                } else {
                    this._print("(\t");
                }
            } else {
                this._print("(\t");
            }
        } else {
            this._print("( ");
        }
        this.genCommonBlock(blk);
        if (blk.alternatives.size() > 1) {
            this._println("");
            this.print(")" + blkOp + " ");
            if (!(blk.next instanceof BlockEndElement)) {
                this._println("");
                this.print("");
            }
        } else {
            this._print(")" + blkOp + " ");
        }
    }

    protected void genHeader() {
        this.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.println("<HTML>");
        this.println("<HEAD>");
        this.println("<TITLE>Grammar " + this.antlrTool.grammarFile + "</TITLE>");
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<table summary=\"\" border=\"1\" cellpadding=\"5\">");
        this.println("<tr>");
        this.println("<td>");
        this.println("<font size=\"+2\">Grammar " + this.grammar.getClassName() + "</font><br>");
        this.println("<a href=\"http://www.ANTLR.org\">ANTLR</a>-generated HTML file from " + this.antlrTool.grammarFile);
        this.println("<p>");
        this.println("Terence Parr, <a href=\"http://www.magelang.com\">MageLang Institute</a>");
        this.println("<br>ANTLR Version " + Tool.version + "; 1989-1999");
        this.println("</td>");
        this.println("</tr>");
        this.println("</table>");
        this.println("<PRE>");
    }

    protected void genLookaheadSetForAlt(Alternative alt) {
        if (this.doingLexRules && alt.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        for (int i = 1; i <= depth; ++i) {
            Lookahead lookahead = alt.cache[i];
            this.printSet(depth, i, lookahead);
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock blk) {
        int i;
        int depth = 0;
        for (i = 0; i < blk.alternatives.size(); ++i) {
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.lookaheadDepth == Integer.MAX_VALUE) {
                depth = this.grammar.maxk;
                break;
            }
            if (depth >= alt.lookaheadDepth) continue;
            depth = alt.lookaheadDepth;
        }
        for (i = 1; i <= depth; ++i) {
            Lookahead lookahead = this.grammar.theLLkAnalyzer.look(i, blk);
            this.printSet(depth, i, lookahead);
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("/** Lexer nextToken rule:");
        this.println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
        this.println(" *  lexer rules.  It logically consists of one big alternative block with");
        this.println(" *  each user-defined rule being an alternative.");
        this.println(" */");
        RuleBlock blk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(blk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        this.genCommonBlock(blk);
    }

    public void genRule(RuleSymbol s) {
        if (s == null || !s.isDefined()) {
            return;
        }
        this.println("");
        if (s.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(s.comment));
        }
        if (s.access.length() != 0 && !s.access.equals("public")) {
            this._print(s.access + " ");
        }
        this._print("<a name=\"" + s.getId() + "\">");
        this._print(s.getId());
        this._print("</a>");
        RuleBlock rblk = s.getBlock();
        this._println("");
        ++this.tabs;
        this.print(":\t");
        this.genCommonBlock(rblk);
        this._println("");
        this.println(";");
        --this.tabs;
    }

    protected void genSynPred(SynPredBlock blk) {
        ++this.syntacticPredLevel;
        this.genGenericBlock(blk, " =>");
        --this.syntacticPredLevel;
    }

    public void genTail() {
        this.println("</PRE>");
        this.println("</BODY>");
        this.println("</HTML>");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.antlrTool.reportProgress("Generating " + tm.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
        this.currentOutput = this.antlrTool.openOutputFile(tm.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        for (int i = 4; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (s == null) continue;
            this.println(s + " = " + i);
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    @Override
    public String getASTCreateString(Vector v) {
        return null;
    }

    @Override
    public String getASTCreateString(GrammarAtom atom, String str) {
        return null;
    }

    @Override
    public String mapTreeId(String id, ActionTransInfo tInfo) {
        return id;
    }

    @Override
    protected String processActionForSpecialSymbols(String actionStr, int line, RuleBlock currentRule, ActionTransInfo tInfo) {
        return actionStr;
    }

    public void printSet(int depth, int k, Lookahead lookahead) {
        int numCols = 5;
        int[] elems = lookahead.fset.toArray();
        if (depth != 1) {
            this.print("k==" + k + ": {");
        } else {
            this.print("{ ");
        }
        if (elems.length > numCols) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int column = 0;
        for (int i = 0; i < elems.length; ++i) {
            if (++column > numCols) {
                this._println("");
                this.print("");
                column = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(elems[i]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(elems[i]));
            }
            if (i == elems.length - 1) continue;
            this._print(", ");
        }
        if (elems.length > numCols) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

