/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MetadataResource {
    protected static Hashtable m_bundleCache;
    protected boolean m_bResourceFileMissing = false;
    protected String m_strResourceFileName;
    protected ResourceBundle m_bundle;

    public MetadataResource(String strResourceFileName) {
        this.m_bundle = this._getBundle(strResourceFileName);
    }

    public MetadataResource(Class source) {
        String strClassName = source.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        this.m_bundle = this._getBundle(strPackageName + ".PropertyBundle");
    }

    protected ResourceBundle getCachedBundle(String key) {
        if (m_bundleCache == null) {
            m_bundleCache = new Hashtable();
        }
        return (ResourceBundle)m_bundleCache.get(key);
    }

    protected void cacheBundle(String key, ResourceBundle bundle) {
        m_bundleCache.put(key, bundle);
    }

    protected ResourceBundle _getBundle(String strBundlePath) {
        ResourceBundle returnValue = this.getCachedBundle(strBundlePath);
        if (returnValue != null) {
            return returnValue;
        }
        Locale locale = Locale.getDefault();
        try {
            returnValue = ResourceBundle.getBundle(strBundlePath, locale);
        }
        catch (Exception e) {
            try {
                returnValue = PropertyResourceBundle.getBundle(strBundlePath, locale);
            }
            catch (Exception e2) {
                this.m_bResourceFileMissing = true;
                return null;
            }
        }
        this.cacheBundle(strBundlePath, returnValue);
        this.m_strResourceFileName = strBundlePath;
        return returnValue;
    }

    public String getString(String key) {
        String retValue = "";
        if (this.m_bundle != null && key != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
            }
            catch (MissingResourceException e) {
                retValue = "Missing resource " + key;
                System.err.println(retValue + ". Have you copied your resources?");
                System.err.println("Missing resource is called from the following:");
                e.printStackTrace();
            }
        }
        return retValue;
    }

    public String getRawString(String key) {
        String retValue = null;
        if (this.m_bundle != null && !this.m_bResourceFileMissing) {
            try {
                retValue = this.m_bundle.getString(key);
                retValue = retValue.trim();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int notFoundReturnValue) {
        try {
            String strValue = this.m_bundle.getString(key);
            return Integer.parseInt(strValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return notFoundReturnValue;
        }
    }

    public byte[] convertHexStringToByteArray(String strValue) {
        byte[] byteArray = new byte[strValue.length() / 2];
        int byteIndex = 0;
        int length = strValue.length();
        byte[] charArray = strValue.getBytes();
        for (int index = 0; index < length; index += 2) {
            byteArray[byteIndex++] = this.convertHexCharsToByte(charArray[index], charArray[index + 1]);
        }
        return byteArray;
    }

    protected byte convertHexCharsToByte(byte leftChar, byte rightChar) {
        int result = 0;
        boolean negative = false;
        int digit = leftChar >= 65 ? leftChar - 65 + 10 : leftChar - 48;
        result = -digit;
        digit = rightChar >= 65 ? rightChar - 65 + 10 : rightChar - 48;
        result *= 16;
        result -= digit;
        if (negative) {
            return (byte)result;
        }
        return (byte)(-result);
    }

    public String messageString(String key) {
        String pattern = this.getString(key);
        return pattern;
    }

    public String messageString(String key, Object parm1) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString()};
        return MessageFormat.format(pattern, args);
    }

    public String messageString(String key, Object parm1, Object parm2, Object parm3, Object parm4, Object parm5, Object parm6) {
        String pattern = this.getString(key);
        Object[] args = new Object[]{parm1.toString(), parm2.toString(), parm3.toString(), parm4.toString(), parm5.toString(), parm6.toString()};
        return MessageFormat.format(pattern, args);
    }

    public Enumeration getKeys() {
        return this.m_bundle.getKeys();
    }
}

