/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata;

import com.sas.metadata.AssociationList;
import com.sas.metadata.CMetadata;
import com.sas.metadata.MapPool;
import com.sas.metadata.MdAbstractHandler;
import com.sas.metadata.MdObjectAttribute;
import com.sas.metadata.MdObjectAttributePool;
import com.sas.metadata.MdObjectFactory;
import com.sas.metadata.MdSAXStackAssocProperty;
import com.sas.metadata.MdStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MdGetObjectHandler
extends MdAbstractHandler {
    static final String metadata_tag = "Metadata";
    static final String objects_tag = "Objects";
    List objectsCreated = new ArrayList();
    List rootLevelObjects = new ArrayList();
    ArrayList stackObjects = new ArrayList();
    Stack assocObjectStack = new Stack();
    boolean inAssoc = false;
    boolean processing_metadata_object = false;
    MdStore store = null;

    public MdGetObjectHandler(MdStore store, SAXParserFactory factory) {
        super(factory);
        this.store = store;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.processing_metadata_object) {
            if (qName.equalsIgnoreCase(metadata_tag)) {
                this.processing_metadata_object = true;
                return;
            }
            if (qName.equalsIgnoreCase(objects_tag)) {
                this.processing_metadata_object = true;
                return;
            }
            if (this.isFlagSet(MDSTORE_XML)) {
                this.processing_metadata_object = true;
                return;
            }
            this.processing_metadata_object = true;
        }
        if (this.processing_metadata_object) {
            this.processMetadataObject(uri, localName, qName, attributes);
        }
    }

    public void processMetadataObject(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.level < 0) {
            return;
        }
        try {
            int attrLength = attributes.getLength();
            HashMap attrs = null;
            String id = null;
            String name = null;
            boolean attributes_set = false;
            boolean populateAttributes = false;
            if (attrLength > 0) {
                boolean bLocalState = this.isFlagSet(LOCAL_STATE_ON);
                MapPool.instance();
                attrs = MapPool.getMap();
                for (int i = 0; i < attrLength; ++i) {
                    String attr = attributes.getQName(i);
                    if (id == null) {
                        if (attr.equalsIgnoreCase("Id")) {
                            populateAttributes = true;
                            id = attributes.getValue(i);
                        } else if (attr.equalsIgnoreCase("ObjRef")) {
                            id = attributes.getValue(i);
                        }
                    } else if (name == null && attr.equalsIgnoreCase("Name")) {
                        name = attributes.getValue(i);
                    }
                    MdObjectAttribute attribute = MdObjectAttributePool.instance().getMdObjectAttribute();
                    attribute.setAttributeName(attr);
                    attribute.setAttributeValue(attributes.getValue(i));
                    attribute.setAttributeState(bLocalState ? 1 : 2);
                    attrs.put(attr, attribute);
                }
            }
            if (!attributes_set && id != null) {
                attributes_set = true;
            }
            if (id != null) {
                CMetadata myObject = null;
                if (name == null) {
                    name = "";
                }
                if ((myObject = this.isFlagSet(CREATE_SIMPLE_OBJECTS_ONLY) ? MdObjectFactory.createSimpleMetadataObject(name, qName, id) : MdObjectFactory.createComplexMetadataObject(this.store, null, name, qName, id, null)) != null) {
                    this.addObjectToStack(myObject);
                    if (!this.inAssoc) {
                        this.rootLevelObjects.add(myObject);
                    } else {
                        MdSAXStackAssocProperty assocProperty = (MdSAXStackAssocProperty)this.assocObjectStack.get(this.assocObjectStack.size() - 1);
                        assocProperty.getAssocValues().add(myObject);
                    }
                    if (populateAttributes) {
                        this.setAttributes(myObject, attrs);
                        if ((myObject.getState() & 4) > 0) {
                            myObject.resetState(4);
                        }
                    }
                    this.objectsCreated.add(myObject);
                }
            } else if (!attributes_set) {
                this.inAssoc = true;
                if (this.stackObjects.size() >= this.level && this.stackObjects.size() > 0) {
                    CMetadata parentObject = null;
                    Object stackObj = this.stackObjects.get(this.level - 1);
                    parentObject = stackObj.getClass().equals(MdSAXStackAssocProperty.class) ? ((MdSAXStackAssocProperty)stackObj).getParent() : (CMetadata)stackObj;
                    MdSAXStackAssocProperty assocProperty = new MdSAXStackAssocProperty(qName, parentObject, this.level);
                    this.assocObjectStack.push(assocProperty);
                    this.addObjectToStack(assocProperty);
                }
            }
            if (attrs != null) {
                MapPool.instance();
                MapPool.returnMap(attrs);
            }
            ++this.level;
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.level < 0) {
            if (this.processing_metadata_object && qName.equalsIgnoreCase(metadata_tag)) {
                this.processing_metadata_object = false;
            } else if (this.processing_metadata_object && qName.equalsIgnoreCase(objects_tag)) {
                this.processing_metadata_object = false;
            } else if (this.processing_metadata_object && this.isFlagSet(MDSTORE_XML)) {
                this.processing_metadata_object = false;
            }
            return;
        }
        this.processAssociation(qName);
        --this.level;
    }

    protected void addObjectToStack(Object input) {
        if (this.stackObjects.size() <= this.level) {
            this.stackObjects.add(this.level, input);
        } else {
            this.stackObjects.set(this.level, input);
        }
    }

    public void setAttributes(CMetadata inObject, Map inAttributes) {
        if (!this.isFlagSet(OVERRIDE_LOCALLYSET_ATTRIBUTES)) {
            Map<String, Integer> attrStates = inObject.getAttrsStates();
            for (String attributeName : attrStates.keySet()) {
                Integer attrState = attrStates.get(attributeName);
                if (attrState == null || attrState != 1) continue;
                inAttributes.remove(attributeName);
            }
            MapPool.instance();
            MapPool.returnMap(attrStates);
        }
        inObject.setAttrs(inAttributes);
    }

    public void processAssociation(String qName) {
        if (this.inAssoc) {
            if (this.assocObjectStack.size() > 0) {
                MdSAXStackAssocProperty assocProperty = (MdSAXStackAssocProperty)this.assocObjectStack.get(this.assocObjectStack.size() - 1);
                if (!qName.equals(assocProperty.getAssociationName()) && assocProperty.getLevel() == this.level) {
                    MdSAXStackAssocProperty prop;
                    for (int i = this.assocObjectStack.size() - 1; i >= 0 && (prop = (MdSAXStackAssocProperty)this.assocObjectStack.get(i)).getLevel() == this.level; --i) {
                        this.persistAssoc(prop);
                    }
                    if (this.assocObjectStack.size() <= 0) {
                        this.inAssoc = false;
                    }
                }
                assocProperty = null;
            }
        } else if (this.level > 0 && this.stackObjects.size() > 0 && this.stackObjects.get(this.level - 1) instanceof MdSAXStackAssocProperty && this.assocObjectStack.size() > 0) {
            MdSAXStackAssocProperty assocProperty = (MdSAXStackAssocProperty)this.assocObjectStack.get(this.assocObjectStack.size() - 1);
            if (qName.equals(assocProperty.getAssociationName())) {
                this.persistAssoc(assocProperty);
            }
            Object var2_3 = null;
        }
    }

    public void persistAssoc(MdSAXStackAssocProperty assocProperty) {
        this.assocObjectStack.pop();
        if (!this.isFlagSet(CREATE_SIMPLE_OBJECTS_ONLY)) {
            if (!this.isFlagSet(OVERRIDE_LOCALLYSET_ASSOCIATIONS)) {
                CMetadata parentObject = assocProperty.getParent();
                Map<String, AssociationList> assocs = parentObject.getPopulatedAssocs();
                AssociationList assn = assocs.get(assocProperty.getAssociationName());
                MapPool.instance();
                MapPool.returnMap(assocs);
                if (assn != null) {
                    return;
                }
            }
            AssociationList complexAssoc = new AssociationList(assocProperty.getAssociationName(), assocProperty.getAssocValues());
            if (!this.isFlagSet(LOCAL_STATE_ON)) {
                complexAssoc.setState(1);
            } else {
                complexAssoc.setState(4);
            }
            assocProperty.getParent().setMdObjectAssociation(complexAssoc);
        }
        assocProperty.dispose();
    }

    @Override
    public void dispose() {
        this.rootLevelObjects.clear();
        this.rootLevelObjects = null;
        this.stackObjects.clear();
        this.stackObjects = null;
        if (this.assocObjectStack.size() > 0) {
            for (int i = 0; i < this.assocObjectStack.size(); ++i) {
                Object o = this.assocObjectStack.pop();
                if (o == null) continue;
                MdSAXStackAssocProperty prop = (MdSAXStackAssocProperty)o;
                prop.dispose();
            }
        }
        this.assocObjectStack.clear();
        this.assocObjectStack = null;
        this.objectsCreated.clear();
        this.objectsCreated = null;
    }

    public List getRootLevelCreatedObjects() {
        return this.rootLevelObjects;
    }

    public List getObjectCreatedList() {
        return this.objectsCreated;
    }
}

