/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.ibm.icu.util.TimeZone;
import com.sas.scheduler.model.Timezone;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;

public class TimeHourMinutePanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private int m_hour;
    private int m_minute;
    private int m_minuteInterval;
    private Timezone m_timezone;
    private JComboBox m_hourComboBox = new JComboBox();
    private JComboBox m_minuteComboBox = new JComboBox();
    private JComboBox m_timezoneComboBox = new JComboBox();
    private JLabel m_timezoneLabel = new JLabel(m_bundle.getString("TimeHourMinutePanel.TimezoneLabel.txt"));

    public TimeHourMinutePanel() {
        this(0, 0, 1);
    }

    public TimeHourMinutePanel(int hour, int minute) {
        this(hour, minute, 1);
    }

    public TimeHourMinutePanel(int hour, int minute, int minuteInterval) {
        this(hour, minute, minuteInterval, null);
    }

    public TimeHourMinutePanel(int hour, int minute, int minuteInterval, String timezone) {
        this.m_hour = hour;
        boolean notDone = true;
        while (notDone) {
            if (minute >= 0 && minute < 60) {
                notDone = false;
                continue;
            }
            if (minute > 59) {
                minute -= 60;
                continue;
            }
            if (minute >= 0) continue;
            minute += 60;
        }
        this.m_minute = minute;
        this.m_minuteInterval = minuteInterval;
        this.m_timezone = timezone != null ? new Timezone(timezone) : null;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
    }

    public int getHour() {
        this.m_hour = this.m_hourComboBox.getSelectedIndex();
        return this.m_hour;
    }

    public boolean setHour(int hour) {
        boolean notDone = true;
        while (notDone) {
            if (hour >= 0 && hour < 60) {
                notDone = false;
                continue;
            }
            if (hour > 59) {
                hour = -60;
                continue;
            }
            if (hour >= 0) continue;
            hour = 60;
        }
        this.m_hour = hour;
        this.m_hourComboBox.setSelectedIndex(this.m_hour);
        return true;
    }

    public boolean setHourLimit(int limit) {
        TitledBorder border;
        if (limit > 0 && limit < 24) {
            border = new TitledBorder(m_bundle.getString("TimeHourMinutePanel.TimeBorderTitle.Interval.txt"));
            this.setBorder(border);
        } else {
            border = new TitledBorder(m_bundle.getString("TimeHourMinutePanel.TimeBorderTitle.Default.txt"));
            this.setBorder(border);
        }
        this.m_hourComboBox.removeAllItems();
        for (int hour = 0; hour < limit; ++hour) {
            String hourStr = m_bundle.getString("TimeHourMinutePanel.Hour." + String.valueOf(hour) + ".txt");
            this.m_hourComboBox.addItem(hourStr);
        }
        if (this.m_hour >= limit) {
            this.m_hour = 0;
        }
        this.m_hourComboBox.setSelectedIndex(this.m_hour);
        if (limit == 1) {
            this.m_hourComboBox.setEnabled(false);
        } else {
            this.m_hourComboBox.setEnabled(true);
        }
        return true;
    }

    public void enableHour(boolean flag) {
        this.m_hourComboBox.setEnabled(flag);
    }

    public int getMinutes() {
        this.m_minute = this.m_minuteComboBox.getSelectedIndex() * this.m_minuteInterval;
        return this.m_minute;
    }

    public boolean setMinute(int minute) {
        boolean notDone = true;
        while (notDone) {
            if (minute >= 0 && minute < 60) {
                notDone = false;
                continue;
            }
            if (minute > 59) {
                minute = -60;
                continue;
            }
            if (minute >= 0) continue;
            minute = 60;
        }
        this.m_minute = minute;
        this.m_minuteComboBox.setSelectedIndex(this.m_minute / this.m_minuteInterval);
        return true;
    }

    public String getTimezone() {
        if (this.m_timezone != null) {
            this.m_timezone = (Timezone)this.m_timezoneComboBox.getSelectedItem();
            return this.m_timezone.getID();
        }
        return null;
    }

    public boolean setTimezone(String timezoneID) {
        String zoneId;
        int zone;
        this.m_timezone = timezoneID != null ? new Timezone(timezoneID) : new Timezone();
        String zoneStr = this.m_timezone != null ? this.m_timezone.getID() : "";
        boolean found = false;
        String[] timezones = Timezone.getAvailableIDSASList();
        int numIds = timezones.length;
        for (zone = 0; zone < numIds; ++zone) {
            zoneId = timezones[zone];
            if (zoneStr.compareTo(zoneId) != 0) continue;
            this.m_timezoneComboBox.setSelectedIndex(zone);
            found = true;
        }
        if (!found && this.m_timezone != null) {
            for (zone = 0; zone < numIds; ++zone) {
                zoneId = timezones[zone];
                Timezone timezone = new Timezone(zoneId);
                if (!timezone.hasSameRules((TimeZone)this.m_timezone)) continue;
                this.m_timezoneComboBox.setSelectedIndex(zone);
                found = true;
                break;
            }
        }
        this.m_timezoneLabel.setVisible(true);
        this.m_timezoneComboBox.setVisible(true);
        return found;
    }

    private void __initialize() {
        Timezone timezone;
        String zoneId;
        int zone;
        TitledBorder border = new TitledBorder(m_bundle.getString("TimeHourMinutePanel.TimeBorderTitle.Default.txt"));
        this.setBorder(border);
        for (int hour = 0; hour < 24; ++hour) {
            String hourStr = m_bundle.getString("TimeHourMinutePanel.Hour." + String.valueOf(hour) + ".txt");
            this.m_hourComboBox.addItem(hourStr);
        }
        this.m_hourComboBox.setSelectedIndex(this.m_hour);
        JLabel hourLabel = new JLabel(m_bundle.getString("TimeHourMinutePanel.HourLabel.txt"));
        hourLabel.setLabelFor(this.m_hourComboBox);
        for (int minute = 0; minute < 60; minute += this.m_minuteInterval) {
            String minuteStr = m_bundle.getString("TimeHourMinutePanel.Minute." + String.valueOf(minute) + ".txt");
            this.m_minuteComboBox.addItem(minuteStr);
        }
        this.m_minuteComboBox.setSelectedIndex(this.m_minute / this.m_minuteInterval);
        JLabel minuteLabel = new JLabel(m_bundle.getString("TimeHourMinutePanel.MinuteLabel.txt"));
        minuteLabel.setLabelFor(this.m_minuteComboBox);
        int w = Math.max(this.m_hourComboBox.getPreferredSize().width, this.m_minuteComboBox.getPreferredSize().width);
        int h = Math.max(this.m_hourComboBox.getPreferredSize().height, this.m_minuteComboBox.getPreferredSize().height);
        Dimension dim = new Dimension(w, h);
        this.m_minuteComboBox.setPreferredSize(dim);
        this.m_hourComboBox.setPreferredSize(dim);
        String zoneStr = this.m_timezone != null ? this.m_timezone.getID() : "";
        boolean found = false;
        String[] timezones = Timezone.getAvailableIDSASList();
        int numIds = timezones.length;
        for (zone = 0; zone < numIds; ++zone) {
            zoneId = timezones[zone];
            timezone = new Timezone(zoneId);
            this.m_timezoneComboBox.addItem(timezone);
            if (zoneStr.compareTo(zoneId) != 0) continue;
            this.m_timezoneComboBox.setSelectedIndex(zone);
            found = true;
        }
        if (!found && this.m_timezone != null) {
            for (zone = 0; zone < numIds; ++zone) {
                zoneId = timezones[zone];
                timezone = new Timezone(zoneId);
                if (!timezone.hasSameRules((TimeZone)this.m_timezone)) continue;
                this.m_timezoneComboBox.setSelectedIndex(zone);
                break;
            }
        }
        GridBagConstraints gbc_hourLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_hourComboBox = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_minuteLabel = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_minuteComboBox = new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_timezoneLabel = new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0);
        GridBagConstraints gbc_timezoneComboBox = new GridBagConstraints(5, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 5), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)hourLabel, gbc_hourLabel);
        this.add((Component)this.m_hourComboBox, gbc_hourComboBox);
        this.add((Component)minuteLabel, gbc_minuteLabel);
        this.add((Component)this.m_timezoneLabel, gbc_timezoneLabel);
        this.add((Component)this.m_timezoneComboBox, gbc_timezoneComboBox);
        this.add((Component)this.m_minuteComboBox, gbc_minuteComboBox);
        if (this.m_timezone == null) {
            this.m_timezoneLabel.setVisible(false);
            this.m_timezoneComboBox.setVisible(false);
        }
    }

    static {
        String strClassName = TimeHourMinutePanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

