/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class StandardInternalFrame
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    protected static final String DATA_CHANGED_PROPERTY = "DataChanged";
    public static final String DataChangedPromptProperty = "PromptAboutDataChanged";
    protected String m_sRealTitle;
    protected String m_sHelpTopic;
    protected String m_sHelpProduct;
    protected boolean m_bInitialized = false;
    protected int m_eReturnValue;
    protected boolean m_bDataChanged;
    protected JPanel m_pnlButtons;
    protected JButton m_btnHelp;
    protected JButton m_btnOk;
    protected JButton m_btnApply;
    protected JButton m_btnCancel;
    protected StandardPanel m_pnlMain;
    protected PropertyChangeListener m_lsnrDataChanged = new cDataChangedListener();
    protected PropertyChangeListener m_lsnrPanelDataChanged = new cPanelDataChangedListener();

    public StandardInternalFrame(String sTitle) {
        this(sTitle, null);
    }

    public StandardInternalFrame(String sTitle, StandardPanel pnlMain) {
        super(sTitle, true, true, true, true);
        this.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrDataChanged);
        this.setBackground(SystemColor.control);
        this.setTitle(sTitle);
        if (pnlMain != null) {
            this.setMainPanel(pnlMain);
        }
    }

    public int getReturnValue() {
        return this.m_eReturnValue;
    }

    public void setMainPanel(StandardPanel pnlMain) {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.removePropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.getContentPane().remove(this.m_pnlMain);
            this.restoreMainPanelBorder();
        }
        this.m_pnlMain = pnlMain;
        if (this.m_pnlMain != null) {
            this.getContentPane().add((Component)this.m_pnlMain, "Center");
            this.m_pnlMain.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.createMainPanelBorder();
        }
    }

    public StandardPanel getMainPanel() {
        return this.m_pnlMain;
    }

    @Override
    public void setTitle(String sTitle) {
        this.m_sRealTitle = sTitle;
    }

    public void setHelpTopic(String sHelpTopic) {
        this.m_sHelpTopic = sHelpTopic;
    }

    public String getHelpTopic() {
        return this.m_sHelpTopic;
    }

    public void setHelpProduct(String sHelpProduct) {
        this.m_sHelpProduct = sHelpProduct;
    }

    public String getHelpProduct() {
        return this.m_sHelpProduct;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    public boolean isDataChanged() {
        return this.m_bDataChanged;
    }

    public Component getDefaultFocusComponent() {
        return this;
    }

    @Override
    public void pack() {
        if (!this.m_bInitialized) {
            this.initialize();
            this.layoutWidgets();
            this.m_bInitialized = true;
        }
        super.pack();
    }

    @Override
    public void show() {
        this.pack();
        this.onShow();
        super.show();
        JRootPane root = this.getRootPane();
        root.setDefaultButton(root.getDefaultButton());
        this.getDefaultFocusComponent().requestFocus();
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        JRootPane root = this.getRootPane();
        root.setDefaultButton(root.getDefaultButton());
    }

    protected void createMainPanelBorder() {
        Border brdrOuter = BorderFactory.createEmptyBorder(7, 7, 7, 7);
        Border brdrInner = this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    protected void restoreMainPanelBorder() {
        CompoundBorder brdrCompound = (CompoundBorder)this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(brdrCompound.getOutsideBorder());
    }

    public void close() {
        this.firePropertyChange("closed", Boolean.FALSE, Boolean.TRUE);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_btnOk) {
            if (this.onOK()) {
                this.close();
            }
        } else if (src == this.m_btnCancel) {
            if (this.onCancel()) {
                this.close();
            }
        } else if (src == this.m_btnApply) {
            this.onApply();
        } else if (src == this.m_btnHelp) {
            this.onHelp();
        }
    }

    protected void onShow() {
        this.m_pnlMain.moveDataToView();
    }

    protected boolean onOK() {
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (this.validateData() && this.m_pnlMain != null && this.m_pnlMain.moveViewToData()) {
            this.m_eReturnValue = 1;
            this.m_pnlMain.onParentOK();
            return true;
        }
        return false;
    }

    protected boolean onCancel() {
        if (this.m_pnlMain != null && !this.m_pnlMain.canClose()) {
            return false;
        }
        if (this.isDataChanged()) {
            String ckbText = m_bundle.getString("Common.ContinueShowingPrompt.txt");
            JCheckBox ckbShow = new JCheckBox(Util.getLabelWithoutMnemonic((String)ckbText), true);
            ckbShow.setMnemonic(Util.getDisplayedMnemonic((String)ckbText));
            ckbShow.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)ckbText));
            String sMessage = m_bundle.getString("Common.SaveChangesToData.txt");
            Object[] oaMessage = new Object[]{sMessage, " ", ckbShow};
            int iAnswer = JOptionPane.showConfirmDialog(this, oaMessage, this.getTitle(), 1, 2);
            switch (iAnswer) {
                case 0: {
                    return this.onOK();
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
            }
        }
        this.m_eReturnValue = 2;
        if (this.m_pnlMain != null) {
            this.m_pnlMain.onParentCancel();
        }
        return true;
    }

    protected boolean onApply() {
        if (this.validateData()) {
            if (this.m_pnlMain != null) {
                this.m_pnlMain.moveViewToData();
            }
            this.setDataChanged(false);
            if (this.m_pnlMain != null) {
                this.m_pnlMain.onParentApply();
            }
            return true;
        }
        return false;
    }

    protected void onHelp() {
    }

    public void refresh() {
        if (this.m_pnlMain != null) {
            this.setDataChanged(false);
        }
    }

    protected boolean validateData() {
        if (this.m_pnlMain != null) {
            return this.m_pnlMain.validateData();
        }
        return true;
    }

    @Override
    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    protected void initialize() {
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
                String sProperty = e.getPropertyName();
                if (sProperty.equals("closed")) {
                    boolean bOld = (Boolean)e.getOldValue();
                    boolean bNew = (Boolean)e.getNewValue();
                    if (!bOld && bNew && !StandardInternalFrame.this.onCancel()) {
                        throw new PropertyVetoException("close cancelled", e);
                    }
                }
            }
        });
        this.m_pnlButtons = new JPanel();
        String okText = m_bundle.getString("Common.OK.txt");
        String cancelText = m_bundle.getString("Common.Cancel.txt");
        String applyText = m_bundle.getString("Common.Apply.txt");
        String helpText = m_bundle.getString("Common.Help.txt");
        this.m_btnOk = new JButton(Util.getLabelWithoutMnemonic((String)okText));
        this.m_btnCancel = new JButton(Util.getLabelWithoutMnemonic((String)cancelText));
        this.m_btnApply = new JButton(Util.getLabelWithoutMnemonic((String)applyText));
        this.m_btnHelp = new JButton(Util.getLabelWithoutMnemonic((String)helpText));
        this.m_btnOk.setName("OK");
        this.m_btnCancel.setName("Cancel");
        this.m_btnApply.setName("Apply");
        this.m_btnHelp.setName("Help");
        this.m_btnApply.setMnemonic(Util.getDisplayedMnemonic((String)applyText));
        this.m_btnApply.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)applyText));
        this.m_btnHelp.setMnemonic(Util.getDisplayedMnemonic((String)helpText));
        this.m_btnHelp.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)helpText));
        this.m_btnOk.addActionListener(this);
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp.addActionListener(this);
        this.m_btnApply.addActionListener(this);
        this.m_btnApply.setEnabled(false);
    }

    protected void layoutWidgets() {
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(3, 7, 7, 7));
        Container paneContents = this.getContentPane();
        if (this.m_pnlMain != null) {
            paneContents.add((Component)this.m_pnlMain, "Center");
        }
        this.updateButtonsPanel();
        JPanel pnlRightAligned = new JPanel(new FlowLayout(2, 0, 0));
        pnlRightAligned.add(this.m_pnlButtons);
        paneContents.add((Component)pnlRightAligned, "South");
    }

    protected void updateButtonsPanel() {
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new GridLayout(1, 4, 5, 0));
        this.m_pnlButtons.add(this.m_btnOk);
        this.m_pnlButtons.add(this.m_btnCancel);
        this.m_pnlButtons.add(this.m_btnApply);
        this.m_pnlButtons.add(this.m_btnHelp);
        this.getRootPane().setDefaultButton(this.m_btnOk);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public void updateWorkspaceUIComponents() {
    }

    static {
        String strClassName = StandardInternalFrame.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    protected class cPanelDataChangedListener
    implements PropertyChangeListener {
        protected cPanelDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StandardInternalFrame.this.setDataChanged((Boolean)e.getNewValue());
        }
    }

    protected class cDataChangedListener
    implements PropertyChangeListener {
        protected cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean bEnable = (Boolean)e.getNewValue();
            if (StandardInternalFrame.this.m_btnApply != null) {
                StandardInternalFrame.this.m_btnApply.setEnabled(bEnable);
            }
        }
    }
}

