/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.CustomLayoutFocusTraversalPolicy;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.util.SASJavaHelp;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class StandardDialog
extends JDialog
implements ActionListener {
    protected static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private boolean m_bCancelButtonVisible;
    private boolean m_bApplyButtonVisible;
    private boolean m_bHelpButtonVisible;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private static final String DATA_CHANGED_PROPERTY = "DataChanged";
    protected Frame m_frame;
    private Dialog m_dialog;
    protected int m_eReturnValue;
    private boolean m_bDataChanged;
    private JPanel m_pnlButtons;
    private JButton m_btnHelp;
    private JButton m_btnOk;
    private JButton m_btnApply;
    private JButton m_btnCancel;
    private StandardPanel m_pnlMain;
    private PropertyChangeListener m_lsnrDataChanged;
    private PropertyChangeListener m_lsnrPanelDataChanged;
    private String m_sHelpTopic;
    private String m_sHelpProduct;
    private SASJavaHelp m_sasJH;

    public StandardDialog(Dialog dlgOwner) {
        this(dlgOwner, "", false, (StandardPanel)null);
        this.m_dialog = dlgOwner;
    }

    public StandardDialog(Dialog dlgOwner, boolean bModal) {
        this(dlgOwner, "", bModal, (StandardPanel)null);
        this.m_dialog = dlgOwner;
    }

    public StandardDialog(Dialog dlgOwner, String sTitle) {
        this(dlgOwner, sTitle, false, (StandardPanel)null);
        this.m_dialog = dlgOwner;
    }

    public StandardDialog(Dialog dlgOwner, String sTitle, boolean bModal) {
        this(dlgOwner, sTitle, bModal, (StandardPanel)null);
        this.m_dialog = dlgOwner;
    }

    public StandardDialog(Dialog dlgOwner, String sTitle, boolean bModal, StandardPanel pnlMain) {
        super(dlgOwner, sTitle, bModal);
        this.m_dialog = dlgOwner;
        this.setCancelButtonVisible(true);
        this.setApplyButtonVisible(!bModal);
        this.setHelpButtonVisible(true);
        this.setResizable(false);
        this.m_lsnrDataChanged = new cDataChangedListener();
        this.m_lsnrPanelDataChanged = new cPanelDataChangedListener();
        this.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrDataChanged);
        if (pnlMain != null) {
            this.setMainPanel(pnlMain);
        }
    }

    public StandardDialog(Frame frmOwner) {
        this(frmOwner, "", false, (StandardPanel)null);
        this.m_frame = frmOwner;
    }

    public StandardDialog(Frame frmOwner, boolean bModal) {
        this(frmOwner, "", bModal, (StandardPanel)null);
        this.m_frame = frmOwner;
    }

    public StandardDialog(Frame frmOwner, String sTitle) {
        this(frmOwner, sTitle, false, (StandardPanel)null);
        this.m_frame = frmOwner;
    }

    public StandardDialog(Frame frmOwner, String sTitle, boolean bModal) {
        this(frmOwner, sTitle, bModal, (StandardPanel)null);
        this.m_frame = frmOwner;
    }

    public StandardDialog(Frame frmOwner, String sTitle, boolean bModal, StandardPanel pnlMain) {
        super(frmOwner, sTitle, bModal);
        this.m_frame = frmOwner;
        this.setCancelButtonVisible(true);
        this.setApplyButtonVisible(!bModal);
        this.setHelpButtonVisible(true);
        this.setResizable(false);
        this.m_lsnrDataChanged = new cDataChangedListener();
        this.m_lsnrPanelDataChanged = new cPanelDataChangedListener();
        this.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrDataChanged);
        if (pnlMain != null) {
            this.setMainPanel(pnlMain);
        }
    }

    public boolean isCancelButtonVisible() {
        return this.m_bCancelButtonVisible;
    }

    public void setCancelButtonVisible(boolean visible) {
        this.m_bCancelButtonVisible = visible;
    }

    public boolean isApplyButtonVisible() {
        return this.m_bApplyButtonVisible;
    }

    public void setApplyButtonVisible(boolean visible) {
        this.m_bApplyButtonVisible = visible;
    }

    public boolean isHelpButtonVisible() {
        return this.m_bHelpButtonVisible;
    }

    public void setHelpButtonVisible(boolean visible) {
        this.m_bHelpButtonVisible = visible;
    }

    @Override
    public void setModal(boolean bModal) {
        super.setModal(bModal);
        if (this.m_pnlButtons != null) {
            this.updateButtonsPanel();
        }
    }

    public int getReturnValue() {
        return this.m_eReturnValue;
    }

    public void setMainPanel(StandardPanel pnlMain) {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.removePropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.getContentPane().remove(this.m_pnlMain);
            this.restoreMainPanelBorder();
        }
        this.m_pnlMain = pnlMain;
        if (this.m_pnlMain != null) {
            this.getContentPane().add((Component)this.m_pnlMain, "Center");
            this.m_pnlMain.addPropertyChangeListener(DATA_CHANGED_PROPERTY, this.m_lsnrPanelDataChanged);
            this.createMainPanelBorder();
        }
    }

    public JPanel getMainPanel() {
        return this.m_pnlMain;
    }

    public void setHelpTopic(String sHelpTopic) {
        this.m_sHelpTopic = sHelpTopic;
    }

    public String getHelpTopic() {
        return this.m_sHelpTopic;
    }

    public void setHelpProduct(String sHelpProduct) {
        this.m_sHelpProduct = sHelpProduct;
    }

    public String getHelpProduct() {
        return this.m_sHelpProduct;
    }

    public ClassLoader getHelpClassLoader() {
        return this.m_pnlMain != null ? this.m_pnlMain.getHelpClassLoader() : null;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (this.m_bDataChanged != bDataChanged) {
            boolean bOld = this.m_bDataChanged;
            this.m_bDataChanged = bDataChanged;
            this.firePropertyChange(DATA_CHANGED_PROPERTY, bOld, bDataChanged);
        }
    }

    public void setBusy(boolean flag) {
        if (flag) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public boolean hasDataChanged() {
        return this.m_bDataChanged;
    }

    public Component getDefaultFocusComponent() {
        Component cmp = null;
        if (this.m_pnlMain != null) {
            cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlMain);
        }
        if (cmp == null) {
            cmp = this.getRootPane().getDefaultButton();
        }
        if (cmp == null && this.m_pnlButtons != null) {
            cmp = CustomLayoutFocusTraversalPolicy.getDefaultFocusComponent(this.m_pnlButtons);
        }
        return cmp != null ? cmp : this;
    }

    public void makeVisible() {
        this._initialize();
        this._layoutWidgets();
        this.pack();
        this.onShow();
        this.center();
        this.getDefaultFocusComponent().requestFocus();
        this.setVisible(true);
    }

    private void createMainPanelBorder() {
        Border brdrOuter = BorderFactory.createEmptyBorder(7, 7, 7, 7);
        Border brdrInner = this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
    }

    private void restoreMainPanelBorder() {
        CompoundBorder brdrCompound = (CompoundBorder)this.m_pnlMain.getBorder();
        this.m_pnlMain.setBorder(brdrCompound.getOutsideBorder());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object src = e.getSource();
            if (src == this.m_btnOk) {
                if (this.onOK()) {
                    this.dispose();
                }
            } else if (src == this.m_btnCancel) {
                if (this.onCancel()) {
                    this.dispose();
                }
            } else if (src == this.m_btnApply) {
                this.onApply();
            } else if (src == this.m_btnHelp) {
                this.onHelp();
            }
        }
        catch (SchedulerException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), m_bundle.getString("StandardDialog.ErrorMessage.Title.txt"), 0);
        }
    }

    protected void onShow() {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.moveDataToView();
        }
    }

    protected boolean onOK() throws SchedulerException {
        if (this.validateData()) {
            if (this.m_pnlMain.moveViewToData()) {
                this.m_eReturnValue = 1;
                return true;
            }
            JOptionPane.showMessageDialog(this, m_bundle.getString("StandardDialog.ErrorMessage.UnableToSaveContents.txt"), m_bundle.getString("StandardDialog.ErrorMessage.Title.txt"), 0);
            return false;
        }
        return false;
    }

    protected boolean onCancel() throws SchedulerException {
        if (this.hasDataChanged()) {
            String sMessage = m_bundle.getString("Common.SaveChangesToData.txt");
            Object[] oaMessage = new Object[]{sMessage, " "};
            int iAnswer = this.m_frame != null ? JOptionPane.showConfirmDialog(this.m_frame, oaMessage, this.getTitle(), 1, 2) : JOptionPane.showConfirmDialog(this.m_dialog, oaMessage, this.getTitle(), 1, 2);
            switch (iAnswer) {
                case 0: {
                    this.onOK();
                    break;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
            }
        }
        this.m_eReturnValue = 2;
        return true;
    }

    protected boolean onApply() throws SchedulerException {
        if (this.validateData()) {
            this.m_pnlMain.moveViewToData();
            this.setDataChanged(false);
            return true;
        }
        return false;
    }

    protected void onHelp() throws SchedulerException {
        this.showHelp(this.getHelpProduct(), this.getHelpTopic(), this, this.getHelpClassLoader());
    }

    public void showHelp(String sHelpProduct, String sHelpTopic, Window wnd, ClassLoader helpLoader) throws SchedulerException {
        try {
            if (sHelpProduct == null) {
                sHelpProduct = "scheduler";
            }
            if (this.m_sasJH == null || this.m_sHelpProduct != sHelpProduct) {
                this.m_sasJH = new SASJavaHelp();
                this.m_sHelpProduct = sHelpProduct;
            }
            this.m_sasJH.setDefaultClassLoader(helpLoader);
            this.m_sasJH.getHelpSet(sHelpProduct);
            this.m_sasJH.setActivationWindow(wnd);
            this.m_sasJH.showContext(sHelpTopic);
        }
        catch (IllegalArgumentException iae) {
            Object[] args = new Object[]{sHelpProduct, sHelpTopic};
            MessageUtil.displayMessage(this.m_frame, MessageFormat.format(m_bundle.getString("StandardDialog.HelpTopicNotFound.fmt"), args), "", 0);
            SchedulerException ex = new SchedulerException(iae.toString());
            throw ex;
        }
        catch (Exception bie) {
            Object[] args = new Object[]{sHelpProduct, sHelpTopic};
            MessageUtil.displayMessage(this.m_frame, MessageFormat.format(m_bundle.getString("StandardDialog.HelpTopicNotFound.fmt"), args), "", 0);
            SchedulerException ex = new SchedulerException(bie.toString());
            throw ex;
        }
    }

    protected boolean validateData() throws SchedulerException {
        if (this.m_pnlMain != null) {
            return this.m_pnlMain.validateData();
        }
        throw new SchedulerException("MISSING MAIN PANEL");
    }

    private void _initialize() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    if (StandardDialog.this.onCancel()) {
                        StandardDialog.this.dispose();
                    }
                }
                catch (SchedulerException ex) {
                    StandardDialog.this.dispose();
                }
            }
        });
        String okText = m_bundle.getString("Common.OK.txt");
        String cancelText = m_bundle.getString("Common.Cancel.txt");
        String applyText = m_bundle.getString("Common.Apply.txt");
        String helpText = m_bundle.getString("Common.Help.txt");
        this.m_pnlButtons = new JPanel();
        this.m_btnOk = new JButton(Util.getLabelWithoutMnemonic((String)okText));
        this.m_btnCancel = new JButton(Util.getLabelWithoutMnemonic((String)cancelText));
        this.m_btnApply = new JButton(Util.getLabelWithoutMnemonic((String)applyText));
        this.m_btnHelp = new JButton(Util.getLabelWithoutMnemonic((String)helpText));
        this.m_btnOk.setName("OK");
        this.m_btnCancel.setName("Cancel");
        this.m_btnApply.setName("Apply");
        this.m_btnHelp.setName("Help");
        this.m_btnApply.setMnemonic(Util.getDisplayedMnemonic((String)applyText));
        this.m_btnApply.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)applyText));
        this.m_btnHelp.setMnemonic(Util.getDisplayedMnemonic((String)helpText));
        this.m_btnHelp.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)helpText));
        this.m_btnOk.addActionListener(this);
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp.addActionListener(this);
        this.m_btnApply.addActionListener(this);
        this.m_btnApply.setEnabled(false);
    }

    private void _layoutWidgets() {
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(3, 7, 7, 7));
        Container paneContents = this.getContentPane();
        if (this.m_pnlMain != null) {
            paneContents.add((Component)this.m_pnlMain, "Center");
        }
        this.updateButtonsPanel();
        paneContents.add((Component)this.m_pnlButtons, "South");
    }

    private void updateButtonsPanel() {
        this.m_pnlButtons.removeAll();
        this.m_pnlButtons.setLayout(new ButtonsLayout());
        this.m_pnlButtons.add(this.m_btnOk);
        if (this.isCancelButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnCancel);
        }
        if (this.isApplyButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnApply);
        }
        if (this.isHelpButtonVisible()) {
            this.m_pnlButtons.add(this.m_btnHelp);
        }
        this.getRootPane().setDefaultButton(this.m_btnOk);
    }

    @Override
    public void dispose() {
        if (this.m_pnlMain != null) {
            this.m_pnlMain.saveSettingsAndCleanUp();
        }
        this.m_pnlMain = null;
        super.dispose();
        SwingUtilities.replaceUIInputMap(this.getRootPane(), 2, null);
    }

    private void center() {
        Dimension szDialog = this.getPreferredSize();
        Dimension szParent = this.getParent().getSize();
        Dimension szScreen = this.getToolkit().getScreenSize();
        Point ptParent = this.getParent().getLocationOnScreen();
        int x = ptParent.x + (szParent.width - szDialog.width) / 2;
        int y = ptParent.y + (szParent.height - szDialog.height) / 2;
        x = Math.max(0, Math.min(x, szScreen.width - szDialog.width));
        y = Math.max(0, Math.min(y, szScreen.height - szDialog.height));
        this.setLocation(x, y);
    }

    static {
        String strClassName = StandardDialog.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class cPanelDataChangedListener
    implements PropertyChangeListener {
        private cPanelDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            StandardDialog.this.setDataChanged((Boolean)e.getNewValue());
        }
    }

    private class cDataChangedListener
    implements PropertyChangeListener {
        private cDataChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean bEnable = (Boolean)e.getNewValue();
            if (StandardDialog.this.m_btnApply != null) {
                StandardDialog.this.m_btnApply.setEnabled(bEnable);
            }
        }
    }
}

