/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.net.crypto.SealedString;
import com.sas.scheduler.visuals.swing.LoginPanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.awt.Frame;
import java.awt.event.ActionListener;

public class LoginDialog
extends StandardDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private LoginPanel m_panel;
    private String m_username;
    private SealedString m_password;
    private boolean m_selected;

    public LoginDialog(Frame owner, String title) {
        super(owner, title, true);
        this.setHelpButtonVisible(false);
        this.m_panel = new LoginPanel();
        super.setMainPanel(this.m_panel);
    }

    public LoginDialog(Frame owner, String title, String checkboxLabel) {
        super(owner, title, true);
        this.setHelpButtonVisible(false);
        this.m_panel = new LoginPanel(checkboxLabel);
        super.setMainPanel(this.m_panel);
    }

    @Override
    public void dispose() {
        if (this.m_panel != null) {
            this.m_username = this.m_panel.getUserName();
            try {
                this.m_password = this.m_panel.getPasswordSealedString() != null ? new SealedString(SasPasswordString.encodeChars((char[])this.m_panel.getPasswordSealedString().getCharacters())) : null;
            }
            catch (SasPasswordEncodingException e) {
                this.m_password = this.m_panel.getPasswordSealedString();
            }
            this.m_selected = this.m_panel.checkboxSelected();
        }
        super.dispose();
        this.m_panel = null;
    }

    public String getUserName() {
        if (this.m_panel != null) {
            this.m_username = this.m_panel.getUserName();
        }
        return this.m_username;
    }

    @Deprecated
    public String getPassword() {
        if (this.m_panel != null) {
            try {
                this.m_password = new SealedString(SasPasswordString.encodeChars((char[])(this.m_panel.getPasswordSealedString() != null ? this.m_panel.getPasswordSealedString().getCharacters() : "".toCharArray())));
            }
            catch (SasPasswordEncodingException e) {
                this.m_password = this.m_panel.getPasswordSealedString();
            }
        }
        return String.valueOf(this.m_password != null ? this.m_password.getCharacters() : null);
    }

    public SealedString getPasswordSealedString() {
        if (this.m_panel != null) {
            try {
                this.m_password = new SealedString(SasPasswordString.encodeChars((char[])(this.m_panel.getPasswordSealedString() != null ? this.m_panel.getPasswordSealedString().getCharacters() : "".toCharArray())));
            }
            catch (SasPasswordEncodingException e) {
                this.m_password = this.m_panel.getPasswordSealedString();
            }
        }
        return this.m_password;
    }

    public boolean checkboxSelected() {
        if (this.m_panel != null) {
            this.m_selected = this.m_panel.checkboxSelected();
        }
        return this.m_selected;
    }

    public void setUserName(String userName) {
        this.m_username = userName;
        this.m_panel.setUserName(userName);
    }

    @Deprecated
    public void setPassword(String password) {
        this.m_password = password == null ? null : new SealedString(password);
        this.m_panel.setPasswordSealedString(new SealedString(password));
    }

    public void setPasswordSealedString(SealedString password) {
        this.m_password = password;
        this.m_panel.setPasswordSealedString(password);
    }
}

