/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class GroupingPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JRadioButton m_radOrCondition = new JRadioButton();
    private JRadioButton m_radAndCondition = new JRadioButton();
    private int m_flagCondition = 0;

    public GroupingPanel(int defaultSetting) {
        this.m_flagCondition = defaultSetting == 0 || defaultSetting == 31 ? 31 : (defaultSetting == 1 || defaultSetting == 32 ? 32 : 32);
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_radOrCondition = null;
        this.m_radAndCondition = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_radOrCondition.setEnabled(enabled);
        this.m_radAndCondition.setEnabled(enabled);
    }

    @Override
    public boolean moveDataToView() {
        if (this.m_flagCondition == 31) {
            this.m_radAndCondition.setSelected(true);
        } else if (this.m_flagCondition == 32) {
            this.m_radOrCondition.setSelected(true);
        } else {
            this.m_radOrCondition.setSelected(true);
        }
        return true;
    }

    private void __initialize() {
        JLabel lblCondition = new JLabel(m_bundle.getString("GroupingPanel.SchedulingConditions.txt"));
        String orText = m_bundle.getString("GroupingPanel.OrCondition.txt");
        this.m_radOrCondition.setText(Util.getLabelWithoutMnemonic((String)orText));
        this.m_radOrCondition.setMnemonic(Util.getDisplayedMnemonic((String)orText));
        this.m_radOrCondition.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)orText));
        this.m_radOrCondition.setToolTipText(m_bundle.getString("GroupingPanel.OrConditionToolTip.txt"));
        this.m_radOrCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GroupingPanel.this.m_flagCondition = 32;
            }
        });
        lblCondition.setLabelFor(this.m_radOrCondition);
        String andText = m_bundle.getString("GroupingPanel.AndCondition.txt");
        this.m_radAndCondition.setText(Util.getLabelWithoutMnemonic((String)andText));
        this.m_radAndCondition.setMnemonic(Util.getDisplayedMnemonic((String)andText));
        this.m_radAndCondition.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)andText));
        this.m_radAndCondition.setToolTipText(m_bundle.getString("GroupingPanel.AndConditionToolTip.txt"));
        this.m_radAndCondition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GroupingPanel.this.m_flagCondition = 31;
            }
        });
        ButtonGroup bgConditions = new ButtonGroup();
        bgConditions.add(this.m_radOrCondition);
        bgConditions.add(this.m_radAndCondition);
        this.setGroupingType(this.m_flagCondition);
        this.setLayout(new GridBagLayout());
        this.add((Component)lblCondition, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_radOrCondition, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.m_radAndCondition, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
    }

    public int getGroupingType() {
        return this.m_flagCondition;
    }

    public void setGroupingType(int type) {
        this.m_flagCondition = type;
        if (this.m_flagCondition == 31) {
            this.m_radAndCondition.setSelected(true);
        } else if (this.m_flagCondition == 32) {
            this.m_radOrCondition.setSelected(true);
        } else {
            this.m_radOrCondition.setSelected(true);
            this.m_flagCondition = 32;
        }
    }

    static {
        String strClassName = GroupingPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

