/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;

public class ConfirmCheckboxDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private ConfirmCheckboxPanel m_panel;
    private boolean m_selected = false;

    public ConfirmCheckboxDialog(Frame owner, String title) {
        super(owner, title, true);
        this.m_panel = new ConfirmCheckboxPanel();
        this.setMainPanel(this.m_panel);
    }

    public ConfirmCheckboxDialog(Frame owner, String title, String message) {
        super(owner, title, true);
        this.m_panel = new ConfirmCheckboxPanel(message);
        this.setMainPanel(this.m_panel);
    }

    @Override
    public void dispose() {
        if (this.m_panel != null) {
            this.m_selected = this.m_panel.checkboxSelected();
        }
        super.dispose();
        this.m_panel = null;
    }

    public void setMessage(String message) {
        this.m_panel.setMessage(message);
    }

    public boolean stillConfirm() {
        if (this.m_panel != null) {
            this.m_selected = this.m_panel.checkboxSelected();
        }
        return !this.m_selected;
    }

    static {
        String strClassName = ConfirmCheckboxDialog.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private static class ConfirmCheckboxPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JTextArea mc_messageText = new JTextArea();
        private JCheckBox mc_checkbox = null;

        public ConfirmCheckboxPanel() {
            this._initialize("");
        }

        public ConfirmCheckboxPanel(String message) {
            this._initialize(message);
        }

        @Override
        public void saveSettingsAndCleanUp() {
            this.mc_messageText = null;
            this.mc_checkbox = null;
        }

        public void setMessage(String message) {
            this.mc_messageText.setText(message);
        }

        public boolean checkboxSelected() {
            return this.mc_checkbox != null ? this.mc_checkbox.isSelected() : false;
        }

        private void _initialize(String message) {
            this.mc_messageText = new JTextArea();
            Font fnt = this.getFont();
            this.mc_messageText.setFont(new Font("Dialog", fnt.getStyle(), fnt.getSize()));
            this.mc_messageText.setColumns(30);
            this.mc_messageText.setText(message);
            this.mc_messageText.setBackground(SystemColor.control);
            this.mc_messageText.setWrapStyleWord(true);
            this.mc_messageText.setLineWrap(true);
            this.mc_messageText.setEditable(false);
            String confirmationMsg = m_bundle.getString("ConfirmCheckboxPanel.Checkbox.Suppress.Msg.txt");
            this.mc_checkbox = new JCheckBox(confirmationMsg);
            GridBagConstraints gbc_message = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(12, 12, 0, 0), 0, 0);
            GridBagConstraints gbc_checkbox = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(12, 12, 0, 0), 0, 0);
            this.setLayout(new GridBagLayout());
            this.setPreferredSize(new Dimension(350, 150));
            this.add((Component)this.mc_messageText, gbc_message);
            this.add((Component)this.mc_checkbox, gbc_checkbox);
        }
    }
}

