/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.visuals.swing;

import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class BatchServerPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JLabel m_lblBatchServer;
    private JComboBox m_cmbServerList;
    private JButton m_btnNewServer;
    private ComboItemChangedListener m_comboListener;
    private Object[] m_arr;
    private BatchServerInfo m_defaultserver;

    public BatchServerPanel(List<?> listOfServers, BatchServerInfo defaultserver) {
        this.m_arr = listOfServers.toArray();
        this.m_defaultserver = defaultserver;
        this.__initialize();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_lblBatchServer = null;
        this.m_btnNewServer = null;
        this.m_comboListener = null;
        this.m_arr = null;
        this.m_defaultserver = null;
    }

    public void __initialize() {
        int i;
        this.m_comboListener = new ComboItemChangedListener();
        this.m_cmbServerList = new JComboBox();
        this.m_cmbServerList.setModel(new DefaultComboBoxModel<Object>(this.m_arr));
        this.m_cmbServerList.setToolTipText(m_bundle.getString("BatchServerPanel.BatchServer.ToolTip.txt"));
        this.m_cmbServerList.addActionListener(this.m_comboListener);
        String batchserverText = m_bundle.getString("BatchServerPanel.BatchServer.txt");
        this.m_lblBatchServer = new JLabel(Util.getLabelWithoutMnemonic((String)batchserverText));
        this.m_lblBatchServer.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)batchserverText));
        this.m_lblBatchServer.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)batchserverText));
        this.m_lblBatchServer.setLabelFor(this.m_cmbServerList);
        String newbuttonString = m_bundle.getString("BatchServerPanel.NewButton.txt");
        this.m_btnNewServer = new JButton(Util.getLabelWithoutMnemonic((String)newbuttonString));
        this.m_btnNewServer.setMnemonic(Util.getDisplayedMnemonic((String)newbuttonString));
        this.m_btnNewServer.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)newbuttonString));
        this.m_btnNewServer.setToolTipText(m_bundle.getString("BatchServerPanel.NewButton.ToolTip.txt"));
        for (i = 0; i < this.m_arr.length - 1; ++i) {
            for (int j = 0; j < this.m_arr.length - 1 - i; ++j) {
                String name1 = ((BatchServerInfo)this.m_arr[i]).getName();
                String name2 = ((BatchServerInfo)this.m_arr[j + 1]).getName();
                if (name2.compareToIgnoreCase(name1) >= 0) continue;
                BatchServerInfo sc = (BatchServerInfo)this.m_arr[j];
                this.m_arr[j] = this.m_arr[j + 1];
                this.m_arr[j] = sc;
            }
        }
        this.m_cmbServerList.setModel(new DefaultComboBoxModel<Object>(this.m_arr));
        if (this.m_defaultserver != null) {
            for (i = 0; i < this.m_arr.length; ++i) {
                String id = ((BatchServerInfo)this.m_arr[i]).getId();
                if (id == null || !id.equals(this.m_defaultserver.getId())) continue;
                this.m_cmbServerList.setSelectedIndex(i);
                break;
            }
        } else if (this.m_cmbServerList.getItemCount() != 0) {
            this.m_cmbServerList.setSelectedIndex(0);
        }
        this.setListeningForChanges(false);
        this.addComboListener(this.m_comboListener);
        this.setListeningForChanges(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblBatchServer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_cmbServerList, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_btnNewServer, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public boolean addServer(BatchServerInfo sinfo) {
        this.m_cmbServerList.addItem(sinfo);
        this.m_cmbServerList.setSelectedItem(sinfo);
        return true;
    }

    public BatchServerInfo getSelectedServer() {
        return (BatchServerInfo)this.m_cmbServerList.getSelectedItem();
    }

    public void setSelectedServer(BatchServerInfo server) {
        this.m_cmbServerList.setSelectedItem(server);
    }

    public void addComboListener(ActionListener acl) {
        this.m_cmbServerList.addActionListener(acl);
    }

    public void removeComboListener(ActionListener acl) {
        this.m_cmbServerList.removeActionListener(acl);
    }

    public void addNewButtonListener(ActionListener acl) {
        this.m_btnNewServer.addActionListener(acl);
    }

    public void removeNewButtonListener(ActionListener acl) {
        this.m_btnNewServer.removeActionListener(acl);
    }

    static {
        String strClassName = BatchServerPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }

    private class ComboItemChangedListener
    implements ActionListener {
        private ComboItemChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent it) {
            BatchServerPanel.this.setDataChanged(true);
        }
    }
}

