/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class PromotionTableCellRenderer
extends DefaultTableCellRenderer {
    private JComboBox combo = new JComboBox();
    private TransformInterface _transform;

    public void setTransform(TransformInterface transform) {
        this._transform = transform;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isCellSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isCellSelected, hasFocus, row, column);
        int columnModelIndex = table.convertColumnIndexToModel(column);
        boolean editable = table.getModel().isCellEditable(row, columnModelIndex);
        if (columnModelIndex == 0) {
            if (!isCellSelected) {
                super.setBackground(SystemColor.control);
                super.setForeground(SystemColor.controlText);
            } else if (hasFocus || table.hasFocus() || table.getEditorComponent() != null && table.getEditorComponent().hasFocus()) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                Color c = SystemColor.control;
                double FACTOR = 0.85;
                c = new Color(Math.max((int)((double)c.getRed() * FACTOR), 0), Math.max((int)((double)c.getGreen() * FACTOR), 0), Math.max((int)((double)c.getBlue() * FACTOR), 0));
                super.setBackground(c);
                super.setForeground(SystemColor.controlText);
            }
        } else if (table.getSelectedRow() == row && editable) {
            ((DefaultComboBoxModel)this.combo.getModel()).removeAllElements();
            if (this._transform != null) {
                try {
                    value = this._transform.transform(value);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            ((DefaultComboBoxModel)this.combo.getModel()).addElement(value);
            this.combo.setSelectedItem(value);
            component = this.combo;
        } else {
            if (!editable) {
                this.setValue(" ");
            }
            super.setBackground(SystemColor.window);
            super.setForeground(SystemColor.windowText);
        }
        return component;
    }

    @Override
    protected void setValue(Object value) {
        if (this._transform != null) {
            try {
                value = this._transform.transform(value);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        this.setText(value == null ? "" : value.toString());
    }
}

