/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.connections.ConnectionPanelInterface;
import com.sas.metadata.promotion.visuals.connections.DependentObjectsComponent;
import com.sas.metadata.promotion.visuals.connections.PromotionTable;
import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.visuals.util.Util;
import com.sas.util.GenericComparator;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class InformationalConnectionPanel
extends WsDescriptionWizardTab
implements ConnectionPanelInterface,
ListSelectionListener,
ChangeListener {
    protected Log _log;
    protected ConnectionTypeInterface _connectionType;
    protected ImportOperationInterface _importOperation;
    protected List _connectionPoints;
    protected DependentConnectionInterface _dependentConnection;
    private DependentObjectsComponent _dependentComponent;
    protected List _connections;
    private ProportionalSpacePartitioner _rowPartitioner;
    protected PromotionTable _mappingTable;
    private AbstractTableModel _tableModel;
    protected String _borderLabel;
    private Border _mappingBorder;
    private JPanel _mainPanel;
    private JPanel _mappingTablePanel;
    private AutoSizingGridLayout _mappingLayout;
    private JTabbedPane _infoTabber;
    private Map _infoComponentsMap;
    private Map _targetMapping;
    private JPanel _mappingPanel;
    protected JLabel _sourceLabel;
    protected JLabel _sourceLabelValue;
    protected JLabel _targetLabel;
    protected JLabel _targetLabelValue;
    protected TableCellEditor _cellEditor;
    protected TableCellRenderer _tableRenderer;
    protected TransformInterface _tableTransform;

    public InformationalConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        this._importOperation = operation;
        this._log = operation.getLogger();
        this._connectionType = type;
        this._connectionPoints = type.getSourceConnections();
        this.initialize();
        this.layoutWidgets();
    }

    public abstract String getHelpTopicSuffix();

    public abstract String getPanelDescription();

    @Override
    public abstract String getPanelTitle();

    public abstract String getPanelBorderLabel();

    public abstract String getTableSourceColumnValue(SourceConnectionInterface var1);

    public abstract String getTableTargetColumnValue(SourceConnectionInterface var1);

    @Override
    public final String getPanelName() {
        return this._connectionType.getPanelName();
    }

    @Override
    public final ConnectionTypeInterface getConnectionType() {
        return this._connectionType;
    }

    @Override
    public final List getConnectionPoints() {
        return this._connectionPoints;
    }

    public String getTableSourceColumnName() {
        return RB.getStringResource("AbstractConnectionPanel.SourceColumn.txt");
    }

    public String getTableTargetColumnName() {
        return RB.getStringResource("AbstractConnectionPanel.TargetColumn.txt");
    }

    public void initialize() {
        this.setDescription(this.getPanelDescription());
        super.initialize();
        this.setHelpProduct("promotion");
        String prefix = this._importOperation.getPromotionType() == 3 ? "pastespec_" : "imp_";
        this.setHelpTopic(prefix + this.getHelpTopicSuffix());
        this._mainPanel = new JPanel();
        this._infoTabber = new JTabbedPane();
        this._mappingTable = new PromotionTable();
        this._mappingTable.setModel(new DefaultTableModel());
        this._mappingTable.setPreferredScrollableViewportSize(new Dimension(200, 75));
        this._tableRenderer = this.getTableCellRenderer();
    }

    public void layoutWidgets() {
        super.layoutWidgets();
        this.setLayout(new BorderLayout());
        AutoSizingGridLayout mainLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        mainLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._mainPanel.setLayout((LayoutManager)mainLayout);
        this._mappingPanel = new JPanel();
        this._mappingLayout = new AutoSizingGridLayout(2, 1, 5, 5, true, true, true);
        this._mappingLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._rowPartitioner = new ProportionalSpacePartitioner(new double[]{-2.0, 0.5, 0.5}, new int[]{0, 75, 75}, new int[]{Integer.MAX_VALUE, 125, Integer.MAX_VALUE}, true);
        this._mappingLayout.setRowSpacePartitioner((SpacePartitionerInterface)this._rowPartitioner);
        this._mappingPanel.setLayout((LayoutManager)this._mappingLayout);
        this._mappingBorder = Util.getGroupBoxBorder((String)this.getPanelBorderLabel(), (int)0, (int)5, (int)5, (int)5);
        this._mappingPanel.setBorder(this._mappingBorder);
        this._mappingTablePanel = new JPanel();
        AutoSizingGridLayout mappingTableLayout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        mappingTableLayout.setIgnoreSizeOfNonVisibleComponents(true);
        this._mappingTablePanel.setLayout((LayoutManager)mappingTableLayout);
        this._mappingPanel.add(this._mappingTablePanel);
        this._mappingPanel.add(this._infoTabber);
        this._mainPanel.add(this._mappingPanel);
        this.add(this._mainPanel, "Center");
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.populatePanel();
        }
        return true;
    }

    public void populatePanel() {
        this._targetMapping = null;
        this._mappingTablePanel.removeAll();
        Map mapping = this.getMappingsForTarget();
        if (mapping != null) {
            this._tableModel = new TableModel();
            if (this._mappingTable == null) {
                this._mappingTable = new PromotionTable();
            }
            this._mappingTable.setPreferredScrollableViewportSize(new Dimension(200, 75));
            SortableTableModelAdapter sortingModel = new SortableTableModelAdapter((javax.swing.table.TableModel)this._tableModel);
            SortingComparator myComparator = new SortingComparator();
            sortingModel.setDefaultComparator((Comparator)((Object)myComparator));
            this._mappingTable.setModel((javax.swing.table.TableModel)sortingModel);
            this._mappingTable.getEditController().setEditEnabled(false);
            this._mappingTable.setRowSelectionInterval(0, 0);
            this._mappingTable.setCellRenderer(-1, -1, this._tableRenderer);
            int rowCount = this._mappingTable.getRowCount();
            if (rowCount > 0) {
                this._mappingTable.setRowSelectionInterval(0, 0);
            }
            JScrollPane tableScroll = new JScrollPane((Component)((Object)this._mappingTable));
            this._mappingTablePanel.add(tableScroll);
            this._mappingTable.getRowHeader().sizeRowsToFit(false, true);
        }
        this.getInfoTabber().removeAll();
        Map comps = this.getInformativeComponents();
        if (comps != null) {
            Set keyset = comps.keySet();
            int count = 0;
            for (String key : keyset) {
                JPanel tabPanel = new JPanel();
                tabPanel.setLayout((LayoutManager)new AutoSizingGridLayout(1, 1, 5, 5, true, true, true));
                tabPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                tabPanel.add((JComponent)comps.get(key));
                String label = Util.getLabelWithoutMnemonic((String)key);
                int index = Util.getDisplayedMnemonicIndex((String)key);
                this.getInfoTabber().addTab(label, tabPanel);
                if (index != -1) {
                    int mnemonic = Util.getDisplayedMnemonic((String)key);
                    this.getInfoTabber().setDisplayedMnemonicIndexAt(count, index);
                    this.getInfoTabber().setMnemonicAt(count, mnemonic);
                }
                ++count;
            }
        }
        int prefSize = 0;
        if (this._mappingTable != null) {
            prefSize = this._mappingTable.getPreferredSize().height + this._mappingTable.getTableHeader().getPreferredSize().height + 4;
        }
        this._rowPartitioner = new ProportionalSpacePartitioner(new double[]{-2.0, 0.5, 0.5}, new int[]{0, 75, 75}, new int[]{Integer.MAX_VALUE, Math.max(75, prefSize), Integer.MAX_VALUE}, true);
        this._mappingLayout.setRowSpacePartitioner((SpacePartitionerInterface)this._rowPartitioner);
        if (!this.hasBeenShown()) {
            this._infoTabber.getModel().addChangeListener(this);
            this.updateTab();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InformationalConnectionPanel.this._mappingTable.getRowModel().getSelectionModel().addListSelectionListener(InformationalConnectionPanel.this);
            }
        });
        this.setHasBeenShown(true);
    }

    protected TableCellRenderer getTableCellRenderer() {
        MyTableCellRenderer renderer = new MyTableCellRenderer();
        renderer.setTransform(this.getTargetTableTransform());
        return renderer;
    }

    protected TransformInterface getTargetTableTransform() {
        if (this._tableTransform == null) {
            this._tableTransform = new ObjectToStringTransform();
            ((ObjectToStringTransform)this._tableTransform).setNullString("");
        }
        return this._tableTransform;
    }

    public Map getInformativeComponents() {
        if (this._infoComponentsMap == null) {
            this._infoComponentsMap = new LinkedHashMap(1);
        }
        if (this._dependentComponent == null) {
            this._dependentComponent = new DependentObjectsComponent();
            this._infoComponentsMap.put(this._dependentComponent.getLabel(), this._dependentComponent);
        }
        return this._infoComponentsMap;
    }

    public Map getMappingsForTarget() {
        if (this._targetMapping == null) {
            this._targetMapping = new LinkedHashMap();
            if (this._connectionPoints != null) {
                for (Object obj : this._connectionPoints) {
                    if (!(obj instanceof SourceConnectionInterface)) continue;
                    SourceConnectionInterface source = (SourceConnectionInterface)obj;
                    this._targetMapping.put(source, null);
                }
            }
        }
        return this._targetMapping;
    }

    public JTabbedPane getInfoTabber() {
        return this._infoTabber;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e != null && !e.getValueIsAdjusting()) {
            Object source = e.getSource();
            if (this._mappingTable != null && source == this._mappingTable.getRowModel().getSelectionModel()) {
                this.updateTab();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source;
        if (e != null && (source = e.getSource()) == this._infoTabber.getModel()) {
            this.updateTab();
        }
    }

    protected void updateTab() {
        int row;
        JPanel panel;
        Component comp = this.getInfoTabber().getSelectedComponent();
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0 && (comp = panel.getComponent(0)) instanceof AbstractPromotionPanel && this._mappingTable != null && (row = this._mappingTable.getSelectedRow()) != -1) {
            Map map = this.getMappingsForTarget();
            Object[] values = map.keySet().toArray();
            Object value = values[row];
            ((AbstractPromotionPanel)comp).loadComponent(value, null);
        }
    }

    class TableModel
    extends AbstractTableModel {
        TableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            Map map = InformationalConnectionPanel.this.getMappingsForTarget();
            return map == null ? 0 : map.size();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return InformationalConnectionPanel.this.getTableSourceColumnName();
            }
            return InformationalConnectionPanel.this.getTableTargetColumnName();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map map = InformationalConnectionPanel.this.getMappingsForTarget();
            Object[] values = map.keySet().toArray();
            Object value = values[row];
            if (value instanceof SourceConnectionInterface) {
                SourceConnectionInterface sourceValue = (SourceConnectionInterface)value;
                if (col == 0) {
                    return InformationalConnectionPanel.this.getTableSourceColumnValue(sourceValue);
                }
                return InformationalConnectionPanel.this.getTableTargetColumnValue(sourceValue);
            }
            return RB.getStringResource("Common.Unknown.txt");
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return SourceConnectionInterface.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }
    }

    class SortingComparator
    extends GenericComparator {
        public int compare(Object a, Object b) {
            int compare = super.compare(a, b);
            if (compare == Integer.MAX_VALUE) {
                Object compA = this.makeObjectsComparable(a);
                Object compB = this.makeObjectsComparable(b);
                if (compA != null && compB != null) {
                    return this.compare(compA, compB);
                }
            }
            return compare;
        }

        private Object makeObjectsComparable(Object a) {
            if (a != null) {
                return a.toString();
            }
            return null;
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private TransformInterface _transform;

        public void setTransform(TransformInterface transform) {
            this._transform = transform;
        }

        @Override
        protected void setValue(Object value) {
            if (this._transform != null) {
                try {
                    value = this._transform.transform(value);
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            this.setText(value == null ? "" : value.toString());
        }
    }
}

